# -*- coding: UTF-8 -*-
import traceback
import re
MAX_RETRYS = 5

#Exit to cli model, make sure the next item exec successful
def exit2cli(cli):
    index =0 
    cliRet = cli.execCmdNoLog("show system general")
    
    #密码输入错误时及正常情况从developer模式下退出
    if -1 != cliRet.find("Password") or -1 != cliRet.find("developer:/>"):
        cliRet = cli.execCmd("exit")
        PY_LOGGER.info("Sequence[72] change to cli model")
        while(-1 == cliRet.find(":/>")):
            index+=1
            cliRet = cli.execCmd("exit")
            if -1!=cliRet.find("Are you sure to exit?(y/n):"):
                cliRet = cli.execCmd("n")
            if index>MAX_RETRYS:
                break
        
def execute(cli):
    """
    Create date        : 2014/04/25
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show remote_lun single_link")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        inDeveloper = False
        lang = py_java_env.get("lang")
        errMsg = ""
        filterCmd = ""
        cliRet = cli.execCmd("change user_mode current_mode user_mode=developer")
        list = cliRet.splitlines()
        i = 0
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[72] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            
        password = str(py_java_env.get("devPwd").get("developer"))
        if(None == password or ""== password):
            PY_LOGGER.info("Sequence[72] password is NULL, out!")
            flag = False
            exit2cli(cli)
            if "zh" == lang:
                errMsg = u"\n获取developer密码为空，请确定是否已配置密码"
            else:
                errMsg = "\nGet the password of developer is null, make sure to configure it right"
            return (flag, cliRet, errMsg)
        cliRet += cli.execCmdNoLog(password)

        #whether enter to the developer mode successful
        if cliRet.find("developer:/>") == -1:
            flag = False
            PY_LOGGER.info("Sequence[72] can not access develoer mode")
            exit2cli(cli)
            if "zh" == lang:
                if cliRet.find("Password is wrong") != -1 or -1!=cliRet.find("Password:"):
                    errMsg = u"\ndeveloper密码配置错误"
                else:
                    errMsg = u"\n系统不能进入developer模式，请确认系统处于admin模式"
            else:
                if cliRet.find("Password is wrong") != -1 or -1!=cliRet.find("Password:"):
                    errMsg = "\nThe password of developer is wrong"
                else:
                    errMsg = "\nIt failed to access the developer mode, please confirm system in admin mode"
            return (flag, cliRet, errMsg)
        inDeveloper = True

        filterCmd = "|filterRow column=Is\sSingle\sLink predict=equal_to value=Yes"
        cliRet = cli.execCmd("show remote_lun single_link " + filterCmd)
        PY_LOGGER.info("\nSequence[72] execute command result:\n" + cliRet)
        list = cliRet.splitlines()
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[72] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[72]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            i = i+1
            
            #If more than 3 lines its means have lun with single link
            if i > 3:
                flag = False
                if "zh" == lang:
                    errMsg = u"\n远端LUN链路状态检测为单链路"
                else:
                    errMsg = "\nThe link status of remote lun is single"
                break
        if inDeveloper == True:
            exit2cli(cli)
            inDeveloper = False
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[72] catch except of check remote lun link.")
        PY_LOGGER.error("Sequence[72] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[72] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[72] catch except of trace back:" + str(traceback.format_exc()))
        flag = False
        if inDeveloper:
            exit2cli(cli)
            inDeveloper = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
