# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/08/06
    Function name      : execute(cliConnection)
    Function describe  : check consistency stauts
    Input              : cli--Telnet acess proxy 
                         e.g: cliRet = cli.execCmd("show consistency_group general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = cli.execCmd("show consistency_group general")
        PY_LOGGER.info("\nSequence[86] execute command result:\n" + cliRet)
        
        list = cliRet.splitlines()
        i = 0
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[86] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            
            if re.search("license", field, re.IGNORECASE):       
                continue
            
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[86]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if field.startswith("Command"):
                flag = True
                return (flag, cliRet)
            i = i + 1
            if i > 4:
                list1 = field.split()
                if -1 != list1[0].find(":/>"):
                    break
                if (len(list1) >= 7) and ("Normal" != list1[2]):
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n一致性组[" + list1[0] + u"]状态检测异常"
                    else:
                        errMsg += "\nThe status of consistency group[" + list1[0] + "] is abnormal"
                     
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[86] catch except of check consistency stauts.")
        PY_LOGGER.error("Sequence[86] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[86] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[86] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
