# -*- coding: UTF-8 -*-
import traceback
import re

def change2cli(cli):
    index =0 
    cliRet = cli.execCmdNoLog("show system general")
    
    #密码输入错误时及正常情况从developer模式下退出
    if -1 != cliRet.find("Password") or -1 != cliRet.find("developer:/>"):
        cliRet = cli.execCmd("exit")
        PY_LOGGER.info("Sequence[5] change to cli model")
        while(-1 == cliRet.find(":/>")):
            index+=1
            cliRet = cli.execCmd("exit")
            if -1!=cliRet.find("Are you sure to exit?(y/n):"):
                cliRet = cli.execCmd("n")
            if index>MAX_RETRYS:
                break


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showdisk -logic")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        inDeveloper = False
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = str(cli.execCmd("change user_mode current_mode user_mode=developer"))
        password = str(py_java_env.get("devPwd").get("developer"))
        if(None == password):
            PY_LOGGER.info("The password is NULL, out!")
            flag = False
            if "zh" == lang:
                errMsg = u"\n获取developer密码失败"
            else:
                errMsg = "\nIt failed to get the password of developer"
            return (flag, cliRet, errMsg)
        cliRet += cli.execCmdNoLog(password)
        
        if cliRet.find("developer:/>") == -1:
            flag = False
            PY_LOGGER.info("Sequence[5] can not access develoer mode")
            if "zh" == lang:
                if cliRet.find("Password is wrong") != -1:
                    errMsg = u"\ndeveloper密码配置错误"
                else:
                    errMsg = u"\n系统不能进入developer模式，请确认系统处于admin模式"
            else:
                if cliRet.find("Password is wrong") != -1:
                    errMsg = "\nThe password of developer is wrong"
                else:
                    errMsg = "\nIt failed to access the developer mode, please confirm system in admin mode"
            return (flag, cliRet, errMsg)
        inDeveloper = True
        cliRet = str(cli.execCmd("show disk ncq"))
        PY_LOGGER.info("\nSequence[9] execute command result:\n" + cliRet)
        
        list = cliRet.splitlines()
        i = 0
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                if inDeveloper == True:
                    change2cli(cli)
                    inDeveloper = False
                flag = False
                PY_LOGGER.info("Sequence[9] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                if inDeveloper == True:
                    change2cli(cli)
                    inDeveloper = False
                flag = False
                PY_LOGGER.info("There is an error in Sequence[9]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            i = i + 1
            if i >= 5:
                list2 = field.split()
                if len(list2) < 2:
                    continue
                if list2[1] != "Yes" and list2[1] != "No":
                    flag = False
                    if inDeveloper == True:
                        change2cli(cli)
                        inDeveloper = False
                    if "zh" == lang:
                        errMsg = u"\n硬盘ncq属性异常("+list2[1]+u")"
                    else:
                        errMsg = "\nThe ncq property of disk is abnormal("+list2[1]+")"
                    return (flag, cliRet, errMsg)
                
        if inDeveloper == True:
            change2cli(cli)
            inDeveloper = False
        return (flag, cliRet)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[9] catch except of check disk NCQ status.")
        PY_LOGGER.error("Sequence[9] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[9] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[9] catch except of trace back:" + str(traceback.print_exc()))
        if inDeveloper == True:
            change2cli(cli)
            inDeveloper = False
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
