# -*- coding: UTF-8 -*-

import traceback
import util


def execute(cli):
    '''
    @summary: 检查项入口函数
    '''
    lang = py_java_env.get("lang")
    logger = PY_LOGGER
    cliRet = ""
    errMsg = ""
    bugProductModelList = ['5600 V3', '5800 V3', '6800 V3', '6900 V3']
    bugVersionList = ["V300R001C00"]

    #检查产品型号
    result, cmdRet, productModel = util.getProductModel(cli)
    cliRet += cmdRet
    if not result:
        if "zh" == lang:
            errMsg = u"\查询产品型号失败。"
        else:
            errMsg = u"\nFailed to query the product model."
        return (False, cliRet, "")
    
    if productModel not in bugProductModelList:
        return ("NOSUPPORT", cliRet, "")
    
    #检查产品版本号
    getSucc, sysVerCliRet, currentVersion = util.getProductFullVersion(cli)
    cliRet += sysVerCliRet
    if not getSucc:
        if "zh" == lang:
            errMsg += u"\n查询系统版本号失败。"
        else:
            errMsg += u"\nFailed to query the system product version."
        return (False, cliRet, errMsg) 
    
    if currentVersion not in bugVersionList:
        return (True, cliRet, errMsg)
    
    #获取硬盘扇区大小
    result, cmdRet, sectorSizeDictList, errMsgDict = util.getDiskSectorSize(cli)
    cliRet += cmdRet
    if not result:
        if "zh" == lang:
            errMsg += errMsgDict["zh"]
        else:
            errMsg += errMsgDict["en"]
        return (False, cliRet, errMsg)
    
    #检查扇区大小是否为4096B或4160B
    result, is4KDiskList, errMsgDict = util.is4KDiskWithSectorSize(sectorSizeDictList)
    if "zh" == lang:
        errMsg += errMsgDict["zh"]
    else:
        errMsg += errMsgDict["en"]
    if result:
        return (False, cliRet, errMsg)
    
    return (True, cliRet, errMsg)
    
    
    
