 root=$LEGO_HOME;
 baseDir="$root"/Runtime/LegoRuntime
 dir=`pwd`;
 #########checklog begin###########
 writeResultOfLogCheck()
 {
    echo "<?xml version=\""1.0"\" encoding=\""UTF-8"?>"\" 
    echo "<device>"
    echo "        <cmditem id=\""$1"\">"

    if [ -d "$baseDir"  ]
    then
        cd "$baseDir"/logs/ISM/

        echo "      <item id=\""$10"\">"
        checkDiskVolume
        echo "      </item>"
        echo "    </cmditem>"
        echo "</device>"
    else

        echo "      <item id=\""$10"\">"
        echo "          <errorvalue type=\"0\">ISM server not installed</errorvalue>"
        echo "              <judge>"1"</judge>"
        echo "      </item>"
        echo "    </cmditem>"
        echo "</device>"
    fi
} 

checkDiskVolume()
{
  temp=`df -m "$baseDir"| tail -n1|awk '{print $4}'`
  freeCap=`echo "scale=2;$temp / 1024" | bc`
  if echo $freeCap-1.0|bc|grep -E '^-' ; then
       echo "           <errorvalue type=\"0\">0"$freeCap"G</errorvalue>"
       echo "                  <judge>"1"</judge>"
  elif echo $freeCap-5.0|bc|grep -E '^-' ; then
       echo "           <errorvalue type=\"0\">"$freeCap"G</errorvalue>"
       echo "                  <judge>"1"</judge>"
 else
       echo "           <commonvalue type=\"0\">"$freeCap"G</commonvalue>"
       echo "                  <judge>"0"</judge>"
 fi
 
}
 
 #########checkResource begin###########
writeResultOfResourceCheck()
 {
    echo "<?xml version=\""1.0"\" encoding=\""UTF-8"?>"\"
    echo "<device>"
    echo "      <cmditem id=\""$1"\">"
    
    echo "        <item id=\""$10"\">"
    checkMemory
    echo "        </item>"
    echo "        <item id=\""$11"\">"
    checkCpu
    echo "        </item>"
  
    echo "      </cmditem>"
    echo "</device>"
  }
 checkMemory()
 {
 memStr=`free | grep 'Mem: '`
used=`echo $memStr | awk -F" " '{print $3}'`
total=`echo $memStr | awk -F" " '{print $2}'`
tmp=`expr $used \* 100`
usage=`expr $tmp / $total`
 if [[ $usage -lt 80 ]];then
  echo "           <commonvalue type=\"0\">"$usage"%</commonvalue>"
  echo "                  <judge>"0"</judge>"
 else
  echo "           <errorvalue type=\"0\">"$usage"%</errorvalue>"
  echo "                  <judge>"1"</judge>"
 fi
}

checkCpu()
 {
cpuGeneral=`vmstat | awk -F ' ' 'NR==3{print $15}'`
cpuWa=`vmstat | awk -F ' ' 'NR==3{print $16}'` 
usage=`echo "100-$cpuGeneral-$cpuWa " |bc`
 if [[ $usage -lt 80 ]];then
  echo "           <commonvalue type=\"0\">"$usage"%</commonvalue>"
  echo "                  <judge>"0"</judge>"
 else
  echo "           <errorvalue type=\"0\">"$usage"%</errorvalue>"
  echo "                  <judge>"1"</judge>"
 fi
}

writeResultOfServerCheck()
 {
    echo "<?xml version=\""1.0"\" encoding=\""UTF-8"?>"\"
    echo "<device>"
    echo "      <cmditem id=\""$1"\">"
    
        echo "        <item id=\""$10"\">"
        checkJVMRunning
        echo "        </item>"

        echo "        <item id=\""$14"\">"
        checkIsmHttpsPort
        echo "        </item>"
        echo "        <item id=\""$15"\">"
        checkJVMMemory
        echo "        </item>"
    
    echo "      </cmditem>"
    echo "</device>"
  }

checkJVMMemory()
 {
javaId=`ps -efww | grep java | grep equinox.jar | awk '{print $2}'`
if (( ${#javaId} !=0 ));then 
temp1=`grep 'VmRSS:' /proc/$javaId/status`
temp=`echo $temp1 |awk -F" " '{print $2}'`
usage=`echo "scale=0; $temp / 1024" | bc`
usedStr=''
    if (( $usage < 1024 ))
    then
            usedStr="$usage"M
    else
            usedStr=`echo "scale=2; $usage / 1024" | bc`G
    fi
        if (( $usage < 2048 ))
        then
          echo "           <commonvalue type=\"0\">"$usedStr"</commonvalue>"
          echo "                  <judge>"0"</judge>"
        else
          echo "           <errorvalue type=\"0\">"$usedStr"</errorvalue>"
          echo "                  <judge>"1"</judge>"
         fi
 else
   echo "           <errorvalue type=\"0\">ISM server not running</errorvalue>"
  echo "                  <judge>"1"</judge>"
 fi
}

  #########checkJVMRunning begin###########
checkJVMRunning()
{
  javaId=`ps -efww | grep java | grep equinox.jar | awk '{print $2}'`
  if (( ${#javaId} !=0 ));then
        echo "           <commonvalue type=\"0\">PID $javaId</commonvalue>"
        echo "                  <judge>"0"</judge>"
 else
        echo "           <errorvalue type=\"0\">ISM server not running</errorvalue>"
        echo "                  <judge>"1"</judge>"
    fi
}
 #########checkIsmServerPort begin###########
 checkIsmHttpPort()
{
  javaId=`ps -efww | grep java |grep jre6.0|grep  org.apache.juli.ClassLoaderLogManager | awk '{print $2}'`
  if (( ${#javaId} !=0 ));then 
          httpConf=`grep '<Connector port'  /"$root"/Runtime/Tomcat6/conf/server.xml |grep HTTP/1.1 |grep redirectPort`
          httpPort=`echo $httpConf |awk -F\" '{print $2}'`
          temp=`sudo lsof -i:$httpPort`
          result=`echo $temp | awk -F$javaId '{print $1}'`
          if (( ${#result} !=0 ));then
             echo "           <commonvalue type=\"0\">Http port $httpPort</commonvalue>"
             echo "                   <judge>"0"</judge>"
             else
              echo "           <errorvalue type=\"0\"></errorvalue>"
                echo "                  <judge>"1"</judge>"
             fi
     else
      echo "           <errorvalue type=\"0\">ISM server not running</errorvalue>"
      echo "                  <judge>"1"</judge>"
     fi
}
checkIsmHttpsPort()
{
  javaId=`ps -efww | grep java |grep jre6.0|grep  org.apache.juli.ClassLoaderLogManager | awk '{print $2}'`
  if (( ${#javaId} !=0 ));then 
          httpsConf=`grep '<Connector'  /${root}/Runtime/Tomcat6/conf/server.xml |grep com.huawei.lego.tomcat.http.LegoHttp11Protocol | grep https`
          httpsPort=`echo $httpsConf |awk -F\" '{print $8}'`
          temp=`sudo lsof -i:$httpsPort`
          result=`echo $temp | awk -F$javaId '{print $1}'`
          if (( ${#result} !=0 ));then
                         echo "           <commonvalue type=\"0\">Https port $httpsPort</commonvalue>"
                         echo "                   <judge>"0"</judge>"
             else
                      echo "           <errorvalue type=\"0\"></errorvalue>"
                echo "                  <judge>"1"</judge>"
             fi
    else
        echo "           <errorvalue type=\"0\">ISM server not running</errorvalue>"
          echo "                  <judge>"1"</judge>"
     fi
}
if (($2 == 2));then
writeResultOfLogCheck 2
elif (($2 == 3));then
writeResultOfResourceCheck 3
elif (($2 == 4));then
writeResultOfServerCheck 4
fi

