# -*- coding: UTF-8 -*-
import datetime
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        过载告警检查； 
        步骤1 使用admin账户登录；
        步骤2 执行命令：show system general获取系统当前时间，以当前时间为标准计算30天前的时间；
        步骤3 执行命令：show event object_type=269 from_time=time|
                filterRow column=ID predict=equal_to value=0x100F01060063 
                logicOp=and column=Name predict=equal_to value=Controller\sIs\sOverloaded
                                         查看历史30天内的告警记录，time为步骤2中获取的30天前的时间，格式为year-month-day/00:00:00。

    '''
    
    allCliRet = ""
    errMsg = ""
    
    try:
        cmd = "show event object_type=269 from_time=%s|filterRow column=ID " \
              "predict=equal_to value=0x100F01060063 logicOp=and column=Name " \
              "predict=equal_to value=Controller\sIs\sOverloaded logicOp=or " \
              "column=Name predict=equal_to value=The\sController\sIs\sOverloaded"
        
        #获取当前时间
        timeRet = cliUtil.getCurrentTime(cli, LANG, LOGGER)
        allCliRet += timeRet[1]
        errMsg += timeRet[2]
        
        if timeRet[0] != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet,errMsg)
        
        currentTime = timeRet[-1]
        dateObj = datetime.datetime.strptime(currentTime,"%Y-%m-%d/%H:%M:%S")+datetime.timedelta(days=-30)
        startTime = dateObj.strftime("%Y-%m-%d/%H:%M:%S") 
        cmd = cmd % startTime
        
        execRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet = execRet[1]
        allCliRet += cliRet
        
        #命令执行失败
        #正常告警回显Name中可能包含is not supported，造成公共方法误报不涉及
        #加入"----"关键字识别，若包含该分隔符，则认为正常回显，消除不支持虚拟机误报
        if execRet[0] != True and "----" not in cliRet:
            errMsg += execRet[2]
            return (cliUtil.RESULT_NOCHECK, allCliRet,errMsg)
         
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, allCliRet, errMsg)
        
        #如果执行到这里才返回，说明回显正常，且有记录。在此巡检项中，有告警记录则检查结果为建议优化
            
        return (cliUtil.RESULT_WARNING, allCliRet,common.getMsg(LANG, "controller.overload.alarm"))
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
