# -*- coding: UTF-8 -*-
import cliUtil
import common
from cbb.business.operate.checkitems import check_nfs_switch_match
from cbb.frame.checkitem.context_adapter import InspectContext
from cbb.frame.cli.cliUtil import hasAdminOrSuperAdminPrivilege

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)


def execute(cli):
    """
    NFS4.1服务开关检查
    """
    PY_JAVA_ENV["logger"] = PY_LOGGER
    PY_JAVA_ENV["lang"] = LANG
    status, is_admin, err_msg = hasAdminOrSuperAdminPrivilege(cli, LANG)
    if is_admin is not True:
        err_msg = common.getMsg(LANG, "loginUser.name.level.must.be.super.admin")
        return cliUtil.RESULT_NOCHECK, "", err_msg
    inspect_context = InspectContext(PY_JAVA_ENV, cli)
    status, err_msg, _, cli_ret = \
        check_nfs_switch_match.execute(inspect_context.get_context())
    return inspect_context.get_result(status, err_msg, cli_ret)
