# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import cliUtil
import common
import dpa_common
from java.lang import Exception as JException
from common_utils import get_dpa_rest_record

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALARM_CONTENT = (
    [0, u"下线主机"], [0, u"状态异常"], [0, u"容量使用率"], [3, "Host"], [2, "abnormal"], [2, "the current system exceeds"]
)
DAY = 24
HOUR = 60
MINUTE = 60
SECOND = 1000


def execute(dpa_rest):
    err_msg = ""
    record = ""
    try:
        time_stamp, record = dpa_common.get_time_stamp(dpa_rest, PY_JAVA_ENV, LOGGER)
        if not time_stamp:
            # 未添加DPA对应节点主机或回显不符合预期
            return cliUtil.RESULT_NOCHECK, record, common.getMsg(LANG, "dpa.get.device.node.abnormal")
        for level, content in ALARM_CONTENT:
            checked_record, checked_err_msg = check_alarm_info(dpa_rest, time_stamp, level, content)
            if checked_err_msg:
                err_msg += checked_err_msg
            record = "{}\n{}".format(record, checked_record)
        if err_msg:
            return False, record, err_msg
        return True, record, ""
    except Exception as e:
        LOGGER.logError(str(e))
        return cliUtil.RESULT_NOCHECK, record, common.getMsg(LANG, "query.result.abnormal")


def check_alarm_info(dpa_rest, end_time, level, content):
    start_time = int(end_time) - 3 * DAY * HOUR * MINUTE * SECOND
    url_param = '{{"warnStatus":1,"sTime":{},"eTime":{},"level":{},"content":"{}"}}'.format(
        str(start_time), end_time, level, content)
    node_query_uri = '/logs/warn/system_warn?count=15&filter={}&index=0'.format(
        dpa_common.parse_quote(url_param, 'utf-8'))
    record = get_dpa_rest_record(dpa_rest, node_query_uri)
    alarm_info = record.get("responseData", {})
    if int(alarm_info.get("totalNum")) > 0:
        LOGGER.logNoPass("The device has alarm.({})".format(content))
        return record, common.getMsg(LANG, "dpa.check.cdm.alarms.abnormal", content)
    return record, ""
