# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import time

import cliUtil
import common
import dpa_common
from java.lang import Exception as JException
from common_utils import get_dpa_rest_record

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
# 接口返回列表最多个数
MAX_CONTENT_COUNT = 15
HOUR = 60
MINUTE = 60
SECOND = 1000


def execute(dpa_rest):
    time_stamp, record = dpa_common.get_time_stamp(dpa_rest, PY_JAVA_ENV, LOGGER)
    if not time_stamp:
        # 未添加DPA对应节点主机或回显不符合预期
        return cliUtil.RESULT_NOCHECK, record, common.getMsg(LANG, "dpa.get.device.node.abnormal")
    flag, status_record, err_msg = check_self_backup_job(dpa_rest, time_stamp)
    record = "{}\n{}".format(record, status_record)
    return flag, record, err_msg


def check_self_backup_job(dpa_rest, now_stamp):
    record = ""
    err_msg = ""
    try:
        node_query_uri = "/updates/self/jobs?count=1&index=0"
        record = get_dpa_rest_record(dpa_rest, node_query_uri)
        dev_self_backup_job = record.get("responseData", {}).get("data", [{}])
        if not dev_self_backup_job:
            err_msg += common.getMsg(LANG, "dpa.self.backup.status.abnormal")
            return False, record, err_msg
        err_msg, tem_record = check_job_log(dpa_rest, str(dev_self_backup_job[0].get("id")))
        record = "{}\n{}".format(record, tem_record)
        LOGGER.logInfo("now_stamp:{},time_stamp:{}".format(now_stamp, str(dev_self_backup_job[0].get("timePoint"))))
        time_point = time.strptime(str(dev_self_backup_job[0].get("timePoint")), '%Y-%m-%d-%H:%M:%S')
        time_stamp = time.mktime(time_point)
        if int(now_stamp) - (int(time_stamp) * SECOND) > 24 * HOUR * MINUTE * SECOND:
            err_msg += common.getMsg(LANG, "dpa.self.backup.status.abnormal")
        elif dev_self_backup_job[0]["status"] != 32:
            err_msg += common.getMsg(LANG, "dpa.self.backup.status.abnormal")
        if err_msg:
            return False, record, err_msg
        return True, record, ""
    except Exception as e:
        LOGGER.logError(str(e))
        return cliUtil.RESULT_NOCHECK, record, common.getMsg(LANG, "query.result.abnormal")


def check_job_log(dpa_rest, job_id):
    err_msg = ""
    # 传入备份任务id和下标0查询第一条记录时间
    record, first_log_time = get_job_log_time(dpa_rest, job_id, 0)
    total_num = record.get("responseData", {}).get("totalNum")
    if total_num < MAX_CONTENT_COUNT:
        # 回显total_num小于count值（15），已查询到最后一条记录
        final_log_time = record.get("responseData", {}).get("data", [{}])[total_num - 1].get("createdTime")
    else:
        # 回显total_num大于等于count值（15），未查询到最后一条记录，执行命令查询最后一条记录时间
        tem_record, final_log_time = get_job_log_time(dpa_rest, job_id, total_num - 1)
        record = "{}\n{}".format(record, tem_record)
    if int(first_log_time) - int(final_log_time) > 15 * MINUTE * SECOND:
        err_msg += common.getMsg(LANG, "dpa.self.backup.runtime.abnormal")
    return err_msg, record


def get_job_log_time(dpa_rest, job_id, index):
    node_query_uri = "/updates/self/{}/logs?count={}&index={}".format(job_id, MAX_CONTENT_COUNT, index)
    record = get_dpa_rest_record(dpa_rest, node_query_uri)
    log_time = record.get("responseData", {}).get("data", [{}])[0].get("createdTime")
    return record, log_time
