# -*- coding: UTF-8 -*-
import cliUtil
import common

NEED_RETRY = False
RETRIED = False
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
          主机端口IP配置检查：
        1、如果Subnet_Mask字段的内容长度大于14字节则属于不正常状态
        2、其他属于正常状态
    '''
    flag = True
    cliRetList = list()
    errMsgList = list()
    errMsg = ''
 
    #注释：步骤二
    try:
        cmd = "show upgrade package"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        cliRetList.append(cliRet)
        cliRetHotPatch = cliRet.split("HotPatch Version")[1]
        cliRet = cliRet.split("HotPatch Version")[0]
        
        
        cliRetDictList = cliUtil.getHorizontalCliRet(cliRet)
        LOGGER.logNoPass("curVersion:%s" % cliRetDictList)
        if "Current Version" in cliRetDictList[0]:
            curVersion = cliRetDictList[0].get("Current Version")
            if "B" in curVersion:
                curVersion = curVersion[0:curVersion.find("B")]
            
        LOGGER.logNoPass("curVersion:%s" % type(curVersion))
        LOGGER.logNoPass("curVersion:%s" % cliRetDictList)
        ProductList = ['V300R002C00','V300R002C00SPC100','V300R002C10','V300R002C10SPC100']
        if curVersion not in ProductList:
            LOGGER.logNoPass("curVersion0:%s" % curVersion) 
            return (cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
        
        if curVersion == 'V300R002C10SPC100':
        #注释：步骤三
            hotPatchExistFlag = True
            cliRetHotPatchDictList = cliUtil.getHorizontalCliRet(cliRetHotPatch)
            LOGGER.logNoPass("hotVersion:%s" % cliRetHotPatchDictList)
            for cliRetHotPatchInfo in cliRetHotPatchDictList:
                if "Current Version" in cliRetHotPatchInfo:
                    hotPatchCurVersion = cliRetHotPatchInfo["Current Version"]
                    if "B" in hotPatchCurVersion:
                        hotPatchCurVersion = curVersion[0:curVersion.find("B")]
                    if hotPatchCurVersion in ["--", ""]:
                        hotPatchExistFlag = False
                        break
                    if hotPatchCurVersion >= "V300R002C10SPH102":
                        continue
                    else:
                        hotPatchExistFlag = False
            
            if hotPatchExistFlag:
                cliRet = "\n".join(cliRetList)
                LOGGER.logPass()
                return (True, cliRet, errMsg)
        #注释：步骤四                
        cmd = "show port general logic_type=Host_Port physical_type=ETH "
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            LOGGER.logNoPass("curVersion1:%s" % curVersion)
            return checkRet
        
        cliRet = checkRet[1]
        cliRetList.append(cliRet)
        cliRetDictList = cliUtil.getHorizontalCliRet(cliRet)
        idList = list()
        for item in cliRetDictList:
            if "." in item["IPv4 Address"]:
                idList.append(item.get("ID"))       
        
        LOGGER.logNoPass("dList:%s" % idList)        
        resultFlag = True
        for portId in idList:
            cmd = "show port general port_id=%s" % portId       
            LOGGER.logExecCmd(cmd)
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
            if checkRet[0] != True: 
                LOGGER.logSysAbnormal()
                LOGGER.logNoPass("curVersion3:%s" % curVersion)
                return checkRet
        
            cliRet = checkRet[1]
            cliRetList.append(cliRet)
            cliRetDictList = cliUtil.getVerticalCliRet(cliRet)
            
            for item in cliRetDictList:
                if "Subnet Mask" in item:
                    subnetMask = item.get("Subnet Mask")
                    if len(subnetMask) > 14:
                        errMsg = common.getMsg(LANG, "ethport.subnetmask.longer", (portId, len(subnetMask)))
                        errMsgList.append(errMsg)
                        resultFlag = False
                        
        cliRet = "\n".join(cliRetList)
        if resultFlag:
            LOGGER.logPass()
        else:
            LOGGER.logNoPass("woqu:%s"%errMsg)
            errMsg = "\n".join(errMsgList)
            LOGGER.logNoPass("woqu2:%s"%errMsg)
            
        return (resultFlag, cliRet, errMsg)              
                        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))        
    
        