# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    '''
    CPU占用率检查：
        CPU占用率小于等于80%属于正常，否则属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show controller general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG,
                                              cliUtil.endWithSignToAdmin)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return checkRet

        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.cpu.usage.info")
            LOGGER.logNoPass("Cannot get information about CPU Usage(%)")
            return (False, cliRet, errMsg)

        for retDict in cliRetLinesList:
            ctrlId = retDict.get("Controller")
            cpuUsage = retDict.get("CPU Usage(%)")
            cpuUsagePercent = cpuUsage + "%"
            cpuUsageThresholdPercent = str(
                common.THRESHOLD_CONTRL_CPU_USAGE) + "%"
            cpuUsageThresholdLevel2Percent = str(
                common.LEVEL2_THRESHOLD_CONTRL_CPU_USAGE) + "%"
            if not (cpuUsage.isdigit() and int(
                    cpuUsage) <= common.THRESHOLD_CONTRL_CPU_USAGE):
                flag = False
                errMsg += common.getMsg(LANG, "controller.cpu.usage.abnormal",
                                        (ctrlId, cpuUsageThresholdPercent,
                                         cpuUsagePercent))
                LOGGER.logNoPass(
                    "The CPU usage of controller [%s] "
                    "exceeds %s (CPU usage:%s)" %
                    (ctrlId, cpuUsageThresholdPercent, cpuUsagePercent))
            elif not (cpuUsage.isdigit() and int(
                    cpuUsage) <= common.LEVEL2_THRESHOLD_CONTRL_CPU_USAGE):
                if flag:
                    flag = cliUtil.RESULT_WARNING
                errMsg += common.getMsg(LANG,
                                        "controller.cpu.usage.level2.abnormal",
                                        (
                                            ctrlId,
                                            cpuUsageThresholdLevel2Percent,
                                            cpuUsageThresholdPercent,
                                            cpuUsagePercent))
                LOGGER.logNoPass(
                    "The CPU usage of controller [%s] exceeds %s "
                    "and is less than or equal to %s (CPU usage: %s)" %
                    (ctrlId, cpuUsageThresholdLevel2Percent,
                     cpuUsageThresholdPercent, cpuUsagePercent))
        if flag:
            LOGGER.logPass()

        return (flag, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet,
                common.getMsg(LANG, "query.result.abnormal"))
