# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    """
    硬盘的固件版本检查
    1 如果硬盘的检查标准满足以下条件之一，则检查结果为建议优化。
     1） Model为HUS156060VLS600，且Firmware Version为A510,A760其中之一；
     2） Model为HUS156060VLF400，且Firmware Version为fT02,F510其中之一；
"""
    flag = True
    cliRet = ""
    errMsg = ""
    bugDiskIDList = []
    #存在问题的固件Model与对应的FW
    bugFWVersionMap = {
                    "HUS156060VLS600":("A510","A760"),
                    "HUS156060VLF400":("FT02","F510"),
                    }

    #存放无法获取固件版本值的硬盘
    errInfoDiskIDList = []  
    try:

        cmd = "show disk general |filterColumn " \
              "include columnList=ID,Model," \
              "Firmware\\sVersion,Bar\\sCode"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            return checkRet

        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.diskinfo")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0

        for line in cliRetLinesList:
            diskID = line.get("ID","")
            model = line.get("Model","")
            FWVersion = line.get("Firmware Version","")
            bugVersionList = bugFWVersionMap.get(model)
            if FWVersion == "" or FWVersion == "--":
                errInfoDiskIDList.append(diskID)
                continue
            if not bugVersionList:
                continue
            if FWVersion.upper() in bugVersionList:
                bugDiskIDList.append(diskID)

        LOGGER.logNoPass("bugDiskIDList:" + str(bugDiskIDList))
        if bugDiskIDList:
            flag = cliUtil.RESULT_WARNING
            errMsg = common.getMsg(LANG, "low.fmversion.disk.info",", ".join(bugDiskIDList))

        if errInfoDiskIDList:
            flag = False
            errMsg += common.getMsg(LANG, "canot.get.fmversion.disk.info",", ".join(errInfoDiskIDList))

        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
