﻿# -*- coding: UTF-8 -*-
import re
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
            硬盘坏块标记 ； 
            检查步骤：
                步骤1 以admin用户登录设备；
                步骤2 在所有控制器执行如下命令：show disk bad_sector_record查询硬盘坏块标记信息。
    1 当有盘的Bad Sector Count列不为0，那么结果为建议优化;
    2 其它情况结果为检查通过。
    '''
    flag = True
    allCliRet = ""
    errMsg = ""

    try:
        #获取硬盘坏块标记信息
        execRet = checkBadSector(cli, LANG)
        allCliRet += execRet[1]
        errMsg += execRet[2]

        #获取硬盘坏块标记信息失败
        if not execRet[0] :
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)

        idList = execRet[-1]
        if idList:
            flag = cliUtil.RESULT_WARNING
            errMsg += common.getMsg(LANG, "disk.bad.sector.record.suggest")

        return (flag, allCliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))


def checkBadSector(cli, lang):
    """
    @summary: 执行命令show disk bad_sector_record,查询硬盘坏块标记信息。
    @return: 
        isSucc：True/False，方法是否正常结束
        cliRet：CLI回显
        errMsg：方法异常结束时的错误消息
        idList: 存在硬盘坏块的Disk ID列表
    """

    isSucc = True
    cliRet = ""
    errMsg = ""
    notPassedIdList = []

    try:
        cmd = "show disk bad_sector_record"
        execRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRet += execRet[1]

        #命令执行失败或无法查询硬盘坏块信息
        if execRet[0] != True:
            errMsg += common.getMsg(lang, "can.not.get.bad.sector.info")
            return (False, cliRet, errMsg, notPassedIdList)

        if cliUtil.queryResultWithNoRecord(execRet[1]):
            return (True, cliRet, errMsg, notPassedIdList)

        cliRetLinesList = cliUtil.getHorizontalCliRet(execRet[1])

        errorIdList = []
        for line in cliRetLinesList:
            diskID = line.get("Disk ID")
            badSectorNum = line.get("Bad Sector Count")
            if (not badSectorNum) or (not re.match(r'^\d+$', badSectorNum.strip(), re.IGNORECASE)):
                errorIdList.append(diskID)
                continue

            if not badSectorNum.strip() == "0":
                notPassedIdList.append(diskID)


        if errorIdList:
            isSucc = False
            errMsg += common.getMsg(lang, "can.not.get.bad.sector.info", ",".join(errorIdList))

        if notPassedIdList:
            isSucc = True
            errMsg += common.getMsg(lang, "bad.sector.exist.in.disk", ",".join(notPassedIdList))

        return (isSucc, cliRet, errMsg, notPassedIdList)

    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(lang, "query.result.abnormal"), [])
