# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        硬盘健康度检查：
        Health Mark在0-60之间表示异常，其它情况均属于正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show disk health"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet = checkRet[1]
        if checkRet[0] != True: 
            if not cliUtil.hasCliExecPrivilege(cliRet):
                return (cliUtil.RESULT_NOSUPPORT, cliRet, "")  
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.disk.health.info")
            LOGGER.logNoPass("Cannot get information about Disk Health")
            return (False, cliRet, errMsg)
        
        for retDict in cliRetLinesList:
            diskId = retDict.get("Disk ID")
            healthMark = retDict.get("Health Mark")
                
            if healthMark.isdigit():
                healthMarkDigit = int(healthMark)
                if healthMarkDigit >= 0 and healthMarkDigit <= 60:
                    flag = False
                    errMsg += common.getMsg(LANG, "disk.health.mark.abnormal", (diskId, healthMark))
                    LOGGER.logNoPass("The health mark of Disk [%s] is abnormal (Health Mark:%s)" % (diskId, healthMark))
    
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)            
                
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
