# -*- coding: UTF-8 -*-
import cliUtil
import common
import hardware

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        接口卡状态检查: 
        Health Status为Normal且Running Status为Running表示正常。其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show interface_module"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.interface.module.info")
            LOGGER.logNoPass("Cannot get information about interface module")
            return (False, cliRet, errMsg)

        for line in cliRetLinesList:
            Id = line.get("ID")
            healthStatus = line.get("Health Status")
            runningStatus = line.get("Running Status")
            
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "interface.module.health.status.abnormal", (Id, healthStatus))
                LOGGER.logNoPass("The Health Status of interface module [%s] is abnormal (Health Status:%s)" 
                     % (Id, healthStatus))
            
            if runningStatus != common.STATUS_RUNNING:
                flag = False
                errMsg += common.getMsg(LANG, "interface.module.running.status.abnormal", (Id, runningStatus))
                LOGGER.logNoPass("The Running Status of interface module [%s] is abnormal (Running Status:%s)" 
                     % (Id, runningStatus))
            if healthStatus != common.STATUS_NORMAL or runningStatus != common.STATUS_RUNNING:
                eLabel = hardware.getHardwareBomCode("InterfaceModule",cli,Id)[1]
                if len(eLabel) == 0:
                    eLabel = 'Unknown'
                errMsg += common.getMsg(LANG, "hardware.bom.info", (Id, eLabel))
                LOGGER.logNoPass("The Hardware ID [%s] BOMCode:%s" % (Id, eLabel))
                
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))

