# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    PCIe交换机状态检查：
        1 Health Status为Normal且Running Status为Online表示正常；
        2 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show enclosure"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        dataSwitchList = []
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.enclosure.info")
            LOGGER.logNoPass("Cannot get information about enclosure")
            return (False, cliRet, errMsg)
        
        for line in cliRetLinesList:
            logicType = line.get("Logic Type")
            frameId = line.get("ID")
            if not "Data Switch" in logicType:
                continue
            else:
                dataSwitchList.append(frameId)
                
            healthStatus = line.get("Health Status")
            runningStatus = line.get("Running Status")
            
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "dataswitch.health.status.abnormal", (frameId, healthStatus))
                LOGGER.logNoPass("The Health Status of Data Switch [%s] is abnormal (Health Status:%s)" 
                     % (frameId, healthStatus))
            
            if runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "dataswitch.running.status.abnormal", (frameId, runningStatus))
                LOGGER.logNoPass("The Running Status of Data Switch [%s] is abnormal (Running Status:%s)" 
                     % (frameId, runningStatus))
        
        checkRetPCIePortExists = common.checkPCIePortExists(cli, LANG)
        if checkRetPCIePortExists[0] != True:
            errMsg = checkRetPCIePortExists[2]
            LOGGER.logNoPass("Cannot get information about PCIe switch")
            cliRet += checkRetPCIePortExists[1]
            if not checkRetPCIePortExists[0]:
                return cliUtil.RESULT_NOCHECK, cliRet, errMsg  # 修改备注：判断是否需要检查PCIe端口（checkPCIePortExists）执行失败，返回False
            return (checkRetPCIePortExists[0], cliRet, errMsg)
        
        isCheckPCIePortExists = checkRetPCIePortExists[1]
        if isCheckPCIePortExists and len(dataSwitchList) < 2:
            errMsg = common.getMsg(LANG, "pcie.switch.number.not.enough")
            LOGGER.logNoPass("The number of PCIe switch is not enough")
            return (False, cliRet, errMsg)
        
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
