# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    '''
    PCIe端口状态检查：
        1 如果PCIe端口不存在表示正常；
        2 如果Health Status为Normal且不存在DSW交换机表示正常；
        3.如果Health Status为Normal且交换机DSW0和DSW1 Link up的端口数量一致，表示正常；
        4 其它情况均属于不正常状态。
    '''
    cli_ret = ""
    err_msg = ""
    port_name = "PCIe"

    try:
        cmd = "show port general physical_type=PCIE"
        LOGGER.logExecCmd(cmd)
        check_ret = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if not check_ret[0]:
            LOGGER.logSysAbnormal()
            return check_ret

        cli_ret = check_ret[1]
        if cliUtil.queryResultWithNoRecord(cli_ret):
            return (True, cli_ret, err_msg)

        cli_ret_lines_list = cliUtil.getHorizontalCliRet(cli_ret)

        if not cli_ret_lines_list:
            err_msg = common.getMsg(LANG, "cannot.get.port.info", port_name)
            LOGGER.logNoPass("Cannot get information about PCIe port")
            return (cliUtil.RESULT_NOCHECK, cli_ret, err_msg)  # 修改备注：解析回显失败导致列表长度为0

        dsw0_list = list()
        dsw1_list = list()
        for line in cli_ret_lines_list:
            port_id = line.get("ID")
            health_status = line.get("Health Status")
            running_status = line.get("Running Status")
            if health_status != common.STATUS_NORMAL:
                err_msg += common.getMsg(LANG, "port.health.status.abnormal", (port_name, port_id, health_status))
                LOGGER.logNoPass("The Health Status of PCIe port [{}] is abnormal (Health Status:{})"
                                 .format(port_id, health_status))
                continue
            if "DSW" not in port_id or running_status != common.STATUS_LINK_UP:
                continue
            if "DSW0" in port_id:
                dsw0_list.append(port_id)
            else:
                dsw1_list.append(port_id)

        if (dsw0_list and dsw1_list) and (len(dsw0_list) != len(dsw1_list)):
            err_msg += common.getMsg(LANG, "pcie.port.running.status.abnormal")
            LOGGER.logNoPass("The Running Status of PCIe port numbers is abnormal")
        if not err_msg:
            return True, cli_ret, err_msg
        return False, cli_ret, err_msg
    except Exception as exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cli_ret, common.getMsg(LANG, "query.result.abnormal"))