# -*- coding: UTF-8 -*-
"""
@version: Toolkit V200R006C00
@time: 2019/10/08
@file: hardware_root_disk_check.py
@function:
@modify:
"""
import re

from com.huawei.ism.tool.obase.exception import ToolException

import cliUtil
import common
from common_utils import is_support_read_only_user_enter_debug

PY_JAVA_ENV = py_java_env
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
MOUNT = 'mount'
DIRECTORY_CHECK_DICT = {'ls /OSM/coffer_log': '/OSM/coffer_log',
                        'ls /startup_disk/conf/conf_local': '/startup_disk/conf/conf_local',
                        'ls /startup_disk/image/boot': '/startup_disk/image/boot'}
RW_AUTH_DISK_DIR_LIST = ['/OSM/coffer_log', '/startup_disk/conf',
                         '/OSM/coffer_data']

FILE_EXITS = 'Y'
FILE_NOT_FOUNT = 'N'

RW_DIR_NOT_FOUND = '{} not found'
RW_DIR_AUTH_ERROR = '{} auth error'
DIRECTORY_EMPTY_MSG = 'DIRECTORY_EMPTY:{}'
DIRECTORY_EMPTY_KEY = 'DIRECTORY_EMPTY:'

OTHER_NOT_FOUND = 'other directory not found'
OTHER_AUTH_ERROR = 'other directory auth error'

# TV2需要检查的系统型号
tv2_check_system_type = {'S5600T', 'S5800T', 'S6800T'}
mount_disk_check_dict = {'/startup_disk/image': 'N',
                         '/startup_disk/conf': 'N', '/OSM/coffer_log': 'N',
                         '/OSM/coffer_data': 'N'}
mount_disk_v3r2_check_dict = {'/startup_disk/image': 'N',
                              '/startup_disk/conf': 'N',
                              '/OSM/coffer_log': 'N',
                              '/OSM/coffer_data': 'N'}
all_engine_check_ret = ''
all_engine_check_result = []


def execute(cli):
    all_cli_ret = ''
    conn_cli = ''
    try:
        # 获取系统版本
        # show upgrade package
        version_flag, version_cli_ret, error_msg, product_version = \
            common.getProductVersionByUpgradePackage(
                cli, LANG)
        all_cli_ret = common.joinLines(all_cli_ret, version_cli_ret)
        product_model = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
        product_version = str(
            PY_JAVA_ENV.get("devInfo").getProductVersion())
        LOGGER.logInfo("productModel is: %s, productVersion:%s" % (
            product_model, product_version))
        # 版本判断
        if not check_system_type_version(product_model, product_version):
            return cliUtil.RESULT_NOSUPPORT, all_cli_ret, ''
        # 验证权限是否为超级管理员
        user_flag, cli_ret, user_privilege, err_msg = \
            cliUtil.getUserPrivilegeWithCliRet(cli, LANG)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        if not user_flag:
            return cliUtil.RESULT_NOCHECK, all_cli_ret, err_msg
        if user_privilege.lower() != "super_admin" and not \
                is_support_read_only_user_enter_debug(product_version, str(
                    PY_JAVA_ENV.get("devInfo").getHotPatchVersion())):
            return cliUtil.RESULT_NOCHECK, all_cli_ret, common.getMsg(
                LANG,
                "loginUser.name.level.must.be.super.admin")
        # 如果是18000执行debug命令获取阵列链接
        create_ret = common.createDeviceCliContFor18000(cli, PY_JAVA_ENV,
                                                        LOGGER, LANG)
        if create_ret[0] is not True:
            return cliUtil.RESULT_NOCHECK, all_cli_ret, create_ret[2]
        conn_cli = create_ret[1]
        # 所有引擎，所有控制器下系统盘检查
        check_all_engine_root_disk_status(conn_cli, PY_JAVA_ENV, LOGGER,
                                          LANG,
                                          '')
        all_cli_ret = common.joinLines(all_cli_ret, all_engine_check_ret)
        engine_check_flag, all_engine_check_error = \
            analysis_all_engine_result()
        return (
            engine_check_flag, all_cli_ret,
            all_engine_check_error)
    except common.UnCheckException as uncheck:
        LOGGER.logError(
            "Failed to check root disk :%s" % str(uncheck.errorMsg))
        return (
            cliUtil.RESULT_NOCHECK, all_cli_ret,
            uncheck.errorMsg)
    except (ToolException, Exception) as ex:
        LOGGER.logError("Failed to check root disk :%s" % str(ex))
        return (
            cliUtil.RESULT_NOCHECK, all_cli_ret,
            common.getMsg(LANG, "query.result.abnormal"))
    finally:
        # 如果是18000,关闭新链接
        if conn_cli != "":
            if common.is18000(PY_JAVA_ENV, conn_cli) and conn_cli is not cli:
                common.closeConnection(conn_cli, PY_JAVA_ENV, LOGGER)
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))

        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)

    return True, all_cli_ret, ''


def analysis_all_engine_result():
    """
    计算所有引擎结果，输出检查结果和异常提示
    :return:
    """
    # [[flag, engine, controller,mount_check_dict, check_error_type]...]
    global all_engine_check_result
    error = ''
    all_check_flag = True
    # 重新计算所有错误，汇总错误信息
    for each_result in all_engine_check_result:
        flag = each_result[0]
        engine = each_result[1]
        controller = each_result[2]
        mount_check_dict = each_result[3]
        check_error_type = each_result[4]
        if flag is True:
            continue
        if flag == cliUtil.RESULT_NOCHECK:
            all_check_flag = False
            error = common. \
                joinLines(error,
                          get_each_ctrl_check_error(engine, controller,
                                                    check_error_type))
        if flag is False:
            all_check_flag = False
            ctrl_error = ''
            # 添加mount错误
            ctrl_error = common.joinLines(ctrl_error,
                                          build_check_error(
                                              mount_check_dict))
            # 添加DIRECTORY_CHECK_DICT子文件错误
            ctrl_error = analysis_empty_directory_error(ctrl_error, check_error_type)

            error = common. \
                joinLines(error,
                          get_each_ctrl_check_error(engine, controller,
                                                    ctrl_error))

    return all_check_flag, error


def analysis_empty_directory_error(ctrl_error, check_error_type):
    for check_error in check_error_type:
        if DIRECTORY_EMPTY_KEY in check_error:
            empty_file_names = str(check_error).replace(DIRECTORY_EMPTY_KEY, '')
            ctrl_error = common.joinLines(ctrl_error,
                                          common.getMsg(LANG,
                                                        "root.disk.check.mount.directory.empty",
                                                        empty_file_names))

    return ctrl_error


def check_system_type_version(product_model, product_version):
    """
    涉及产品版本及型号判断,
        18000V1系列：V100R001C30及后续版本
        TV2系列：V200R002C00及后续版本,型号S5600T&S5800T&S6800T
        V3系列：V300R001C00及后续版本
        V5系列：V500R007C00-V5R7C50
        DoradoV3系列：V300R001C00及后续版本
    :param product_model: 型号
    :param product_version: 版本
    :return: 是否涉及T,F
    """
    model = product_model.upper()
    version = product_version.upper()
    # 融合存储
    if 'DORADO' not in model:
        # 18xxx V1系列：
        if version.startswith('V100R') and version >= 'V100R001C30':
            if model.startswith('18') or model.startswith('HVS'):
                return True
        # TV2
        if version.startswith('V200R') and version >= 'V200R002C00' \
                and model in tv2_check_system_type:
            return True
        # V3
        if version.startswith('V300R') and version >= 'V300R001C00':
            return True
        # V5
        if version.startswith('V500R') \
                and version >= 'V500R007C00':
            if version < 'V500R007C60':
                return True
    # Dorado V3
    elif 'DORADO' in model and version.startswith('V300R') \
            and version >= 'V300R001C00':
        return True
    else:
        return False
    return False


@common.checkAllEngineInClusterWarp
def check_all_engine_root_disk_status(cli, env, logger, lang,
                                      heart_beat_cli_ret):
    """
    检查所有引擎所有控制器系统盘状态
    :param cli: cli
    :param env: env
    :param logger: logger
    :param lang: lang
    :param heart_beat_cli_ret: 心跳连接
    :return:
    """
    global all_engine_check_ret
    # 获取当前引擎控制器信息
    all_engine_check_ret = common.joinLines(all_engine_check_ret,
                                            heart_beat_cli_ret)
    flag, err_msg, cli_ret, current_ctrl, engine_ctrl_mapping_dict, \
        current_engine, node_num = \
        common.getEngineCtrlNodeInfo(cli, LOGGER, LANG)
    LOGGER.logInfo("current_ctrl id is:%s" % current_ctrl)
    current_ctrl = calc_ctrl_name_from_id(current_engine, current_ctrl,
                                          engine_ctrl_mapping_dict)
    LOGGER.logInfo("current_engine is: %s, current_ctrl:%s, "
                   "engine_ctrl_mapping_dict is:%s" %
                   (current_engine, current_ctrl, engine_ctrl_mapping_dict))
    # 检查单个引擎，得到检查结果
    check_flag, check_cli_ret, mount_check_dict, check_error_type = \
        check_each_engine_root_disk_status(cli)
    all_engine_check_ret = common.joinLines(all_engine_check_ret,
                                            check_cli_ret)
    # 将引擎检查结果装入待分析集合中
    build_engine_ctrl_check_result(check_flag,
                                   current_engine, current_ctrl,
                                   mount_check_dict, check_error_type)
    # 需检查所有引擎下所有控制器系统盘
    return common.CHECK_FLAG_CONTINUE


def build_engine_ctrl_check_result(flag, engine, controller,
                                   mount_check_dict, check_error_type):
    """
    每控检查结果
    :param flag: 检查结果
    :param engine: 当前引擎
    :param controller: 当前控制器
    :param mount_check_dict: mount检查结果
    :param check_error_type:所有检查异常
    :return:
    """
    global all_engine_check_result
    engine_check = [flag, engine, controller,
                    mount_check_dict, check_error_type]
    all_engine_check_result.append(engine_check)


def check_each_engine_root_disk_status(cli):
    """
    检查某控下系统盘是否正常
    :param cli:cli
    :return: flag,cli_ret,error
    """
    all_cli_ret = ''
    check_result = True
    # 进入developer
    flag, cli_ret, err_msg = cliUtil.enterDeveloperMode(cli, LANG)
    if flag is not True:
        return cliUtil.RESULT_NOCHECK, all_cli_ret, '', err_msg
    # 进入minisystem
    flag, cli_ret, err_msg = cliUtil.enterMinisystemModeFromDevelopModel(
        cli, LANG)
    if not flag:
        return cliUtil.RESULT_NOCHECK, all_cli_ret, '', err_msg
    # mount
    mount_flag, mount_cli_ret, mount_error = \
        cliUtil.excuteCmdInMinisystemModel(
            cli, MOUNT, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, mount_cli_ret)
    if mount_flag is not True:
        return cliUtil.RESULT_NOCHECK, mount_cli_ret, '', mount_error
    mount_check_dict = check_root_disk_mount(mount_cli_ret)
    LOGGER.logInfo("mount_check_dict:{}".format(mount_check_dict))
    mount_flag, check_error_type = \
        mount_disk_check_result(mount_check_dict)
    if mount_flag is not True:
        return False, all_cli_ret, mount_check_dict, check_error_type

    # 目录检查
    has_empty_dir, err_msg, dir_cli_ret = check_empty_directory(cli)
    all_cli_ret = common.joinLines(all_cli_ret, dir_cli_ret)
    # 存在空目录则检查不通过
    if has_empty_dir:
        check_error_type.append(err_msg)
        check_result = False
    return check_result, all_cli_ret, mount_check_dict, check_error_type


def check_empty_directory(cli):
    """
    步骤6 执行命令：ls /OSM/coffer_log，ls /startup_disk/conf，ls /startup_disk/image/boot，ls /OSM/coffer_data检查目录信息；
    :param cli: cli
    :return: 是否有空目录, 空目录信息, 查询结果
    """
    LOGGER.logInfo("check_empty_directory start.")
    all_cli_ret = ''
    empty_dirs = []
    for ls_dir_cmd, dir_name in DIRECTORY_CHECK_DICT.items():
        flag, cli_ret = check_if_one_directory_empty(cli, ls_dir_cmd)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        if flag:
            empty_dirs.append(dir_name)
    if empty_dirs:
        return True, DIRECTORY_EMPTY_MSG.format(",".join(empty_dirs)), all_cli_ret
    return False, "", all_cli_ret


def check_if_one_directory_empty(cli, cmd):
    """
    检查步骤6中单个目录是否为空
    :param cli: cli
    :param cmd: ls xxx 命令
    :return: 是否为空，结果信息。
    """
    dir_log_flag, cli_ret, dir_log_error = cliUtil.excuteCmdInMinisystemModel(cli, cmd, LANG)
    if dir_log_flag is not True or check_if_directory_empty(cli_ret, cmd):
        return True, cli_ret
    return False, cli_ret


def get_each_ctrl_check_error(current_engine, current_ctrl, error):
    return common.getMsg(LANG,
                         "root.disk.check.engine.controller.disk.error",
                         (current_engine, current_ctrl, error))


def check_root_disk_mount(mount_cli_ret):
    """
    mount命令检查系统盘目录挂载情况
    :param mount_cli_ret:mount_cli_ret
    :return: flag,cli_ret,error
    """
    res_lines = mount_cli_ret.splitlines()
    check_dict = mount_disk_check_dict.copy()
    check_basic_dict = mount_disk_check_dict.copy()
    for line in res_lines:
        mount_disk_check(check_dict, check_basic_dict, line)
    return check_dict


def mount_disk_check(check_dict, check_basic_dict, line):
    """
    检查每一行是否包含待检测目录，及权限是否正确
    :param check_basic_dict: mount需要检测的文件夹
    :param check_dict:待检测目录
    :param line:mount命令回显行
    :return: no return
    """
    for dir_name in check_basic_dict:
        # 该目录已经判断存在，跳过
        if check_dict[dir_name] == FILE_EXITS:
            continue
        # V3R2C10之前做判断/OSM/coffer_log，/startup_disk/conf权限
        elif target_directory_in_line(line, dir_name):
            if 'rw' in line:
                check_dict[dir_name] = FILE_EXITS
            else:
                LOGGER.logInfo("mount_disk_check: key:{} auth error".format(dir_name))
                check_dict[dir_name] = common.getMsg(
                    LANG, "root.disk.check.mount.coffer.log.auth.error",
                    dir_name)
        else:
            if directory_in_line(dir_name, line):
                check_dict[dir_name] = FILE_EXITS


def target_directory_in_line(line, dir_name):
    """
    做判断/OSM/coffer_log，/startup_disk/conf文件夹是否存在
    :param line: 行
    :return: 结果
    """
    if dir_name in RW_AUTH_DISK_DIR_LIST and directory_in_line(dir_name, line):
        return True
    return False


def directory_in_line(dic_name, line):
    """
    全匹配文件名是否存在
    :param dic_name: 文件名
    :param line: 行
    :return: T F
    """
    result = re.search(r'\s+' + dic_name + r'\s+', line)
    if result is not None:
        return True
    else:
        return False


def mount_disk_check_result(check_dict):
    """
    分析mount命令结果是否有异常，有什么异常
    :param check_dict:待检测目录
    :return:mount检查是否正常
    """
    flag = True
    check_error_type = []
    for key in check_dict:
        if check_dict[key] == FILE_EXITS:
            continue
        if check_dict[key] == FILE_NOT_FOUNT:
            flag = False
            if key in RW_AUTH_DISK_DIR_LIST:
                check_error_type.append(RW_DIR_NOT_FOUND.format(key))
            else:
                if OTHER_NOT_FOUND not in check_error_type:
                    check_error_type.append(OTHER_NOT_FOUND)
        else:
            flag = False
            if key in RW_AUTH_DISK_DIR_LIST:
                check_error_type.append(RW_DIR_AUTH_ERROR.format(key))
            else:
                if OTHER_NOT_FOUND not in check_error_type:
                    check_error_type.append(OTHER_AUTH_ERROR)
    return flag, check_error_type


def build_check_error(check_dict):
    """
    组装某控mount检查错误信息
    :param check_dict: mount 结果
    :return:error
    """
    error = ''
    for key in check_dict:
        if check_dict[key] == FILE_EXITS:
            continue
        if check_dict[key] == FILE_NOT_FOUNT:
            error = common.joinLines(error, common.getMsg(
                LANG, "root.disk.check.mount.error.nodirectory",
                key))
        else:
            error = common.joinLines(error, check_dict[key])
    return error


def calc_ctrl_name_from_id(engine_id, control_id, engine_ctrl_mapping_dict):
    """
    通过引擎，控制器ID计算其控制器名称
    :param engine_ctrl_mapping_dict:引擎管理控制器字典
    :param engine_id:引擎ID
    :param control_id:控制器ID
    :return: 控制器名称
    """
    engine_ctrl_list = []
    if engine_id is not None:
        engine_ctrl_list = sorted(engine_ctrl_mapping_dict[engine_id])
    if not bool(engine_ctrl_list) or control_id not in engine_ctrl_list:
        return ''
    index = engine_ctrl_list.index(control_id)
    return str(engine_id) + str(chr(index + 65))


def check_if_directory_empty(cli_ret, cmd):
    """
    判断ls查询目录回显的子目录是否为空 没有权限默认不为空
    :param cli_ret:ls xxx 回显
    :param cmd:ls xxx命令
    :return: 是否为空
    """
    cli_lines = cli_ret.splitlines()
    for line in cli_lines:
        # 没有权限默认不为空
        if 'permission denied' in line.lower():
            return False
        # 过滤回显命令行和命令行执行异常
        if cmd in line:
            continue
        # 包含结束符，和异常结果关键字，跳过
        if 'minisystem>' in line.lower() or 'no such file or directory' in line.lower():
            continue
        # 正常目录
        if bool(line.strip()):
            return False
    return True
