# -*- coding: UTF-8 -*-
import cliUtil
import common

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)


SYSVERSION_HOTPATCHVERSION_DICT = {
    "V300R002C10SPC100":"V300R002C10SPH108",
    "V300R002C10SPC200":"V300R002C10SPH208",
    "V300R003C00SPC100":"V300R003C00SPH105",
    "V300R003C10SPC100":"V300R003C10SPH112",
    "V300R003C20":"V300R003C20SPH001",
    "V300R003C20SPC200":"V300R003C20SPH203",
    "V300R005C00SPC300":"V300R005C00SPH303",
    "V300R006C00SPC100":"V300R006C00SPH102",
}

def execute(cli):
    '''
    SmartIO卡配置类型检查
    '''
    cliRet = ""
    errMsg = ""
    VERSION_HIGH = "V300R006C10"
    VERSION_LOW = "V300R002C10"
    
    try:
        ret, sysVersionList, hotpatchVersionList = common.parse_upgradePackage(cli, lang)
        cliRet = ret[1]
        if not ret[0]:
            return cliUtil.RESULT_NOCHECK, cliRet, ret[2]

        # 如果系统软件版本大于等于V300R006C10,系统软件版本小于V300R002C10, 则检查结果为不涉及。
        ret, curSysVersion, errInfo = common.getCurrentVersion(sysVersionList,lang)
        logger.logInfo("The current system version:%s" % curSysVersion)
        if not ret:
            errMsg = errInfo
            return cliUtil.RESULT_NOCHECK, cliRet, errMsg
        
        if curSysVersion >= VERSION_HIGH or curSysVersion < VERSION_LOW:
            logger.logInfo("current system version does not involve")
            return cliUtil.RESULT_NOSUPPORT, cliRet, errMsg
        
        if not SYSVERSION_HOTPATCHVERSION_DICT.has_key(curSysVersion):
            logger.logNoPass("The current system [%s] is old" % curSysVersion)
            errMsg = common.getMsg(lang, "check.expand.sysversion.not.pass", ("V300R006C20", curSysVersion))
            return False, cliRet, errMsg
        
        # 获取系统当前的补丁版本
        ret, curHotpatchVersion, errInfo = common.getHotPatchVersion(hotpatchVersionList, lang)
        logger.logInfo("The hotpatch_version:%s" % curHotpatchVersion)
        if not ret:
            errMsg = errInfo
            return cliUtil.RESULT_NOCHECK, cliRet, errMsg
        
        if curHotpatchVersion != "--" and curHotpatchVersion >= SYSVERSION_HOTPATCHVERSION_DICT.get(curSysVersion):
            return True, cliRet, errMsg
        
        logger.logNoPass("The current hotpath version [%s] is old" % curHotpatchVersion)
        errMsg = common.getMsg(lang, "check.expand.hot.patch.not.pass", (SYSVERSION_HOTPATCHVERSION_DICT.get(curSysVersion), curHotpatchVersion))
        return False, cliRet, errMsg
    
    except Exception, exception:
        logger.logException(exception)
        return cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang,"query.result.abnormal")

