# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    SAN双活空间预留检查 ； 
            检查步骤：
                 步骤1 以admin用户登录设备；
                步骤2 执行命令show hyper_metro_pair general，查询双活特性；
                步骤3 执行命令show storage_pool general，记录所有Pool的总容量（Total Capacity字段值）和空闲容量（Free Capacity字段的值）；
            检查标准：
               注：若存在双活配置，则远端阵列需要检查该检查项，请添加远端阵列到工具并选择该检查项进行检查。
        1. 若不存在双活配置则检查通过，否则继续步骤3；
        2. 如果所有Pool均满足：空闲容量（Free Capacity字段的值）大于Pool的总容量（Total Capacity字段值）的1%，则检查通过，否则不通过；
    '''
    
    flag = True
    allCliRet = ""
    errMsg = ""
    standard = "0.01"
    
    try:
        
        #查询是否存在双活配置
        flag, cliRet, errMsg, featureExist = isFeatureExist(cli, LANG)
        allCliRet += cliRet
        
        #查询是否存在双活配置失败（下发命令失败或发生异常）
        
        if not flag:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        if flag != True:
            return (flag, allCliRet, errMsg)

        if not featureExist:
            return (True, allCliRet, errMsg)
        
        #检查存储池空闲容量
        flag, cliRet, errMsg, freeCapDict = common.checkPoolFreeCapacity(cli, LANG, standard, LOGGER)
        allCliRet += cliRet
        
        #查询存储池详情失败
        if not flag:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        if flag != True:
            return (flag, allCliRet, errMsg)
        
        if not freeCapDict:
            return (True, allCliRet, '')

        #检查增值LUN的总容量是否达标
        flag, cliRet, reachStandrd, errMsg = common.compareFreeCapacity(cli, freeCapDict, 'HyperMetro ID(s)', LANG, py_java_env, LOGGER)        
        allCliRet += cliRet
        #查询LUN信息失败
        if not flag:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        if flag != True:
            return (flag, allCliRet, errMsg)
        
        if reachStandrd == False:
            return (False, allCliRet, errMsg)
                       
        return (True, allCliRet, '')
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

    
def isFeatureExist(cli, lang):
    """
    @summary: 执行命令show hyper_metro_pair general，
                                    检查是否存在双活配置；
    @return: 
        isSucc：True/False，方法是否正常结束
        cliRet：CLI回显
        errMsg：方法异常结束时的错误消息
        featureExist: True(存在双活配置)
                      False(不存在双活配置)
    """
    
    isSucc = True
    cliRet = ""
    errMsg = ""
    featureExist = False
    
    try:
        cmd = "show hyper_metro_pair general"
        execRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRet = execRet[1]
        
        if not cliUtil.hasCliExecPrivilege(cliRet):
            return (cliUtil.RESULT_NOSUPPORT, cliRet, errMsg, featureExist)
        
        #命令执行失败
        if execRet[0] == False:
            errMsg = common.getMsg(lang, "can.not.get.hyper.metro.pair.info")            
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg, featureExist)

        if execRet[0] != True:
            return (execRet[0], cliRet, execRet[2], featureExist)
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg, featureExist)
        
        #走到这里说明命令成功执行且回显正常，回显正常即说明有对应特性
        featureExist = True
                
        return (isSucc, cliRet, errMsg, featureExist)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(lang, "query.result.abnormal"), featureExist)
    
