# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        ACC卡检查: 
            若Compression Enabled值存在“Yes“且Model值存在“Smart ACC Module“满足如下两个条件任意一个则检查不通过，否则检查通过。
    1、 若Product Model为18500 V3/18800 V3其中之一，并且Current Version为V300R003C00、V300R003C00SPC100或V300R003C10。
    2、Product Model为5300 V3/5500 V3/5600 V3/5800 V3/6800 V3其中之一，并且Current Version为V300R002C10、V300R003C00、 V300R003C00SPC100或V300R003C10。 
    '''
    flag = True
    cliRet = ""
    allcliRet = ""
    errMsg = ""
    allerrMsg = ""

    try:
        #1查询设备型号和产品版本是否为问题版本
        flag, cliRet, currentVersion, errMsg = checkModelAndVersion(cli)
        allcliRet += cliRet
        allerrMsg += errMsg
        if flag:
            return (flag, allcliRet, allerrMsg)
        
        #2判断是否开启文件系统压缩功能或LUN压缩功能
        flag, cliRet, errMsg = checkSystemAndLunCompression(cli)
        allcliRet += cliRet
        allerrMsg += errMsg
        if flag:
            return (flag, allcliRet, allerrMsg)
        
        #3判断存储设备配置是否有ACC卡 
        flag, cliRet, errMsg = checkingACCModules(cli,currentVersion)
        allcliRet += cliRet
        allerrMsg += errMsg
        if flag != True:
            errinfo = common.getMsg(LANG, "check.acc.error")
            errinfo += allerrMsg
            return (flag, allcliRet, errinfo)
        else:
            allerrMsg = ''
              
        return (flag, allcliRet, allerrMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allcliRet, common.getMsg(LANG, "query.result.abnormal"))

def checkModelAndVersion(cli):
    '''
    @summary: 查询设备型号和产品版本是否为问题版本
    @param cli: cli对象
    @return: 
        True: 不是问题版本
        False: 是问题版本
        cliRet：cli命令回显
        errMsg：错误消息
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    currentVersion = ""
    HighProductModelList = ["18500 V3","18800 V3"]
    HighCurrentVersionList = ["V300R003C00","V300R003C00SPC100","V300R003C10"]
    LowProductModelList = ["5300 V3","5500 V3","5600 V3","5800 V3","6800 V3"]
    LowCurrentVersionList = ["V300R002C10","V300R003C00","V300R003C00SPC100","V300R003C10"]
    SolveVersionDict = {"V300R002":"V300R002C10SPC200","V300R003":"V300R003C10SPC100"}
    NOSUPPORT_VERSION = "V300R003C20"
    #获取产品型号
    checkRet = cliUtil.getProductModelWithCliRet(cli, LANG)
    cliRet += checkRet[2]
    if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            # 修改备注：若getProductModelWithCliRet返回False是因为命令执行失败
            if not checkRet[0]:
                return cliUtil.RESULT_NOCHECK, checkRet[2], currentVersion, checkRet[3]
            return (checkRet[0], checkRet[2],currentVersion ,checkRet[3])
    product_model = checkRet[1]
    
    #获取产品版本    
    checkRet, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
    cliRet += checkRet[1]
    if checkRet[0] != True:
        LOGGER.logSysAbnormal()
        return (cliUtil.RESULT_NOCHECK, cliRet , currentVersion ,checkRet[2])
    result, currentVersion, errMsg = common.getCurrentVersion(currentVersionDictList, LANG)
    if not result:
        return (cliUtil.RESULT_NOCHECK, cliRet, currentVersion ,errMsg)  # 修改备注：getCurrentVersion返回False应该是未检查
    
    #V300R003C20版本不涉及该检查项
    if NOSUPPORT_VERSION in currentVersion:
        return (cliUtil.RESULT_NOSUPPORT, cliRet,currentVersion , errMsg)
    if (product_model in HighProductModelList and currentVersion in HighCurrentVersionList) or \
    (product_model in LowProductModelList and currentVersion in LowCurrentVersionList):
        flag = False
        #获取已经解决版本
        SolveVersion = ""
        for ver in SolveVersionDict.keys():
            if ver in currentVersion:
                SolveVersion = SolveVersionDict[ver]
        errMsg += common.getMsg(LANG, "model.version.exist.data.compression.errors", (product_model, currentVersion,SolveVersion))
    
    return (flag, cliRet,currentVersion, errMsg)
def checkSystemAndLunCompression(cli):
    '''
    @summary:判断是否开启文件系统压缩功能或LUN压缩功能
    @param cli: cli对象
    @return: 
        True: 压缩功能关闭
        False: 压缩功能开启
        cliRet：cli命令回显
        errMsg：错误消息
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    filesysluncomprecmdList = ["show file_system general |filterColumn include columnList=ID,Name,Compression\sEnabled",
                            "show lun dedup_compress |filterColumn include columnList=ID,Name,Compression\sEnabled"]
    for cmd in filesysluncomprecmdList:
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet += checkRet[1]
        if cliUtil.queryResultWithNoRecord(checkRet[1]):
            continue
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.compression.enabled.info")
            LOGGER.logNoPass("Cannot get information about Compression Enabled")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0
        
        compressionenabled = ""
        for line in cliRetLinesList:
            Id = line.get("ID")
            compressionenabled = line.get("Compression Enabled")
            if compressionenabled.upper() == "YES":
                flag = False
                if cmd == filesysluncomprecmdList[0]:
                    errMsg += common.getMsg(LANG, "file.system.compression.yes", (Id))
                else:
                    errMsg += common.getMsg(LANG, "lun.compression.yes", (Id))
    
    return (flag, cliRet, errMsg)
                
def checkingACCModules(cli,currentVersion):
    '''
    @summary: 判断存储设备配置是否有ACC卡和ACC卡的压缩功能
    @param cli: cli对象
    @return: 
        True: 没有配置ACC卡或者压缩功能关闭
        False: 配置了ACC卡或者压缩功能开启
        cliRet：cli命令回显
        errMsg：错误消息
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    acccard = "Smart ACC Module"
    cmd = "show interface_module"
    LOGGER.logExecCmd(cmd)
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if checkRet[0] != True: 
        LOGGER.logSysAbnormal()
        return checkRet
    
    cliRet = checkRet[1]
    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, cliRet, errMsg)
    
    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    if len(cliRetLinesList) == 0:
        errMsg = common.getMsg(LANG, "cannot.get.acc.module.info")
        LOGGER.logNoPass("Cannot get information about acc module")
        return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0
   
    for line in cliRetLinesList:
        Id = line.get("ID")
        Module = line.get("Model")
        if Module.upper() == acccard.upper():
            #V3R2版本和V300R003C00 TR5版本判断ACC卡是否下电
            if "V300R002" in currentVersion or currentVersion == "V300R003C00":
                cmd = "show interface_module interface_module_id=%s" %Id
                LOGGER.logExecCmd(cmd)
                checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
                if checkRet[0] != True: 
                    LOGGER.logSysAbnormal()
                    return checkRet
                
                cliRet += checkRet[1]
                cliRetLinesList = cliUtil.getVerticalCliRet(checkRet[1])
                if len(cliRetLinesList) == 0:
                    errMsg = common.getMsg(LANG, "cannot.get.acc.module.status.info")
                    LOGGER.logNoPass("Cannot get information about acc module status")
                    return (False, cliRet, errMsg)
                
                accstatus = "Powered Off"
                for line in cliRetLinesList:
                    accRunningStatus = line.get("Running Status")
                    if accRunningStatus.upper() != accstatus.upper():
                        flag = False
                        errMsg += common.getMsg(LANG, "interface.module.is.smart.acc.module.status", (Id,accRunningStatus))
            
            else:
                #V3R3版本判断ACC卡压缩功能是否关闭
                cmd = "show ddp accelerate_card"
                LOGGER.logExecCmd(cmd)
                checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
                if checkRet[0] != True: 
                    LOGGER.logSysAbnormal()
                    return checkRet
                cliRet += checkRet[1]
                
                cliRetLinesList = cliUtil.getVerticalCliRet(checkRet[1])
                if len(cliRetLinesList) == 0:
                    errMsg = common.getMsg(LANG, "cannot.get.compression.enabled.info")
                    LOGGER.logNoPass("Cannot get information about Diacrisis")
                    return (False, cliRet, errMsg)
                accSwitch = "Off"
                for line in cliRetLinesList:
                    accSwitchStatus = line.get("Diacrisis")
                    if accSwitchStatus.upper() != accSwitch.upper():
                        flag = False
                        errMsg += common.getMsg(LANG, "interface.module.smart.acc.module.abnormal", (accSwitchStatus))
                return (flag, cliRet, errMsg)
            
    return (flag, cliRet, errMsg)
