# -*- coding: UTF-8 -*-
import cliUtil
import common
import common_cache
import cliUtil as cliUtils
import cli_util_cache as cache_util
from cbb.frame.context import sqlite_context
from cbb.frame.cli import cliUtil as cbb_cliUtil
from com.huawei.ism.tool.obase.exception import ToolException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
# 大规格超时时间设置
REP_TIME_OUT_BATCH_CLI = 5 * 60
CHECK_LUN_MAP = {
    "RM": {
        "cli": "show remote_replication general |filterColumn include columnList=Primary\sLUN\sCapacity,Local\sLUN\sID",
        "id": "Local LUN ID"},
    "HM": {
        "cli": "show hyper_metro_pair general |filterColumn include columnList=Local\sID,Size,Type",
        "id": "Local ID"}
}
CHECK_LUN_SIZE_SYSTEM_VERSION = {
    "6.0.0": "",
    "6.0.1": "",
    "6.1.0": "",
    "6.1.2": "6.1.2.SPH22",
    "6.1.3": "6.1.3.SPH10",
}
REMOTE_REPLICATION_INFO_FROM_CONFIG = "remote replication info from config {}"
ALL_CLI_RET = ""
isVersion613 = False


def execute(cli):
    """
        LUN 8K对齐检查：
        1 获取远程复制和双活pair；
        2 读取配置文件LUN信息；
        3 计算是否未8K对齐。
    """
    cli_ret = ""
    global ALL_CLI_RET
    global isVersion613
    isVersion613 = False
    err_lun_ids = []
    tmp_msg = common.getMsg(LANG, "check.pass")
    try:
        # 1、校验当前补丁版本是否需要检查
        LOGGER.logInfo("8K check begin.")
        flag, p_version, p_patch, cli_ret = cbb_cliUtil.get_system_version_with_ret(cli, LANG)
        if not is_lun_check_version_and_patch(p_version, p_patch):
            return True, cli_ret, tmp_msg
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
        # 2、获取远程复制和双活pair 使用的LunId
        LOGGER.logInfo("8K check query pair begin.")
        flag, hm_lun_ids, err_msg = query_need_check_lun_ids("HM", cli)
        if flag is not True:
            LOGGER.logError(err_msg)
            return flag, ALL_CLI_RET, err_msg
        flag, rm_lun_ids, err_msg = query_need_check_lun_ids("RM", cli)
        if flag is not True:
            LOGGER.logError(err_msg)
            return flag, ALL_CLI_RET, err_msg
        rep_lun_ids = rm_lun_ids + hm_lun_ids

        if len(rep_lun_ids) == 0:
            LOGGER.logInfo("Cannot get remote or hyper metro pair")
            return True, ALL_CLI_RET, tmp_msg
        LOGGER.logInfo("8K check query pair end. pairNum:{0}".format(len(rep_lun_ids)))
        # 3、获取真实Lun信息，sector容量
        sn = common.get_sn_from_env(PY_JAVA_ENV)
        obj_py = PY_JAVA_ENV.get("objectForPy")
        lun_info = cache_util.get_lun_info_from_config(obj_py, LOGGER, sn)
        if not lun_info:
            LOGGER.logInfo("Cannot get lun info! repPairNum:{0}, {1}".format(len(rep_lun_ids), lun_info))
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal")
        LOGGER.logInfo("repPairNum:{0}, allLunNum:{1}, first: {2}".format(len(rep_lun_ids), len(lun_info), lun_info[0]))
        # 4、校验容量是否8K对齐
        err_lun_ids = find_not_alig_lun(rep_lun_ids, lun_info, err_lun_ids)
        if len(err_lun_ids) != 0:
            tmp_msg = common.getMsg(LANG, "check.rep.lun.8k.alignment", (','.join(err_lun_ids)))
            LOGGER.logInfo(tmp_msg)
            return False, ALL_CLI_RET, tmp_msg
        LOGGER.logInfo("8K check end, success.")
        return True, ALL_CLI_RET, tmp_msg

    except (ToolException, Exception) as exception:
        LOGGER.logInfo("8K check fail, exception.")
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET,
                common.getMsg(LANG, "query.result.abnormal"))
    finally:
        # 退出到cli模式
        ret = cliUtils.enterCliModeFromSomeModel(cli, LANG)
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)
        common.finishProcess(PY_JAVA_ENV)


def find_not_alig_lun(rep_lun_ids, lun_info, err_lun_ids):
    for lun in lun_info:
        if int(lun.get("ID")) not in rep_lun_ids:
            continue
        if int(lun.get("Capacity(Sectors)")) % 16 != 0:
            err_lun_ids.append(lun.get("ID"))
    return err_lun_ids


def is_lun_check_version_and_patch(software_version, hot_patch_version):
    global isVersion613
    if software_version not in CHECK_LUN_SIZE_SYSTEM_VERSION.keys():
        return False
    isVersion613 = software_version == "6.1.3"
    if not hot_patch_version:
        return True
    patch_num = get_patch_num(hot_patch_version)
    if not patch_num:
        return True
    repair_patch = CHECK_LUN_SIZE_SYSTEM_VERSION.get(software_version)
    if not repair_patch:
        return True
    repair_patch_num = get_patch_num(repair_patch)
    if patch_num >= repair_patch_num:
        return False
    return True


def get_patch_num(patch_version):
    """
    获取补丁版本的数字
    :return:
    """
    patch = re.search(r"SPH(\d+)", patch_version)
    if not patch:
        return 0
    return int(patch.group(1))


def query_need_check_lun_ids(map_index, cli):
    lun_ids = []
    global ALL_CLI_RET
    flag, cli_ret, err_msg = cliUtil.excuteCmdTimeOutInCliMode(cli, CHECK_LUN_MAP.get(map_index).get("cli"), True, LANG,
                                                               REP_TIME_OUT_BATCH_CLI)
    if flag is not True:
        if map_index == "RM" and "TOOLKIT_SEND_CMD_TIME_OUT" in cli_ret:
            LOGGER.logError("8K check query pair RM timeout")
            flag, lun_ids, cli_ret = query_rm_lun_ids_from_config(cli, cli_ret)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
        return flag, lun_ids, err_msg
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return True, lun_ids, err_msg
    cli_ret_lines_list = cliUtil.getHorizontalCliRet(cli_ret)
    if len(cli_ret_lines_list) == 0:
        return True, lun_ids, err_msg
    for info in cli_ret_lines_list:
        if map_index == "HM" and info.get("Type") != "LUN":
            continue
        lun_ids.append(int(info.get(CHECK_LUN_MAP.get(map_index).get("id"))))
    return True, lun_ids, err_msg


def query_rm_lun_ids_from_config(cli, cli_ret):
    sn = common.get_sn_from_env(PY_JAVA_ENV)
    object_for_py = PY_JAVA_ENV.get("objectForPy")
    global isVersion613
    LOGGER.logInfo("8K check query pair from config begin. isVersion613:{0}".format(isVersion613))
    lun_ids = []
    flag = True
    tmp_dict = object_for_py.get(common_cache.REMOTE_REPLICATION_INFO_FROM_CONFIG.format(sn))
    if not tmp_dict:
        # 内存中没有时重新获取一遍
        dev_info = PY_JAVA_ENV.get("devInfo")
        p_version = str(dev_info.getProductVersion())
        sqlite_conn = sqlite_context.get_sqlite_conn_from_context(object_for_py, sn, LOGGER)
        flag = common_cache.ana_running_data(cli, sn, p_version, LANG, sqlite_conn, LOGGER, object_for_py)
        if not flag:
            LOGGER.logInfo("Cannot get rm from config!")
            return flag, lun_ids, cli_ret
        tmp_dict = object_for_py.get(common_cache.REMOTE_REPLICATION_INFO_FROM_CONFIG.format(sn))
        if not tmp_dict:
            LOGGER.logInfo("Cannot get rm from object_for_py!")
            return False, lun_ids, cli_ret
    pair_info = tmp_dict.get("remote_replication_info", [])
    LOGGER.logInfo("8K check query pair from config {0}.".format(len(pair_info)))
    cli_ret = "show remote_replication general |filterColumn include columnList=Primary\sLUN\sCapacity,Local\sLUN\sID" \
              "\nLocal LUN ID   Primary Resource Capacity\n------------   -------------------------"
    for pair in pair_info:
        if pair == {} or pair.get("dsType") == "FS" or pair.get("dsType") is None:
            continue
        temp_capacity = "--"
        if isVersion613 and pair.get("Primary Resource Capacity") is not None:
            temp_capacity = "0x{0}KB".format(pair.get("Primary Resource Capacity"))
        if pair.get("Role") == "Slave":
            lun_ids.append(int(pair.get("Slave Lun ID")))
            cli_ret = common.joinLines(cli_ret, "{0:<15}{1}".format(pair.get("Slave Lun ID"), temp_capacity))
        else:
            lun_ids.append(int(pair.get("Master Lun ID")))
            cli_ret = common.joinLines(cli_ret, "{0:<15}{1}".format(pair.get("Master Lun ID"), temp_capacity))
    LOGGER.logInfo("8K check query pair from config end.")
    return flag, lun_ids, cli_ret
