# -*- coding: UTF-8 -*-
import common
from cbb.frame.cli import cliUtil
from cbb.frame.base import baseUtil


LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

RISK_VERSION = {'V300R003C10SPC100': 'V300R003C10SPH118',
                'V300R003C20': '',
                'V300R003C20SPC100': '',
                'V300R003C20SPC200': '',
                'V300R006C00': '',
                'V300R006C00SPC100': 'V300R006C00SPH111',
                'V300R006C10': '',
                'V300R006C10SPC100': 'V300R006C10SPH105',
                'V300R006C20': 'V300R006C20SPH006',
                'V500R007C00': '',
                'V500R007C00SPC100': 'V500R007C00SPH105',
                'V500R007C10': 'V500R007C10SPH006'
                }

DORADO_RISK_VERSION = {'V300R001C10SPC100': '',
                       'V300R001C00SPC100': '',
                       'V300R001C01': '',
                       'V300R001C01SPC100': 'V300R001C01SPH105',
                       'V300R001C20': '',
                       'V300R001C21': '',
                       'V300R001C21SPC100': 'V300R001C21SPH109'}


def execute(cli):
    """ IB链路检查
     omrp地址：http://omrpDomain/omrp/jsp/pages/om/om_detail.jsp?
     versionId=395&versionName=V3-V300R003C10-C20&omType=CheckItem&templateId
     =24&omName=software_controller_side_IB_link_risk_check&omId=2405&edit=
     false
    2020/02/28 新增
    :param cli:
    :return:
    """

    cliRet = ""
    err_msg = ""

    try:
        cmd = "show ib_port general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] is not True:
            LOGGER.logSysAbnormal()
            return cliUtil.RESULT_NOCHECK, checkRet[1], checkRet[2]

        cliRet = checkRet[1]
        # 如果Command executed successfully 直接报通过
        if cliUtil.queryResultWithNoRecord(cliRet):
            return True, cliRet, err_msg
        pdt_model = str(py_java_env.get("devInfo").getDeviceType())
        risk_version_map = DORADO_RISK_VERSION if baseUtil.isDoradoDev(
            pdt_model) else RISK_VERSION

        flag, soft_version, patch_version, cli_ret_version, err_msg = \
            get_soft_and_patch_version(cli)
        cliRet += cli_ret_version
        if flag is not True:
            return flag, cliRet, err_msg

        # 如果型号或版本不存在风险
        if soft_version not in risk_version_map:
            return flag, cliRet, err_msg

        least_patch_ver = risk_version_map.get(soft_version)
        # 风险版本已安装对应版本热补丁, 则检查通过
        if patch_version and least_patch_ver and \
                patch_version >= least_patch_ver:
            return flag, cliRet, err_msg

        # 构造错误信息
        err_msg += common.getMsg(LANG, "ib.not.check.meg", (
            soft_version, patch_version if patch_version else "--"))

        return cliUtil.RESULT_WARNING, cliRet, err_msg

    except Exception as exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(
            LANG, "query.result.abnormal")


def get_soft_and_patch_version(cli):
    """
    获取阵列版本和热补丁版本
    :return: flag 阵列版本，热补丁版本，回显，错误提示
    """
    (ver_flag, cliRet, err_msg), software_version_list, \
        hot_patch_version_list = common.parse_upgradePackage(cli, LANG)

    if ver_flag is not True:
        LOGGER.logSysAbnormal()
        LOGGER.logInfo(
            "get package info fail! software_version_list:%s,"
            " hot_patch_version_list%s" %
            (software_version_list, hot_patch_version_list))
        return cliUtil.RESULT_NOCHECK, '', '', cliRet, err_msg

    flag, soft_version, err_msg = common.getCurrentVersion(
        software_version_list,
        LANG)
    if flag is not True:
        LOGGER.logInfo(
            "get current product version error. "
            "err_msg: %s" % err_msg)
        return cliUtil.RESULT_NOCHECK, '', '', cliRet, err_msg

    flag, patch_version, err_msg = common.getHotPatchVersion(
        hot_patch_version_list,
        LANG)
    if flag is not True:
        LOGGER.logInfo("get hotPatchVersion error. "
                       "err_msg: %s" % err_msg)
        return cliUtil.RESULT_NOCHECK, '', '', cliRet, err_msg

    return True, soft_version, patch_version, cliRet, err_msg
