# -*- coding: UTF-8 -*-

import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
            硬盘域规划； 
            步骤1 以admin用户登录设备；
            步骤2 执行如下命令：show storage_pool general 查询所有存储池的信息。
    1 当存储池不存在，则检查通过；
    2 当有多个存储池同属于一个硬盘域，且Usage Type不相等，则检查结果为建议优化；否则检查结果为通过；
    3 其他情况检查不通过。
    '''
    
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show storage_pool general"
        execRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet = execRet[1]
        
        #命令执行失败
        if execRet[0] != True:
            errMsg = execRet[2]
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
         
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        #解析回显为字典列表
        linesList = cliUtil.getHorizontalCliRet(cliRet)
        #存储池不存在，则检查通过
        if len(linesList)==0:
            return (True, cliRet, errMsg)
        
        # 获取硬盘域的存储池业务。
        domainUsagesDict = getUsage(linesList)
        
        # 检查硬盘域存储业务配置。
        err_msg = checkUsage(domainUsagesDict)
        if err_msg:
            flag = cliUtil.RESULT_WARNING
            err_msg = common.getMsg(LANG, "domain.recommended.configuration.titile") + errMsg
            err_msg += common.getMsg(LANG, "disk.domain.usage.warning.sugg")
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))


def getUsage(linesList):
    """
    @summary: 获取硬盘域的存储池业务。
    """
    domainUsagesDict = {}

    for line in linesList:
        domainId = line.get("Disk Domain ID", "").strip()
        usageType = line.get("Usage Type", "").strip()
        poolId = line.get("ID", "").strip()
        if not (domainId and usageType and poolId):
            continue
        domainUsags = domainUsagesDict.get(domainId, {})
        poolIdList = domainUsags.get(usageType, [])
        poolIdList.append(poolId)
        domainUsags[usageType] = poolIdList
        domainUsagesDict[domainId] = domainUsags
        
    return domainUsagesDict
 
    
def checkUsage(domainUsagesDict):
    """
    @summary: 检查同一硬盘域下的规划的存储池是否是同一业务。
    """
    errMsg = ""
    
    for domainId in domainUsagesDict:
        domainUsags = domainUsagesDict.get(domainId)
        if len(domainUsags.keys()) <= 1:
            continue
        poolErrMsgs = []
        for usag in domainUsags:
            poolIdList = domainUsags.get(usag)
            poolErrMsg = common.getMsg(LANG, "pool.usage.type", (",".join(poolIdList), usag))
            poolErrMsgs.append(poolErrMsg)
        errMsg += common.getMsg(LANG, "domain.usage.type.inconsistent", domainId) + "".join(poolErrMsgs) + "\n"
        
    return errMsg
