# -*- coding:utf-8 -*-
import cliUtil
import common
import traceback
from common import UnCheckException
from config import edev_lun_model
from cbb.frame.cli import cli_with_cache

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ''
ALL_ERR_MSG_NO_CHECK = ''
ALL_ERR_MSG_WARNING = ''
EMPTY_CHAR = '--'
Write_Through = 'Write Through'
Write_Back = 'Write Back'
Lowest_Version_For_V3 = 'V300R003C20SPC200'
PY_JAVA_ENV = py_java_env


def execute(cli):
    """
    步骤1 以admin用户登录设备。
    步骤2 执行命令：show lun general usage_type=External，获取所有异构lun的id。
    步骤3 获取步骤2的id信息，执行命令：show lun general lun_id=%s。
    检查标准：
    1.步骤2中如果存在id，则记录后执行步骤3，不存在，返回通过。
    2.步骤3中判断 "HyperMetro ID(s)", "Remote Replication ID(s)", "Snapshot ID(s)" 是否存在不为空的值。
    如果存在任何值不为空则判断 Write Policy 值是否为Write Back，如果不为Write Back则建议优化，否则通过。
    3.步骤3中判断 "HyperMetro ID(s)", "Remote Replication ID(s)", "Snapshot ID(s)" 是否存在不为空的值。
    如果都为空值则需判断Write Policy是否为Write Through，如果不为Write Through则建议优化，否则通过。
    :param cli:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK, ALL_ERR_MSG_WARNING
    try:
        if not check_product_info(cli):
            return cliUtil.RESULT_NOSUPPORT, ALL_CLI_RET, ''
        flag, err_msg, external_lun_id_list = get_external_lun_id(cli)
        if not external_lun_id_list:
            if flag != True:
                if flag == cliUtil.RESULT_NOSUPPORT:
                    return cliUtil.RESULT_NOSUPPORT, ALL_CLI_RET, ''
                ALL_ERR_MSG_NO_CHECK = common.joinLines(ALL_ERR_MSG_NO_CHECK, err_msg)
                return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
            return True, ALL_CLI_RET, ''
        check_lun_info(cli, external_lun_id_list)
        if ALL_ERR_MSG_WARNING:
            return cliUtil.RESULT_WARNING, ALL_CLI_RET, common.joinLines(ALL_ERR_MSG_WARNING, ALL_ERR_MSG_NO_CHECK)
        if ALL_ERR_MSG_NO_CHECK:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
        return True, ALL_CLI_RET, ''
    except UnCheckException, un_check_exception:
        LOGGER.logInfo(u'UnCheckException, err_msg: %s' % un_check_exception.errorMsg)
        return un_check_exception.flag, un_check_exception.cliRet, un_check_exception.errorMsg
    except:
        LOGGER.logError(traceback.format_exc())
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, 'query.result.abnormal')


def check_lun_info(cli, lun_id_list):
    """
    获取步骤2的id信息，执行命令：show lun general lun_id=%s
    :param cli:
    :param lun_id_list:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
    for lun_id in lun_id_list:
        cmd = "show lun general lun_id=%s" % lun_id
        flag, cli_ret, err_msg = cli_with_cache. \
            execute_cmd_in_cli_mode_with_cache(PY_JAVA_ENV, cli, cmd,
                                               LOGGER)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
        if flag != True:
            ALL_ERR_MSG_NO_CHECK = common.joinLines(ALL_ERR_MSG_NO_CHECK,
                                                    common.getMsg(LANG, 'get.external.lun.info.failed',
                                                                  (lun_id, err_msg)))
            continue
        cli_ret_list = cliUtil.getVerticalCliRet(cli_ret)
        for cli_ret_dict in cli_ret_list:
            hyper_metro_id = cli_ret_dict.get('HyperMetro ID(s)', '')
            remote_replication_id = cli_ret_dict.get('Remote Replication ID(s)', '')
            snapshot_id = cli_ret_dict.get('Snapshot ID(s)', '')
            write_policy = cli_ret_dict.get('Write Policy', '')
            check_result(lun_id, hyper_metro_id, remote_replication_id, snapshot_id, write_policy)


def check_result(lun_id, hyper_metro_id, remote_replication_id, snapshot_id, write_policy):
    """
    如果存在任何值不为空则判断 Write Policy 值是否为Write Back，如果不为Write Back则建议优化，否则通过
    如果都为空值则需判断Write Policy是否为Write Through，如果不为Write Through则建议优化，否则通过
    :param lun_id:
    :param hyper_metro_id:
    :param remote_replication_id:
    :param snapshot_id:
    :param write_policy:
    :return:
    """
    global ALL_ERR_MSG_WARNING
    write_back_list = []
    write_through_list = []
    if (not hyper_metro_id or hyper_metro_id == EMPTY_CHAR) and (
                not remote_replication_id or remote_replication_id == EMPTY_CHAR) and (
                not snapshot_id or snapshot_id == EMPTY_CHAR):
        if write_policy != Write_Through:
            write_through_list.append(lun_id)
    elif (hyper_metro_id and hyper_metro_id != EMPTY_CHAR) or (
                remote_replication_id and remote_replication_id != EMPTY_CHAR) or (
                snapshot_id and snapshot_id != EMPTY_CHAR):
        if write_policy != Write_Back:
            write_back_list.append(lun_id)
    if write_back_list:
        ALL_ERR_MSG_WARNING = common.getMsg(
            LANG, 'write.policy.suggestion',
            (write_policy, Write_Back,
             ", ".join(write_back_list))) + common.getMsg(
            LANG, "write.policy.suggestion.write.back", ", ".join(write_back_list))
    if write_through_list:
        ALL_ERR_MSG_WARNING += common.getMsg(
            LANG, 'write.policy.suggestion',
            (lun_id, write_policy, Write_Through,
             ", ".join(write_through_list))) + common.getMsg(
            LANG, "write.policy.suggestion.write.through", ", ".join(write_through_list))


def get_external_lun_id(cli):
    """
    执行命令：show lun general usage_type=External，获取所有异构lun的id
    :param cli:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
    cmd = 'show lun general usage_type=External'
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    external_lun_id_list = []
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return True, err_msg, external_lun_id_list
    if flag != True:
        return flag, err_msg, external_lun_id_list
    cli_ret_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
    for index, cli_ret_dict in enumerate(cli_ret_list):
        external_lun_id = cli_ret_dict.get('ID', '')
        if not external_lun_id:
            continue
        external_lun_id_list.append(external_lun_id)
    if external_lun_id_list:
        if len(external_lun_id_list) != len(cli_ret_list):
            ALL_ERR_MSG_NO_CHECK = common.joinLines(ALL_ERR_MSG_NO_CHECK,
                                                    common.getMsg(LANG, 'failed.get.external.lun.id'))
        return True, '', external_lun_id_list
    return cliUtil.RESULT_NOCHECK, common.getMsg(LANG, 'query.result.abnormal'), external_lun_id_list


def check_product_info(cli):
    """
    判断产品是否满足检查的版本及型号范围
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    flag, cli_ret, err_msg, software_version, _ = common.getVersion(cli, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)
    flag, product_model, cli_ret, err_msg = cliUtil.getProductModelWithCliRet(cli, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)
    if software_version >= Lowest_Version_For_V3:
        return True
    return False
