# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    '''
        强制回写开关：
        回显状态值为用户数据强制回写或所有数据强制回写则巡检不通过
        巡检不通过的回显信息为：State : force_writeback
    :param cli: cli连接
    :return: 巡检结果
    '''
    flag = True
    cli_ret = ""
    err_msg = ""
    error_state = ["force_writeback"]
    try:
        cmd = "show system force_write_back"
        flag, cli_ret, err_msg = cliUtil.excuteCmdInDeveloperMode(cli, cmd,
                                                                  True, LANG)
        if flag is not True:
            LOGGER.logSysAbnormal()
            return flag, cli_ret, err_msg

        if cliUtil.queryResultWithNoRecord(cli_ret):
            return (True, cli_ret, err_msg)

        cli_ret_lines_list = cliUtil.getVerticalCliRet(cli_ret)

        if len(cli_ret_lines_list) == 0:
            err_msg = common.getMsg(LANG, "cannot.get.force.write.back")
            LOGGER.logNoPass("Cannot get information about alarm")
            return (cliUtil.RESULT_NOCHECK, cli_ret, err_msg)

        for line in cli_ret_lines_list:
            current_state = line.get("State")
            LOGGER.logInfo("currentState is %s " % current_state)
            if current_state in error_state:
                flag = False
                err_msg = common.getMsg(LANG,
                                        "system.force.write.back.info",
                                        current_state)
                LOGGER.logNoPass("System force write back is On")
                return (flag, cli_ret, err_msg)

        return (flag, cli_ret, err_msg)

    except Exception as exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cli_ret,
                common.getMsg(LANG, "query.result.abnormal"))
