# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        主机多路径状态检查：
                如果不存在相应ID的告警表示正常，否则属于不正常状态。
    '''
    flag = True
    cliRet = ""
    cliRetAll = ""
    errMsg = ""

    try:
        alarmIdList = [
            "0xF00150019", "0xF0015001A", "0xF0015001B",  "0xF0015001D",
            "0xF00150021", "0xF00150034", "0xF00150033", "0xF00150025"
        ]
        for alarmId in alarmIdList:
            cmd = "show alarm|filterRow column=ID predict=equal_to value=%s" % alarmId
            
            LOGGER.logExecCmd(cmd)
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
            cliRetAll += checkRet[1]
            if checkRet[0] != True: 
                errMsg += checkRet[2]
                LOGGER.logSysAbnormal()
                return (checkRet[0], cliRetAll, errMsg)  # 修改备注：命令执行失败不能返回不通过
            
            cliRet = checkRet[1]
            if cliUtil.queryResultWithNoRecord(cliRet):
                continue
            
            cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
            if len(cliRetLinesList) == 0:
                errMsg += common.getMsg(LANG, "cannot.get.alarm.info")
                LOGGER.logNoPass("Cannot get information about alarm")
                return (cliUtil.RESULT_NOCHECK, cliRetAll, errMsg)  # 修改备注：解析回显失败导致列表长度为0
            else:
                flag = False
                errMsg += common.getMsg(LANG, "host.multipathing.status.abnormal", alarmId)
                LOGGER.logNoPass("The host multipathing status is abnormal (alarm id:%s)" % alarmId)
                
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRetAll, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
