# -*- coding: UTF-8 -*-
import cliUtil
import common
from cbb.frame.base import baseUtil
from common_utils import is_flush_through_mode

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env

def execute(cli):
    '''
    Hotspare容量检查: 
        1 如果硬盘域不存在表示正常；
        2 Used Hot Spare Capacity为0表示正常或者硬盘域所有硬盘均为正常盘(硬盘的Health Status为Normal且Running Status为Online)表示正常。\n3 其它情况均属于不正常状态。
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        product_model = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
        if baseUtil.is_micro_dev(product_model) and is_flush_through_mode(cli, LANG, LOGGER):
            return (cliUtil.RESULT_NOSUPPORT, "System mode: pass-through mode.", errMsg)
        cmd = "show disk_domain general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.disk.domain.info")
            LOGGER.logNoPass("Cannot get information about disk domain")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0

        for line in cliRetLinesList:
            Id = line.get("ID")
            usedHotSpareCapacity = line.get("Used Hot Spare Capacity")
            realUsedHotSpareCapacity = common.getRealCapacity(usedHotSpareCapacity)
            if len(realUsedHotSpareCapacity) == 0:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.used.hot.spare.capacity.info", Id)
                LOGGER.logNoPass("Cannot get information about Used Hot Spare Capacity of POOL [%s]" % Id)
            elif not float(realUsedHotSpareCapacity) == float(0):
                flag, cliRetItem, errMsgItem = checkDiskDomainStatus(cli, Id, LANG)
                cliRet += cliRetItem
                if not flag:

                    errMsg += common.getMsg(LANG, "pool.used.hot.spare.capacity.abnormal", (Id, usedHotSpareCapacity))
                    LOGGER.logNoPass("The Used Hot Spare Capacity of POOL [%s] is more than 0 (Capacity:%s)" 
                         % (Id, usedHotSpareCapacity))
                    
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))



def checkDiskDomainStatus(cli, diskdomain, LANG): 
    '''
    @summary: 检查disk_domain下的硬盘状态是否正常
    @param diskdomain:硬盘域ID
    @return: 硬盘状态
             CLI回显
             错误信息
    '''  
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show disk in_domain disk_domain_id=%s |filterRow column=Health\sStatus predict=not predict2=equal_to value=Normal logicOp=or column=Running\sStatus predict=not predict2=equal_to value=Online" % diskdomain
        
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.disk.info")
            LOGGER.logNoPass("Cannot get information about disk status")
            return (False, cliRet, errMsg)

        for line in cliRetLinesList:
            flag = False
            diskID = line.get("ID")
            errMsg += common.getMsg(LANG, "disk.status.abnormal", diskID)
            LOGGER.logNoPass("The status of Disk [%s] is abnormal" % diskID)
            
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))