# -*- coding: UTF-8 -*-
import cliUtil
import common
import traceback
import config
from common import UnCheckException
from common import AsynProgress
PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ''
CHECK_RESULT_INFO_LIST = []
def execute(cli):
    '''
    一层分区dirty quota使用总量检查 
        步骤1 以admin用户登录设备。
        步骤2 执行命令：change user_mode current_mode user_mode=developer，进入developer模式。
        步骤3 执行命令: debug，进入debug模式。
        步骤4 执行命令：quota show pttinfo [id]，id范围0-8，查看VOL_DIRTY_FS项used的数值。
        步骤5 minisystem视图下执行sshtoremoteExt x(x = 节点id % 引擎下节点数量) 命令，实现同引擎内控制器间跳转登录。
        步骤6 登录当前引擎内所有控制器执行步骤2、3、4。
        步骤7 连接集群中所有引擎执行步骤2、3、4、5。
        步骤8 执行命令：change user_mode current_mode user_mode=developer，进入developer模式。。
        步骤9 执行命令: show lun dedup_compress，获取阵列rowlun id。
        步骤10 执行命令：show upgrade package，显示Software Version信息，获取Current Version字段；接着查看当前补丁版本信息，获取Current Version字段。
        步骤11 执行命令：debug，进入debug模式。
        步骤12 执行命令：对步骤3获取的rowlun id，依次输入命令，devlun showctrl [rowlun_id]，获取显示项LUN Related ID字段。
 
    1、如果步骤4获取到的VOL_DIRTY_FS项used的数值小于0，巡检“不通过”，继续巡检。否则执行下一步。
    2、如果步骤6不能登录引擎内所有控制器，返回未检查。
    3、如果步骤5不能所有引擎都连接并登录，返回未检查。
    4、步骤9查询后显示项为阵列上的所有rowlun信息，若显示项为空，则巡检“通过”，否则执行下一步。
    5、查看步骤10的Software Version的Current Version，针对不同的版本按照不同的策略处理：
            如果当前系统版本为V300R002C10，V300R002C10SPC100，V300R003C00，V300R003C10，V300R005C00，V300R005C01，则巡检“不通过”；
            如果当前系统版本为V300R002C10SPC200，V300R003C00SPC100，V300R003C10SPC100, V300R005C00SPC300，则检查是否安装修复建议中对应版本的修复补丁，如果未安装，则巡检“不通过”，否则巡检“通过”；
            如果当前系统版本非以上版本，则执行下一步；
    6、查看步骤12中所有显示项LUN Related ID，若不存在数值4294967295，则巡检“通过”，否则针对不同的版本按照不同的策略处理：
            如果当前系统版本为V300R003C20，V300R003C20SPC100，V300R006C00，V300R006C10，则巡检“不通过”；
            如果当前系统版本为V300R003C20SPC200，V300R006C00SPC100，V300R006C10SPC100，V300R006C20，则检查是否安装修复建议中对应的补丁，如果未安装，则巡检“不通过”，否则巡检“通过”；
    '''
    global ALL_CLI_RET
    myPthread = AsynProgress(PY_JAVA_ENV, LOGGER, sleepTime = 0.3)
    myPthread.start_thread()
    connCli = ""
    try:
        productModel = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
        productVersion = str(PY_JAVA_ENV.get("devInfo").getProductVersion())
        LOGGER.logInfo("productModel is: %s, productVersion:%s" % (productModel, productVersion))
        if productVersion not in config.InvolvingVersions or productModel not in config.InvolvingDeviceTypes:
            return (cliUtil.RESULT_NOSUPPORT, common.version_no_support_msg(
                productModel, productVersion, config.InvolvingVersions,
                config.InvolvingDeviceTypes, LANG), "")
        
        #如果是18000执行debug命令获取阵列链接
        createRet = common.createDeviceCliContFor18000(cli, PY_JAVA_ENV, LOGGER, LANG)
        if createRet[0] != True:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, createRet[2]
        connCli = createRet[1]
        
        #检查VOL_DIRTY_FS项used的数值小于0
        checkRet = checkVolDirtyFsUsed(connCli, PY_JAVA_ENV, LOGGER, LANG, "")
        LOGGER.logInfo("checkVolDirtyFsUsed CHECK_RESULT_INFO_LIST:%s" % str(CHECK_RESULT_INFO_LIST))
        for checkResult in CHECK_RESULT_INFO_LIST:
            if checkResult[0] == False:
                return False, ALL_CLI_RET, checkResult[1]
            
        
        #检查是否存在RowLun
        checkRet = checkDeviceRowlunIsNull(connCli, LOGGER, LANG)
        if checkRet[0] != common.CHECK_FLAG_CONTINUE:
            return checkRet[0], ALL_CLI_RET, checkRet[1]
        
        #检查是否是问题版本
        checkRet = checkifIsTheProblemVersion(connCli, LOGGER, LANG, config.noPassVersionSetp5, config.needInstallPatchVersionSetp5)
        if checkRet[0] != common.CHECK_FLAG_CONTINUE:
            return checkRet[0], ALL_CLI_RET, checkRet[1]
        
        #检查是否存在老rowlun
        checkRet = checkIsExistOldRowLun(connCli, LOGGER, LANG)
        if checkRet[0] != common.CHECK_FLAG_CONTINUE:
            return checkRet[0], ALL_CLI_RET, checkRet[1]
        
        #检查是否是问题版本
        checkRet = checkifIsTheProblemVersion(connCli, LOGGER, LANG, config.noPassVersionSetp6, config.needInstallPatchVersionSetp6)
        if checkRet[0] != common.CHECK_FLAG_CONTINUE:
            return checkRet[0], ALL_CLI_RET, checkRet[1]
        
        LOGGER.logInfo("The current version is not in the scope of the version involved, check through.")
        return (True, ALL_CLI_RET, "")        
    except UnCheckException, unCheckException:
        LOGGER.logInfo(u"UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET + unCheckException.cliRet, unCheckException.errorMsg)
    except:
        LOGGER.logInfo(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))

    finally:
        myPthread.setStopFlag(True)
        if connCli != "":
            if common.is18000(PY_JAVA_ENV, connCli):
                common.closeConnection(connCli, PY_JAVA_ENV, LOGGER)
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))

        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def getvolDirtyFsUsed(cli, LOGGER, LANG):
    '''
           获取VOL_DIRTY_FS项used的数值
    '''
    allCliRet = ""
    errMsg = ""
    volDirtyFsUsedList = []
    for id in range(0, 9):
        cmd = "quota show pttinfo %s" % str(id)
        flag, cliRet, errMsg = common.executeOneDebugCommand(cli, cmd, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return flag, allCliRet, volDirtyFsUsedList, errMsg
        volumeCacheIndex = cliRet.find("volume cache")
        stripeCacheIndex = cliRet.find("stripe cache")
        volumeCacheList = cliUtil.getHorizontalCliRet(cliRet[(volumeCacheIndex):stripeCacheIndex])
        for volumeCache in volumeCacheList:
            if volumeCache.get("quotaType", "") == "VOL_DIRTY_FS":
                volDirtyFsUsedList.append(volumeCache.get("used", ""))
    return True, allCliRet, volDirtyFsUsedList, ""

def getDeviceRowlunIdList(cli, LOGGER, LANG):
    '''
          获取阵列 rowlun id
    '''
    allCliRet = ""
    deviceRowlunIdList = []
    cmd = "show lun dedup_compress"
    flag, cliRet, errMsg = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        return flag, allCliRet, deviceRowlunIdList, errMsg
    lunDedupList = cliUtil.getHorizontalCliRet(cliRet)
    for lunDedup in lunDedupList:
        deviceRowlunIdList.append(lunDedup.get("ID", ""))
    return True, allCliRet, deviceRowlunIdList, ""

def getlunRelatedIdList(cli, deviceRowlunIdList, LOGGER, LANG): 
    '''
        获取LUN Related ID
    ''' 
    allCliRet = ""         
    errMsg = ""
    lunRelatedIdList = []
    for deviceRowlunId in deviceRowlunIdList:
        cmd = "devlun showctrl %s" % str(deviceRowlunId)
        flag, cliRet, errMsg = common.executeOneDebugCommand(cli, cmd, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return flag, allCliRet, lunRelatedIdList, errMsg
        devLunsDictList = cliUtil.getVerticalCliRet(cliRet)
        LOGGER.logInfo("devLunsDictList:%s" % str(devLunsDictList))
        for devLunsDict in devLunsDictList:
            lunRelatedIdList.append(devLunsDict.get("LUN Related ID", ""))
    return True, allCliRet, lunRelatedIdList, ""

@common.checkAllEngineInClusterWarp
def checkVolDirtyFsUsed(Cli, PY_JAVA_ENV, LOGGER, LANG, heartBeatCliRet):
    global ALL_CLI_RET, CHECK_RESULT_INFO_LIST
    LOGGER.logInfo("checkVolDirtyFsUsed heartBeatCliRet:%s"%heartBeatCliRet)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, heartBeatCliRet)
    flag, cliRet, volDirtyFsUsedList, errMsg = getvolDirtyFsUsed(Cli, LOGGER, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, "")
    LOGGER.logInfo("checkPartitionVolDirtyUseIsNegative volDirtyFsUsedList:%s" % str(volDirtyFsUsedList))
    for volDirtyFsUsed in volDirtyFsUsedList:
        if int(volDirtyFsUsed) < 0:
            errMsg = common.getMsg(LANG, "dirty.quota.voldoirtyfs.less.0")
            CHECK_RESULT_INFO_LIST.append((False, errMsg))
            return common.CHECK_FLAG_NOT_CONTINUE
    return common.CHECK_FLAG_CONTINUE

def checkDeviceRowlunIsNull(connCli, LOGGER, LANG):
    global ALL_CLI_RET
    #获取阵列rowlun id
    flag, cliRet, deviceRowlunIdList, errMsg = getDeviceRowlunIdList(connCli, LOGGER, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, "")
    LOGGER.logInfo("checkPartitionVolDirtyUseIsNegative deviceRowlunIdList:%s" % str(deviceRowlunIdList))
    if len(deviceRowlunIdList) == 0:
        return (True, "")
    return common.CHECK_FLAG_CONTINUE, ""
       
def checkifIsTheProblemVersion(connCli, LOGGER, LANG, noPassVersion, needInstallPatchVersion):
    global ALL_CLI_RET
    #获取Current Version和Current Hot Patch Version
    flag, productVersion, hotPatchVersion, cliRet, errMsg = common.getProductVersionAndHotPatchVersion(connCli, LOGGER, LANG)
    if cliRet not in ALL_CLI_RET:
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        raise  UnCheckException(errMsg, "")
    LOGGER.logInfo("checkPartitionVolDirtyUseIsNegative productVersion:%s, hotPatchVersion:%s"\
                   % (productVersion, hotPatchVersion))
    if productVersion in noPassVersion:
        errMsg = common.getMsg(LANG, "dirty.quota.no.patch", (productVersion, str(noPassVersion)))
        return (False, errMsg)
    if productVersion in needInstallPatchVersion.keys():
        if hotPatchVersion >= needInstallPatchVersion.get(productVersion, "")\
         and hotPatchVersion != "--" and hotPatchVersion != "" and hotPatchVersion[-2:] != "99":
            LOGGER.logInfo("The current version of %s exists in the following version %s,\
             and the patch version %s greater than the required patch version %s, check through." % \
                                    (productVersion, str(noPassVersion), hotPatchVersion, \
               needInstallPatchVersion.get(productVersion, "")))
            return (True, "")
        else:
            errMsg = common.getMsg(LANG, "dirty.quota.patchver.less.required.patchver", \
                                    (productVersion, str(noPassVersion), hotPatchVersion, \
               needInstallPatchVersion.get(productVersion, "")))
            return (False, errMsg)
    return common.CHECK_FLAG_CONTINUE, ""
    
def checkIsExistOldRowLun(connCli, LOGGER, LANG):
    global ALL_CLI_RET
    #获取阵列rowlun id
    flag, cliRet, deviceRowlunIdList, errMsg = getDeviceRowlunIdList(connCli, LOGGER, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, "")
    LOGGER.logInfo("checkPartitionVolDirtyUseIsNegative deviceRowlunIdList:%s" % str(deviceRowlunIdList))
    #获取LUN Related ID
    flag, cliRet, lunRelatedIdList, errMsg = getlunRelatedIdList(connCli, deviceRowlunIdList, LOGGER, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, "")
    LOGGER.logInfo("checkPartitionVolDirtyUseIsNegative lunRelatedIdList:%s" % str(lunRelatedIdList))
    if "4294967295" not in lunRelatedIdList:
        LOGGER.logInfo("No LUN Related ID is 4294967295, there is no old row LUN, check the item through")
        return (True, "")
    return common.CHECK_FLAG_CONTINUE, ""
