# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
         密码有效策略检查：
         回显字段中的“Max Valid Period(Days)”可以查看密码有效期是否开启，该值为0表示没有开启，如果大于0，则表示密码有效期的期限；
   “Inactive Lock Interval(Days)”字段表示用户锁定策略开关，值为0表示未开启用户长期不登录被锁定，其他值表示对应天数不登录将被锁定（V300R003C10）。             
    '''
    
    allCliRet = ""
    errMsg = ""
    productVersion = ""
    #涉及问题版本
    bugProductVersionList = ["V300R002C10", "V300R002C10SPC100", "V300R002C10SPC200", "V300R003C10"]
    try:
        #获取产品软件版本
        checkRet, softwareVersionList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
        allCliRet += checkRet[1]
        if checkRet[0] != True:
            errMsg = checkRet[2]
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        #过滤B版本
        flag, productVersion, errMsg = common.getCurrentVersionFilterBVer(softwareVersionList, LANG)
        if not flag:
            return(cliUtil.RESULT_NOCHECK, allCliRet, errMsg )  # 修改备注：getCurrentVersionFilterBVer返回False是未检查
       
        #检查当前版本是否存在风险
        flag = common.isRiskVersion(productVersion, bugProductVersionList)
        if not flag:
            LOGGER.logInfo("The product version is %s." %productVersion )
            return (True, allCliRet, errMsg)
        
        #查询资源用户数量
        checkRet = getResourceUserCount(cli, LANG)
        allCliRet += "\n" + checkRet[1]
        if checkRet[3] == "0":
            errMsg = checkRet[2]
            LOGGER.logInfo("It has not resource user or command executed failed." )
            return (checkRet[0], allCliRet, errMsg)       
                
        #执行show resource_user safe_strategy，判断是否开启密码有效策略和用户长期不登录被锁定策略
        checkRet= isOpensafeStrategy(cli, LANG) 
        allCliRet += "\n" + checkRet[1]
        if checkRet[0] != True:
            errMsg = checkRet[2]
            LOGGER.logInfo("The Password Validity Period of Resoure User is opened." )
            return (checkRet[0], allCliRet, errMsg)
        
        return (True, allCliRet, errMsg)
                                                       
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
    
def isOpensafeStrategy(cli, LANG):
    '''
    @summary: 判断是否开启密码有效策略和用户长期不登录被锁定策略
    @param cli: cli对象
    @param LANG: 语言lang
    @return: 
        True: 未开启密码有效策略和用户长期不登录被锁定策略
        False:开启密码有效策略和用户长期不登录被锁定策略
        errMsg:错误信息
        checkRet[1]:回显信息
    '''
    
    flag = True
    errMsg = ""
    cmd = "show resource_user safe_strategy" 
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if checkRet[0] != True:
        return (checkRet[0], checkRet[1], checkRet[2])   
                  
    #判断回显信息是否有效
    if cliUtil.queryResultWithNoRecord(checkRet[1]):
        return (True, checkRet[1], checkRet[2])
    
    safeStrategyDictList = cliUtil.getVerticalCliRet(checkRet[1])
    for safeStrategyDict in safeStrategyDictList:
        maxValidDays = safeStrategyDict.get("Max Valid Period(Days)","")
        InactiveLockDays = safeStrategyDict.get("Inactive Lock Interval(Days)","")
        if maxValidDays != "0" :
            flag = cliUtil.RESULT_WARNING
            errMsg += common.getMsg(LANG, "open.password.effective.strategy", maxValidDays)
        if InactiveLockDays != "" and InactiveLockDays != "0":
            flag = cliUtil.RESULT_WARNING
            errMsg += common.getMsg(LANG, "open.user.lock.effective.strategy", InactiveLockDays)
                        
    return (flag, checkRet[1], errMsg)
      
def getResourceUserCount(cli, LANG): 
    '''
    @summary: 查询资源用户数量
    @param cli: cli对象
    @param LANG: 语言lang
    @return: 
        True: 命令执行成功
        False:命令执行出错
        checkRet[2]:错误信息
        checkRet[1]:回显信息
        number: 资源用户数量
    '''
    
    number = "0"
    cmd = "show resource_user count"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if checkRet[0] != True:
        return (checkRet[0], checkRet[1], checkRet[2], number)
    
    #判断回显信息是否有效
    if cliUtil.queryResultWithNoRecord(checkRet[1]):
        return (True, checkRet[1], checkRet[2], number)
    
    #获取资源用户数量
    resourceUserDictList = cliUtil.getVerticalCliRet(checkRet[1])
    for resourceUserDict in resourceUserDictList:
        number = resourceUserDict.get("Number", "0") 
                          
    return (True, checkRet[1], checkRet[2], number)
