# -*- coding:utf-8 -*-
import cliUtil
import common
import traceback
from decimal import Decimal
from common import UnCheckException
from config import DORADO_DEVS

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ''
ALL_ERRMSG_NO_CHECK = ''
ALL_ERRMSG_NO_PASS = ''
standard_value = 0.8


def execute(cli):
    """
    步骤1 以admin用户登录设备。
    步骤2 执行命令show storage_pool general |filterColumn include columnList=ID,Protection\sCapacity,LUN\sSubscribed\sCapacity,Total\sCapacity,Subscribed\sCapacity，获取存储池的ID、保护容量、LUN的已用容量、存储池总容量和已用容量。
    检查标准：
    1、如果步骤2存储池不存在，检查通过，否则继续向下检查。
    2、如果步骤2存在任何一个存储池，Subscribed Capacity / Total Capacity大于80%，并且Protection Capacity大于LUN Subscribed Capacity，检查结果不通过。否则检查结果通过。
    :param cli:
    :return:
    """
    global ALL_CLI_RET, ALL_ERRMSG_NO_CHECK, ALL_ERRMSG_NO_PASS
    try:
        if not check_product_info(cli):
            return cliUtil.RESULT_NOSUPPORT, ALL_CLI_RET, ''
        flag, cli_ret, err_msg = show_storage_pool(cli)
        if flag != True:
            return flag, ALL_CLI_RET, err_msg
        if cliUtil.queryResultWithNoRecord(cli_ret):
            return True, ALL_CLI_RET, ''
        check_pool_capacity(cli_ret)
        if ALL_ERRMSG_NO_PASS:
            return False, ALL_CLI_RET, common.joinLines(ALL_ERRMSG_NO_PASS, ALL_ERRMSG_NO_CHECK)
        if ALL_ERRMSG_NO_CHECK:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, ALL_ERRMSG_NO_CHECK
        return True, ALL_CLI_RET, ''
    except UnCheckException, un_check_exception:
        LOGGER.logInfo(u'UnCheckException, err_msg: %s' % un_check_exception.errorMsg)
        return un_check_exception.flag, un_check_exception.cliRet, un_check_exception.errorMsg
    except:
        LOGGER.logError(traceback.format_exc())
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, 'query.result.abnormal')


def show_storage_pool(cli):
    """
    执行命令show storage_pool general |filterColumn include columnList=ID,Protection\sCapacity,LUN\sSubscribed\sCapacity,Total\sCapacity,Subscribed\sCapacity，获取存储池的ID、保护容量、LUN的已用容量、存储池总容量和已用容量。
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    cmd = 'show storage_pool general |filterColumn include columnList=ID,Protection\sCapacity,LUN\sSubscribed\sCapacity,Total\sCapacity,Subscribed\sCapacity'
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        return flag, cli_ret, err_msg
    return True, cli_ret, ''


def check_pool_capacity(cli_ret):
    """
    如果步骤2存在任何一个存储池，Subscribed Capacity / Total Capacity大于80%，并且Protection Capacity大于LUN Subscribed Capacity，检查结果不通过。否则检查结果通过
    :param cli_ret:
    :return:
    """
    global ALL_ERRMSG_NO_CHECK, ALL_ERRMSG_NO_PASS
    change_flag = True
    no_pass_ids = []
    cli_ret_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
    for cli_ret_dict in cli_ret_list:
        storage_pool_id = cli_ret_dict.get('ID', '')
        subscribed_capacity_flag, subscribed_capacity = common.changUnit2GBLabelCapForThreeDecimalDigits(
            cli_ret_dict.get('Subscribed Capacity', ''))
        total_capacity_flag, total_capacity = common.changUnit2GBLabelCapForThreeDecimalDigits(
            cli_ret_dict.get('Total Capacity', ''))
        protection_capacity_flag, protection_capacity = common.changUnit2GBLabelCapForThreeDecimalDigits(
            cli_ret_dict.get('Protection Capacity', ''))
        lun_subscribed_capacity_flag, lun_subscribed_capacity = common.changUnit2GBLabelCapForThreeDecimalDigits(
            cli_ret_dict.get('LUN Subscribed Capacity', ''))
        if not subscribed_capacity_flag or not total_capacity_flag or not protection_capacity_flag or not lun_subscribed_capacity_flag:
            LOGGER.logError(
                'subscribed_capacity_flag : %s, total_capacity_flag : %s, protection_capacity_flag : %s, lun_subscribed_capacity_flag : %s' % (
                    subscribed_capacity_flag, total_capacity_flag, protection_capacity_flag,
                    lun_subscribed_capacity_flag))
            change_flag = False
            continue
        if total_capacity == 0:
            continue
        LOGGER.logError(
                'subscribed_capacity_flag : %s, total_capacity_flag : %s, protection_capacity_flag : %s, lun_subscribed_capacity_flag : %s' % (
                    subscribed_capacity, total_capacity, protection_capacity,
                    lun_subscribed_capacity))
        
        percentValue = float((subscribed_capacity / total_capacity).quantize(Decimal('0.00')))
        
        if  percentValue > standard_value and float(protection_capacity) > float(lun_subscribed_capacity):
            LOGGER.logError("subscribed_capacity_flag:%s, standard_value:%s"%(percentValue, standard_value))
            no_pass_ids.append(storage_pool_id)
    if not change_flag:
        ALL_ERRMSG_NO_CHECK = common.joinLines(ALL_ERRMSG_NO_CHECK, common.getMsg(LANG, 'Change.unit.failed'))
    if no_pass_ids:
        ALL_ERRMSG_NO_PASS = common.joinLines(ALL_ERRMSG_NO_PASS,
                                              common.getMsg(LANG, 'protect.capacity.no.pass', ','.join(no_pass_ids)))


def check_product_info(cli):
    """
    判断产品是否满足检查的版本及型号范围
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    flag, product_model, cli_ret, err_msg = cliUtil.getProductModelWithCliRet(cli, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)
    if product_model in DORADO_DEVS:
        return True
    return False
