# -*- coding: UTF-8 -*-
import common
import cliUtil
def execute(cli):
    '''
    SSD盘诊断功能检查
    1 如果步骤2中，执行命令后，查询到有记录，则继续检查，否则检查通过。
    2 如果步骤3中，查询到系统当前软件版本是V300R003C20SPC200，热补丁版本低于V300R003C20SPH207或V300R006C00SPC100，热补丁版本低于V300R006C00SPH105，历史版本是V300R003C10SPC100，且控制器个数大于等于4个，则继续检查；否则检查通过。
    3 如果步骤4中，SSD盘的在线诊断开关为“Off”，则检查结果为不通过，则继续检查。
    4 如果步骤5中，查询到有升级和打补丁成功的事件，则继续检查；否则检查通过。
    5 如果步骤6中，有升级和打补丁成功的事件的详细信息中Detail信息匹配到“system software”字段，则继续检查；否则检查通过。
    6 如果步骤7中，没有查询到记录，则检查不通过；否则检查通过。
        备注：
    1、    默认参数值未体现在工具的检查标准中。
    2、    判断标准4中事件被冲掉时可能存在不通过场景，和标准不符合。
    3、    不考虑升级失败再回退场景。

    '''
    cliRet = ""
    cliRetAll = ""
    LOGGER = common.getLogger(PY_LOGGER, __file__)
    LANG = common.getLang(py_java_env)
    try:
       
        bugVersionDict = {"V300R003C20SPC200":"V300R003C10SPC100", "V300R006C00SPC100":"V300R003C10SPC100"}
        noRiskHotPatchDict = {"V300R003C20SPC200":"V300R003C20SPH207", "V300R006C00SPC100":"V300R006C00SPH105"}
        #查询是否存在SSD盘
        cmd = "show disk general |filterRow column=Type predict=equal_to value=SSD logicOp=or column=Type predict=equal_to value=SSD\sSED"
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRetAll = common.joinLines(cliRetAll, cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, cliRetAll, errMsg)
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        #获取设备当前产品版本和补丁信息
        checkRet, currentVersionDictList, currentHotPatchVersionList = common.parse_upgradePackage(cli, LANG)
        cliRetAll = common.joinLines(cliRetAll, checkRet[1])
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (cliUtil.RESULT_NOCHECK, cliRetAll, checkRet[2])
        
        result, currentVersion, errMsg = common.getCurrentVersion(currentVersionDictList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, cliRetAll, errMsg)
        
        result, currentHotPatchVersion, errMsg = common.getHotPatchVersion(currentHotPatchVersionList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, cliRetAll, errMsg)
        
        #获取历史版本
        result, historyVersion, errMsg = common.getHistoryVersion(currentVersionDictList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, cliRetAll, errMsg)
        
        #判断当前设备是否为风险版本和历史版本
        if (not currentVersion in bugVersionDict) or (bugVersionDict.get(currentVersion, "") != historyVersion):
            return (True, cliRetAll, errMsg)
        
        #判断是否安装问题解决补丁，安装正确补丁：巡检通过，未安装正确补丁，继续检查
        if currentHotPatchVersion >= noRiskHotPatchDict.get(currentVersion):
            return (True, cliRetAll, errMsg)
        
        #查看控制器个数是否大于等于4
        if len(currentVersionDictList) < 4:
            return (True, cliRetAll, errMsg)
        LOGGER.logInfo("currentVersionDictList = %s" %currentVersionDictList)
        
        #检查SSD诊断开关是否开启
        flag, cliRet, errMsg = checkSsdDiagSwitch(cli, LANG)
        cliRetAll = common.joinLines(cliRetAll, cliRet)
        if flag != True:
            return (flag, cliRetAll, errMsg)
        
        #获取升级和打补丁成功事件记录
        flag, cliRet, sequenceList = getEventSequence(cli, LANG)
        cliRetAll = common.joinLines(cliRetAll, cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, cliRetAll, errMsg)
        
        #查看在固定时间是否存在0x200F000A0110告警事件       
        flag, cliRet, errMsg = checkSsdDiagEventExist(cli, sequenceList, LANG)
        cliRetAll = common.joinLines(cliRetAll, cliRet)
         
        return (flag, cliRetAll, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))

def getEventSequence(cli, lang):
    '''
             获取告警ID：0x100F010D0023的Sequence
    '''
    sequenceList = []
    cmd = "show event object_type=558 |filterRow column=ID predict=equal_to value=0x100F010D0023 |filterColumn include columnList=Sequence"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return (flag, cliRet, errMsg)
    
    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, cliRet, sequenceList)
    
    sequenceDictList = cliUtil.getHorizontalCliRet(cliRet)
    
    for sequenceDict in sequenceDictList:
        sequence = sequenceDict.get("Sequence","")
        if sequence:
            sequenceList.append(sequence)
    
    return (flag, cliRet, sequenceList)
    
def checkSsdDiagEventExist(cli, sequenceList, lang):
    '''
            检查是否存在SSD诊断功能的ID
    '''
    flag = True
    errMsg = ""
    cliRet = ""
    cliRetAll = ""
    occurredOnList = []
    latestoccurred = ""
    for sequence in sequenceList:
        cmd = "show event sequence=%s" % sequence
        
        flag, cliRet, occurredOn = getDetailEventTime(cli, cmd, lang)
        cliRetAll = common.joinLines(cliRetAll, cliRet) 
        if flag and occurredOn:
            occurredOnList.append(occurredOn)
    
    if occurredOnList:
        latestoccurred = max(occurredOnList)
    
    #升级事前被冲掉时，默认时间为：当前时间倒推10天
    if not latestoccurred:
        latestoccurred = common.getDayOfDay(False, -10)
        
    if latestoccurred:
        cmd = "show event from_time=%s |filterRow column=ID predict=equal_to value=0x200F000A0110" % latestoccurred
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRetAll = common.joinLines(cliRetAll, cliRet) 
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, cliRetAll, errMsg)
     
    if cliUtil.queryResultWithNoRecord(cliRet):
        errMsg = common.getMsg(lang, "exit.ssd.diag.abnormal")
        return (False, cliRetAll, errMsg)
    
    return (flag, cliRetAll, errMsg)      
def getDetailEventTime(cli, cmd, lang):
    '''
            获取满足Detail中存在““system software”的发生时间 Occurred On
    '''
    occurredOn = ""    
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return (flag, cliRet, errMsg)
    
    lineDictList = cliUtil.getVerticalCliRet(cliRet)
    if len(lineDictList) == 0:
        errMsg = common.getMsg(lang, "cannot.get.alarm.info")
        return (False, cliRet, errMsg)
    
    for lineDict in lineDictList:
        detail = lineDict.get("Detail","")
        if "system software" in detail:
            occurredOn = lineDict.get("Occurred On","").split(" ")[0].strip()       
    
    return (flag, cliRet, occurredOn)
    
def checkSsdDiagSwitch(cli, LANG):
    '''
    @summary: 检查SSD盘诊断开关是否开启
    '''
    #查询SSD盘诊断开关是否开启
    allCliRet = ""
    cmd = "show ssd diagswitch"
    flag, cliRet, errMsg = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        errMsg = common.getMsg(LANG, "cannot.get.info", {"zh":u"SSD盘诊断开关", "en":"the SSD disk diagnosis switch"}.get(LANG))
        return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
    
    lineDictList = cliUtil.getVerticalCliRet(cliRet)
    if len(lineDictList) == 0:
        errMsg = common.getMsg(LANG, "cannot.get.info", {"zh":u"SSD盘诊断开关", "en":"the SSD disk diagnosis switch"}.get(LANG))
        return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
    
    for lineDict in lineDictList:
        ssdDiagSwitch = lineDict.get("SSD Diag Switch","")
    
    if ssdDiagSwitch != "On":
        errMsg = {"zh": u"SSD盘诊断开关为Off",
                  "en": "the SSD disk diagnosis switch is Off"}.get(LANG)
        return (False, allCliRet, errMsg)
    
    return (True, allCliRet, errMsg)
