# -*- coding:utf-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

product_version_for_18000 = ['V100R001C00', 'V100R001C00SPC100', 'V100R001C20', 'V100R001C20SPC100']
product_version_for_V2 = ['V200R002C00', 'V200R002C00SPC100', 'V200R002C20', 'V200R002C20SPC100']
product_version_for_2800V3 = ['V300R001C00', 'V300R001C00SPC100', 'V300R003C00']
product_version_for_otherV3 = ['V300R001C10', 'V300R001C10SPC100', 'V300R002C10', 'V300R003C00']


def execute(cli):
    """
    检查存储版本状态
    步骤1：以用户admin登录设备；
    步骤2：执行命令： show upgrade package，查询产品型号和版本。
    检查标准：
    若满足以下条件，则检查不通过，否则检查通过。
    1，产品型号为18000 V1系列（含HVS系列），版本为：V100R001C99全部，V100R001C00-V100R001C00SPC100，V100R001C10-V100R001C20SPC100；
    2，若产品型号为TV2系列，版本为：V200R002C00、V200R002C00SPC100、V200R002C20、V200R002C20SPC100版本，以及V200R002C10系列。；
    3、产品型号为2800 V3，版本为：V300R001C00-V300R001C00SPC100，V300R003C00；
    4，产品型号为V3系列其他产品，版本为：V300R001C00-V300R001C10SPC100，V300R002C00-V300R002C10，V300R003C00。
    :param cli:
    :return:
    """
    cli_ret_all = ''
    try:
        # 获取产品型号
        flag, product_model, cli_ret, err_msg = cliUtil.getProductModelWithCliRet(cli, LANG)
        cli_ret_all += cli_ret
        if flag != True:
            LOGGER.logInfo('Failed to get the model of product, err_msg : %s.' % err_msg)
            return flag, cli_ret_all, err_msg
        # 获取产品版本
        flag, cli_ret, err_msg, product_version = common.getProductVersionByUpgradePackage(cli, LANG)
        cli_ret_all += cli_ret
        if flag != True:
            LOGGER.logInfo('Failed to get the version of product, err_msg : %s.' % err_msg)
            return flag, cli_ret_all, err_msg

        # 检查版本
        if not check_product_version(product_version, product_model):
            return False, cli_ret_all, common.getMsg(LANG, 'product.version.low', product_version)
        return True, cli_ret_all, ''
    except Exception, exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, cli_ret_all, common.getMsg(LANG, "query.result.abnormal")


def check_product_version(product_version, product_model):
    """
    1，若产品型号为18000 V1系列（含HVS系列），版本为：V100R001C99全部，V100R001C00-V100R001C00SPC100，V100R001C10-V100R001C20SPC100，则检查不通过；
    2，若产品型号为TV2系列，版本为：V200R002C00、V200R002C00SPC100、V200R002C20、V200R002C20SPC100版本，以及V200R002C10系列。；
    3、产品型号为2800 V3，版本为：V300R001C00-V300R001C00SPC100，V300R003C00；
    4，产品型号为V3系列其他产品，版本为：V300R001C00-V300R001C10SPC100，V300R002C00-V300R002C10，V300R003C00。
    :param product_version:
    :return:
    """
    if product_version.startswith('V100R001C99') or product_version.startswith(
            'V100R001C10') or product_version in product_version_for_18000:
        return False

    if product_version.startswith('V200R002C10') or product_version in product_version_for_V2:
        return False

    if product_model == '2800 V3':
        if product_version in product_version_for_2800V3:
            return False
        return True
    else:
        if product_version.startswith('V300R001C00') or product_version.startswith(
                'V300R002C00') or product_version in product_version_for_otherV3:
            return False
    return True
