# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        系统软件版本检查：
                所有控制器的Software Version均存在且一致表示正常，其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show version all"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        controllerRet = cliUtil.getSplitedCliRet(cliRet, "Controller:")
        cliRetLinesList = cliUtil.getVerticalCliRet(controllerRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.version.of.controller")
            LOGGER.logNoPass("Cannot get information about version of controllers")
            return (False, cliRet, errMsg)
        
        softwareVersionSet = set()
        for retDict in cliRetLinesList:
            controllerId = retDict.get("Controller")
            softwareVersion = retDict.get("Software Version")
            
            if len(softwareVersion) > 0 and softwareVersion != "--":
                softwareVersionSet.add(softwareVersion)
            else:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.software.version.of.controller", controllerId)
                LOGGER.logNoPass("Cannot get information about software version of controller [%s]" % controllerId)
    
        if len(softwareVersionSet) > 1:
            flag = False
            errMsg += common.getMsg(LANG, "software.version.of.controller.inconsistent", ", ".join(softwareVersionSet))
            LOGGER.logNoPass("The software versions of all controllers are inconsistent")
        
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
