# -*- coding: UTF-8 -*-
import codecs
import json
import os

DORADO_DEVS = ['Dorado18000 V3', "Dorado6000 V3", "Dorado5000 V3",
               "Dorado3000 V3", "OceanStor Dorado 3000 V6",
               "OceanStor Dorado 5000 V6", "OceanStor Dorado 2000", "OceanStor Dorado 2100", "OceanStor Dorado 2020",
               "OceanStor Dorado 5300 V6", "OceanStor Dorado 5500 V6",
               "OceanStor Dorado 5600 V6", "OceanStor Dorado 5800 V6",
               "OceanStor Dorado 6000 V6",
               "OceanStor Dorado 6800 V6", "OceanStor Dorado 8000 V6",
               "OceanStor Dorado 18000 V6",
               "OceanStor Dorado 18500 V6", "OceanStor Dorado 18800 V6",
               "OceanStor Dorado 3000", "OceanStor Dorado 5000", "OceanStor Dorado 6000", "OceanStor Dorado 8000",
               "OceanStor Dorado 18000", "OceanStor Dorado 5300", "OceanStor Dorado 5500", "OceanStor Dorado 5600",
               "OceanStor Dorado 6800", "OceanStor Dorado 18500", "OceanStor Dorado 18800", "OceanStor Dorado 18800K",
               "OceanStor Dorado 5600K",
               "OceanStor 2200", "OceanStor 2220", "OceanStor 5120", "OceanStor 2600", "OceanStor 2620",
               "OceanStor 5210", "OceanStor 5220", "OceanStor 5310 Capacity Flash", "OceanStor 5510 Capacity Flash",
               "OceanStor Dorado 5600K V6", "OceanStor 5310", "OceanStor 5320", "OceanStor A300",
               "OceanStor 5510", "OceanStor 5510S", "OceanStor 5300K", "OceanStor 5500K",
               "OceanStor 5610", "OceanStor 6810", "OceanStor 18510",
               "OceanStor 18500K", "OceanStor 18810", "OceanStor 5810-HS",
               "OceanStor Dorado 18800K V6", "OceanProtect X8000", "OceanProtect E8000",
               "OceanProtect X3000",
               "OceanProtect X9000", "OceanProtect X6000",
               "OceanProtect X8000K", "OceanProtect X9000K",
               "OceanStor Micro 1300", "OceanStor Micro 1500", "OceanDisk 1300", "OceanDisk 1500", "OceanDisk 1600",
               "OceanDisk 1500T", "OceanDisk 1600T", "OceanDisk 1610", "OceanDisk 1610T",
               "OceanStor 2910"]

DORADO_DEVS_V3 = ['Dorado18000 V3', "Dorado6000 V3", "Dorado5000 V3",
                  "Dorado3000 V3"]

DORADO_DEVS_V6 = ["OceanStor Dorado 3000 V6", "OceanStor Dorado 5000 V6",
                  "OceanStor Dorado 5300 V6", "OceanStor Dorado 5500 V6",
                  "OceanStor Dorado 5600 V6", "OceanStor Dorado 5800 V6",
                  "OceanStor Dorado 6000 V6", "OceanStor Dorado 2000", "OceanStor Dorado 2100", "OceanStor Dorado 2020",
                  "OceanStor Dorado 6800 V6", "OceanStor Dorado 8000 V6",
                  "OceanStor Dorado 18000 V6",
                  "OceanStor Dorado 18500 V6",
                  "OceanStor Dorado 18800 V6",
                  "OceanStor Dorado 3000", "OceanStor Dorado 5000", "OceanStor Dorado 6000", "OceanStor Dorado 8000",
                  "OceanStor Dorado 18000", "OceanStor Dorado 5300", "OceanStor Dorado 5500", "OceanStor Dorado 5600",
                  "OceanStor Dorado 6800", "OceanStor Dorado 18500", "OceanStor Dorado 18800", "OceanStor Dorado 5600K",
                  "OceanStor Dorado 18800K",
                  "OceanStor 2200", "OceanStor 2220", "OceanStor 5120", "OceanStor 2600", "OceanStor 2620",
                  "OceanStor 5210", "OceanStor 5220", "OceanStor 5310 Capacity Flash", "OceanStor 5510 Capacity Flash",
                  "OceanStor Dorado 5600K V6", "OceanStor 5310", "OceanStor 5320", "OceanStor A300",
                  "OceanStor 5510", "OceanStor 5510S", "OceanStor 5610", "OceanStor 6810",
                  "OceanStor 5810-HS", "OceanStor 5300K", "OceanStor 5500K",
                  "OceanStor 18510", "OceanStor 18500K", "OceanStor 18810",
                  "OceanStor Dorado 18800K V6", "OceanProtect X8000", "OceanProtect E8000",
                  "OceanProtect X3000",
                  "OceanProtect X9000", "OceanProtect X6000",
                  "OceanProtect X8000K", "OceanProtect X9000K",
                  "OceanStor Micro 1300", "OceanStor Micro 1500", "OceanDisk 1300", "OceanDisk 1500", "OceanDisk 1600",
                  "OceanDisk 1500T", "OceanDisk 1600T", "OceanDisk 1610", "OceanDisk 1610T",
                  "OceanStor 2910"]

DORADO_DEVS_V6_HIGH = ["OceanStor Dorado 6800 V6", "OceanStor Dorado 8000 V6", "OceanStor Dorado 18000 V6",
                       "OceanStor Dorado 18500 V6", "OceanStor Dorado 18800 V6", "OceanStor Dorado 18800K V6",
                       "OceanStor Dorado 6800", "OceanStor Dorado 8000", "OceanStor Dorado 18000",
                       "OceanStor Dorado 18500", "OceanStor Dorado 18800", "OceanStor Dorado 18800K",
                       "OceanStor 6810", "OceanStor 18510", "OceanStor 18500K", "OceanStor 18810",
                       "OceanProtect X9000", "OceanProtect X9000K"]

# 使用RoleId判断用户权限的设备型号
CHECK_RIGHT_BY_ROLEID_DEV_TYPES = ["OceanStor Dorado 3000 V6",
                                   "OceanStor Dorado 2000",
                                   "OceanStor Dorado 2020",
                                   "OceanStor Dorado 2100",
                                   "OceanStor Dorado 5000 V6",
                                   "OceanStor Dorado 5300 V6",
                                   "OceanStor Dorado 5500 V6",
                                   "OceanStor Dorado 5600 V6",
                                   "OceanStor Dorado 5800 V6",
                                   "OceanStor Dorado 6000 V6",
                                   "OceanStor Dorado 6800 V6",
                                   "OceanStor Dorado 8000 V6",
                                   "OceanStor Dorado 18000 V6",
                                   "OceanStor Dorado 18500 V6",
                                   "OceanStor Dorado 18800 V6",
                                   "OceanStor Dorado 18800K V6",
                                   "OceanStor Dorado 5600K V6",
                                   "OceanStor Dorado 3000",
                                   "OceanStor Dorado 5000",
                                   "OceanStor Dorado 5300",
                                   "OceanStor Dorado 5500",
                                   "OceanStor Dorado 5600",
                                   "OceanStor Dorado 6000",
                                   "OceanStor Dorado 6800",
                                   "OceanStor Dorado 8000",
                                   "OceanStor Dorado 18000",
                                   "OceanStor Dorado 18500",
                                   "OceanStor Dorado 18800",
                                   "OceanStor Dorado 18800K",
                                   "OceanStor Dorado 5600K",
                                   "OceanStor 2200",
                                   "OceanStor 2220",
                                   "OceanStor 5120",
                                   "OceanStor 2600",
                                   "OceanStor 2620",
                                   "OceanStor 5210",
                                   "OceanStor 5220",
                                   "OceanStor 5310",
                                   "OceanStor 5310 Capacity Flash",
                                   "OceanStor 5510 Capacity Flash",
                                   "OceanStor A300",
                                   "OceanStor 5320",
                                   "OceanStor 5510",
                                   "OceanStor 5510S",
                                   "OceanStor 5610",
                                   "OceanStor 5810-HS",
                                   "OceanStor 6810",
                                   "OceanStor 18510",
                                   "OceanStor 18500K",
                                   "OceanStor 18810",
                                   "OceanProtect X3000",
                                   "OceanProtect X8000",
                                   "OceanProtect E8000",
                                   "OceanProtect X9000",
                                   "OceanProtect X6000",
                                   "OceanProtect X8000K",
                                   "OceanProtect X9000K",
                                   "OceanStor Micro 1300",
                                   "OceanStor Micro 1500",
                                   "OceanDisk 1300",
                                   "OceanDisk 1500",
                                   "OceanDisk 1600",
                                   "OceanDisk 1500T",
                                   "OceanDisk 1600T",
                                   "OceanDisk 1610",
                                   "OceanDisk 1610T",
                                   "OceanStor 2910"
                                   ]

# BBU满配规格，键表示设备类型，值表示单个引擎下BBU的满配规格
BBU_OF_ENGINE_CONFIG_DICT = {
    "S2600T": 2,
    "S5500T": 2,
    "S5600T": 4,
    "S5800T": 4,
    "S6800T": 4,
    "2100 V3": 2,
    "2200 V3": 2,
    "2600 V3": 2,
    "2600F V3": 2,
    "2600 V3 for Video": 2,
    "2800 V3": 2,
    "5100 V3": 2,
    "5300 V3": 2,
    "5500 V3": 2,
    "5500F V3": 2,
    "5600 V3": 2,
    "5600F V3": 2,
    "5800 V3": 3,
    "5800F V3": 3,
    "6800 V3": 4,
    "6800F V3": 4,
    "6900 V3": 4,
    "HVS85T": 4,
    "HVS88T": 4,
    "18500": 4,
    "18800": 4,
    "18800F": 4,
    "18500 V3": 4,
    "18800 V3": 4,
    "18500F V3": 4,
    "18800F V3": 4,
    "Dorado3000 V3": 2,
    "Dorado5000 V3": 2,
    "Dorado6000 V3": 3,
    "Dorado18000 V3": 4,
    "2800 V5": 2,
    "2800K V5": 2,
    "2210": 2,
    "2220": 2,
    "2200 V5": 2,
    "2810 V5": 2,
    "2200 V3 Enhanced": 2,
    "2600 V3 Enhanced": 2,
    "2600F V3 Enhanced": 2,
    "5110 V5": 2,
    "5100K V5": 2,
    "5110F V5": 2,
    "5210 V5": 2,
    "5200K V5": 2,
    "5210 V5 Enhanced": 2,
    "5220 V5": 2,
    "5210F V5 Enhanced": 2,
    "5210F V5": 2,
    "5300 V5 Enhanced": 2,
    "5300 V5": 2,
    "5310 V5": 2,
    "5500 V5": 2,
    "5510 V5": 2,
    "Dorado NAS": 2,
    "5600 V5": 3,
    "5610 V5": 2,
    "5800 V5": 3,
    "5810 V5": 2,
    "6800 V5": 4,
    "6810 V5": 4,
    "18500 V5": 4,
    "18510 V5": 4,
    "18800 V5": 4,
    "18810 V5": 4,
    "5300F V5": 2,
    "5310F V5": 2,
    "5500F V5": 2,
    "5510F V5": 2,
    "5600F V5": 3,
    "5610F V5": 2,
    "5800F V5": 3,
    "5810F V5": 2,
    "6800F V5": 4,
    "6810F V5": 4,
    "18500F V5": 4,
    "18510F V5": 4,
    "18800F V5": 4,
    "18810F V5": 4,
    "5500 V5 Elite": 2,
    "OceanStor Dorado 3000 V6": 2,
    "OceanStor Dorado 2000": 2,
    "OceanStor Dorado 2020": 2,
    "OceanStor Dorado 2100": 2,
    "OceanStor Dorado 5000 V6": 2,
    "OceanStor Dorado 5300 V6": 2,
    "OceanStor Dorado 5500 V6": 2,
    "OceanStor Dorado 5600 V6": 2,
    "OceanStor Dorado 5800 V6": 4,
    "OceanStor Dorado 6000 V6": 2,
    "OceanStor Dorado 6800 V6": 4,
    "OceanStor Dorado 8000 V6": 4,
    "OceanStor Dorado 18000 V6": 4,
    "OceanStor Dorado 18500 V6": 4,
    "OceanStor Dorado 18800 V6": 4,
    "OceanStor Dorado 18800K V6": 4,
    "OceanStor Dorado 5600K V6": 2,
    "OceanStor Dorado 3000": 2,
    "OceanStor Dorado 5000": 2,
    "OceanStor Dorado 5300": 2,
    "OceanStor Dorado 5500": 2,
    "OceanStor Dorado 5600": 2,
    "OceanStor Dorado 6000": 2,
    "OceanStor Dorado 6800": 4,
    "OceanStor Dorado 8000": 4,
    "OceanStor Dorado 18000": 4,
    "OceanStor Dorado 18500": 4,
    "OceanStor Dorado 18800": 4,
    "OceanStor Dorado 18800K": 4,
    "OceanStor Dorado 5600K": 2,
    "OceanStor 2200": 2,
    "OceanStor 2220": 2,
    "OceanStor 5120": 2,
    "OceanStor 2600": 2,
    "OceanStor 2620": 2,
    "OceanStor 5210": 2,
    "OceanStor 5220": 2,
    "OceanStor 5310": 2,
    "OceanStor 5310 Capacity Flash": 2,
    "OceanStor 5510 Capacity Flash": 2,
    "OceanStor A300": 2,
    "OceanStor 5320": 2,
    "OceanStor 5300K": 2,
    "OceanStor 5510": 2,
    "OceanStor 5510S": 2,
    "OceanStor 5500K": 2,
    "OceanStor 5610": 2,
    "OceanStor 5810-HS": 2,
    "OceanStor 6810": 4,
    "OceanStor 18510": 4,
    "OceanStor 18500K": 4,
    "OceanStor 18810": 4,
    "OceanProtect X3000": 2,
    "OceanProtect X8000": 2,
    "OceanProtect E8000": 2,
    "OceanProtect X9000": 4,
    "OceanProtect X6000": 2,
    "OceanProtect X8000K": 2,
    "OceanProtect X9000K": 4,
    "OceanStor Micro 1300": 2,
    "OceanStor Micro 1500": 2,
    "OceanDisk 1300": 2,
    "OceanDisk 1500": 2,
    "OceanDisk 1600": 2,
    "OceanDisk 1500T": 2,
    "OceanDisk 1600T": 2,
    "OceanDisk 1610": 2,
    "OceanDisk 1610T": 2,
    "OceanStor 2910": 2
}

# 风扇满配规格,键[1]表示框类型，键[2]表示高度(U)，键[4]表示是否为高密框，值表示风扇个数
FAN_CONFIG_DICT = {
    ("ENG", "2", "--"): 2,  # 2U引擎框
    ("CTE", "2", "--"): 2,  # 2U引擎框
    ("ENG", "3", "--"): 6,  # 3U引擎框
    ("CTE", "3", "--"): 6,  # 3U引擎框
    ("ENG", "4", "--"): 3,  # 4U引擎框（盘框一体）
    ("CTE", "4", "--"): 3,  # 4U引擎框（盘框一体）
    ("DAE", "2", "--"): 2,  # 2U普通硬盘框
    ("DAE", "4", "high-density"): 2,  # 4U高密硬盘框
    ("DAE", "4", "--"): 4,  # 4U普通硬盘框
    ("DSW", "1", "--"): 2,  # PCIe交换框
}

# 巡检版本补丁推荐关系表
V3_MODEL_VER_PATCH_LIST = []
with codecs.open(
        os.path.join(os.path.split(os.path.realpath(__file__))[0],
                     "patch_version.json"),
        'r', encoding="utf-8") as f:
    V3_MODEL_VER_PATCH_LIST = json.load(f)

MODEL_VER_PATCH_LIST = [
    {"model": ["18500 V3", "18800 V3", "5300 V3", "5500 V3", "5600 V3", "5800 V3", "6800 V3", "2800 V3"],
     "productVersion": "V300R003C20SPC200",
     "patchVersion": "V300R003C20SPH210",
     },
    {"model": ["Dorado6000 V3", "Dorado5000 V3"],
     "productVersion": "V300R001C01SPC100",
     "patchVersion": "V300R001C01SPH103",
     },
    {"model": ["2200 V3", "2600 V3"],
     "productVersion": "V300R005C00SPC300",
     "patchVersion": "V300R005C00SPH307",
     },
]

# v3版本支持的第三方多路径做双活的主机操作系统
SUPPORT_HOST_OPERATOR_DICT = {'V300R003C20': ['Windows',
                                              'Windows Server 2012',
                                              'HP-UX',
                                              'XenServer'],
                              'V300R003C20SPC100': ['Windows',
                                                    'Windows Server 2012',
                                                    'HP-UX',
                                                    'XenServer'],
                              'V300R003C20SPC200': ['Linux',
                                                    'VMware ESX',
                                                    'Windows',
                                                    'Windows Server 2012',
                                                    'HP-UX',
                                                    'Oracle VM',
                                                    'Oracle_VM',
                                                    'XenServer'],
                              'V300R006C00SPC100': ['AIX',
                                                    'Solaris',
                                                    'Linux',
                                                    'VMware ESX',
                                                    'Windows',
                                                    'Windows Server 2012',
                                                    'HP-UX',
                                                    'Oracle VM',
                                                    'Oracle_VM',
                                                    'XenServer']}

SUPPORT_3RD_PART_HOST_OPERATOR_DICT_SAME = ["V300R001C01SPC100",
                                            "V300R002C00"]

PUBLIC_SUPPORT_3RD_PART_VERSION = 'V300R006C00SPC100'

# 不支持第三方多路径主机做双活的产品版本列表。
UNSUPPORT_PRODUCT_DICT = ['V300R001C00', 'V300R001C00SPC100',
                          'V300R001C01', 'V300R003C10', 'V300R003C00',
                          'V300R005C00', 'V300R005C01',
                          'V300R003C00SPC100', 'V300R003C10SPC100',
                          'V300R006C00']

# 特殊处理 V3R5C00/C01系列都不支持。
UN_SUPPORT_C_VERSION_SPECIAL_LIST = ['V300R005C00', 'V300R005C01']

# 融合存储+dorado v3物理主机和阵列配置主机类型映射表
ARRAY_HOST_MAPPED_REAL_HOST = {"Oracle VM": "Linux",
                               "Oracle_VM": "Linux",
                               "XenServer": "Linux",
                               "Linux": "FusionSphere,Linux",
                               "Windows": "Windows",
                               "Windows Server 2012": "Windows",
                               "AIX": "AIX",
                               "Solaris": "Solaris",
                               "VMware ESX": "VMware",
                               "Vmware ESX": "VMware",
                               "HP-UX": "HP-UX"}

# dorado v6 物理主机和阵列配置主机类型映射表
HOST_MAPPED_REAL_HOST_DORADO_V6 = {"XenServer": "Linux",
                                   "Linux": "FusionSphere,Linux",
                                   "Windows": "Windows",
                                   "AIX": "AIX",
                                   "Solaris": "Solaris",
                                   "VMware ESX": "VMware",
                                   "Vmware ESX": "VMware",
                                   "HP-UX": "HP-UX"}

DORADO_V6_SUPPORT_3RD_HOST_TYPE = ['AIX', 'Solaris', 'Linux',
                                   'VMware ESX', 'Windows', 'HP-UX',
                                   'XenServer']

diskOptimumAsModelMap = {"2200 V3": "7",
                         "2600 V3": "5",
                         "2800 V3": "5",
                         "5300 V3": "6",
                         "5500 V3": "4",
                         "5600 V3": "4",
                         "5800 V3": "3",
                         "Dorado3000 V3": "12",
                         "Dorado5000 V3": "12",
                         "Dorado6000 V3": "14",
                         "Dorado18000 V3": "14",
                         "2600F V3": "5",
                         "5500F V3": "4",
                         "5600F V3": "4",
                         "5800F V3": "3",
                         "2600 V3 for Video": "5",
                         }

# 检查项：文件系统碎片化 检查型号及版本
itemFsTreeCheckToModel = ['5300 V3', '5500 V3', '5600 V3', '5800 V3', '6800 V3']

itemFsTreeCheckToVersion = ['V300R002C10',
                            'V300R002C10SPC100',
                            'V300R002C10SPC200',
                            'V300R003C00',
                            'V300R003C00SPC100',
                            'V300R003C10',
                            'V300R003C10SPC100',
                            'V300R003C20']
DORADO_NO_HYPERMETRO_PRODUCTS = ["V300R001C00"]
# 平行组网的情况下检查版本是否大于这个版本
MAY_PARALLEL_NETWORKING_PRODUCTS_V3R6 = "V300R006C00"
# 平行组网的情况下检查版本是否大于等于这俩个版本
MAY_PARALLEL_NETWORKING_PRODUCTS_DORADO = "V300R001C21"
MAY_PARALLEL_NETWORKING_PRODUCTS_V5R7 = "V500R007C00"

# 控制器ID和节点号的映射关系
CONTROL_NODE_DICT = {"A": "0", "B": "1", "C": "2", "D": "3"}
# 扩容场景下扩容前巡检需要排除的告警检查
EXPANSION_EXCLUDE_ALARM = [
    "0x100F00D8002B",  # 存储池可用空间不足。重要
    "0x100F00D8002C",  # 存储池已无可用空间。紧急
    "0x10A0005",  # 硬盘域热备空间不足
    "0x10A0007",  # 硬盘域硬盘数量不满足热备策略要求
    "0x200F00D8011D",  # 存储池容量耗尽
    "0xD80001",  # 存储池剩余容量不足
    "0xD80002",  # 存储池容量即将耗尽
    "0xF00280047",  # 文件系统剩余容量不足。重要
    "0xF00280120",  # 文件系统剩余容量不足。重要
    "0xF00280126",  # 文件系统耗尽保护生效。重要
    "0xF00D80114",  # 存储池剩余容量不足
    "0xF00D80119",  # 存储池剩余容量不足
    "0xF00D80120",  # 存储池容量即将耗尽
    "0xF00D80142",  # 系统承诺容量不足
    "0xF00D80143",  # 系统承诺容量即将耗尽
    "0xF00D80144",  # 系统承诺容量耗尽
    "0xF00D80148",  # 可得容量消耗不符合预期
    "0xF00E00038",  # 存储池可用空间耗尽。紧急
    "0xF01050015",  # 交换机无法监控
    "0xF010A0059",  # 硬盘域热备空间不足。重要
    "0xF010B0005",  # 写入容量达到可得容量规格
    "0xF010B0006",  # 写入容量超过可得容量规格
    "0xF03300068",  # 虚拟机文件系统剩余容量低于阈值。重要
    "0xF0D80004",  # 存储池热备空间不足。重要
    "0xF0D80006",  # 存储池容量即将耗尽
]

# 成员盘检查风险版本
MEMBER_DISK_LIST_PRODUCT_VERSION = ["V300R001C00", "V300R001C00SPC100", "V300R001C01"]

# dorado 控制器pair对
CONTROLLER_PAIR_DORADO = {"0A": "0B",
                          "0C": "0D",
                          "1A": "1B",
                          "1C": "1D"
                          }


class DiskType():
    SAS = "SAS"
    SSD = "SSD"
    SATA = "SATA"
    SSD_SED = "SSD SED"
    NVMe_SSD = "NVMe SSD"
    NVMe_SSD_SED = "NVMe SSD SED"
    NearLine_SAS = "NearLine SAS"
    SAS_SED = "SAS SED"
    NearLine_SAS_SED = "NearLine SAS SED"
    SATA_SED = "SATA SED"


# SMO资源项检查,V3融合存储所有产品型号,硬盘容量规格(容量单位:GB)
SMO_DISK_CAPACITY = {
    "2200 V3": (18 * 1024),
    "2600 V3": (70 * 1024),
    "2600 V3 for Video": (70 * 1024),
    "2800 V3": (141 * 1024),
    "5300 V3": (70 * 1024),
    "5500 V3": (141 * 1024),
    "5600 V3": (141 * 1024),
    "5800 V3": (284 * 1024),
    "6800 V3": (289 * 1024),
    "18500 V3": (298 * 1024),
    "18800 V3": (307 * 1024),
}

# 指定硬盘类型的成员盘
DISK_TYPE_LEVEL = {
    DiskType.SSD: "Extreme\sPerformance",
    DiskType.SSD_SED: "Extreme\sPerformance",
    DiskType.NVMe_SSD: "Extreme\sPerformance",
    DiskType.NVMe_SSD_SED: "Extreme\sPerformance",
    DiskType.SAS: "Performance",
    DiskType.SAS_SED: "Performance",
    DiskType.NearLine_SAS: "Capacity",
    DiskType.NearLine_SAS_SED: "Capacity",
    DiskType.SATA: "Capacity",
    DiskType.SATA_SED: "Capacity"
}

# 指定硬盘类型的层级名称
DISK_TYPE_LEVEL_KEY = {
    DiskType.SSD: "Extreme Performance",
    DiskType.SSD_SED: "Extreme Performance",
    DiskType.NVMe_SSD: "Extreme Performance",
    DiskType.NVMe_SSD_SED: "Extreme Performance",
    DiskType.SAS: "Performance",
    DiskType.SAS_SED: "Performance",
    DiskType.NearLine_SAS: "Capacity",
    DiskType.NearLine_SAS_SED: "Capacity",
    DiskType.SATA: "Capacity",
    DiskType.SATA_SED: "Capacity"
}

# 指定硬盘类型的层级枚举：0:最高性能层;1:性能层;2:容量层
DISK_TYPE_LEVEL_ENUM = {
    DiskType.SSD: 0,
    DiskType.SSD_SED: 0,
    DiskType.NVMe_SSD: 0,
    DiskType.NVMe_SSD_SED: 0,
    DiskType.SAS: 1,
    DiskType.SAS_SED: 1,
    DiskType.NearLine_SAS: 2,
    DiskType.NearLine_SAS_SED: 2,
    DiskType.SATA: 2,
    DiskType.SATA_SED: 2
}

# 元数据空间指定硬盘类型的层级名称
DISK_TYPE_META_LEVEL_KEY = {
    DiskType.SSD: "0x9",
    DiskType.SSD_SED: "0x9",
    DiskType.NVMe_SSD: "0x9",
    DiskType.NVMe_SSD_SED: "0x9",
    DiskType.SAS: "0x400b",
    DiskType.SAS_SED: "0x400b",
    DiskType.NearLine_SAS: "0x800d",
    DiskType.NearLine_SAS_SED: "0x800d",
    DiskType.SATA: "0x800d",
    DiskType.SATA_SED: "0x800d"
}

# 指定硬盘类型的层级名称
DISK_TYPE_SECTOR = {
    DiskType.SSD: 520,
    DiskType.SSD_SED: 520,
    DiskType.NVMe_SSD: 520,
    DiskType.NVMe_SSD_SED: 520,
    DiskType.SAS: 520,
    DiskType.SAS_SED: 520,
    DiskType.NearLine_SAS: 520,
    DiskType.NearLine_SAS_SED: 520,
    DiskType.SATA: 512,
    DiskType.SATA_SED: 512
}

# 元数据空间起扩盘数
DISK_NUM_OF_META_SPACE = {
    "4": 4,
    "6": 8,
    "10": 12,
}

# 进度条刷新开始标识和结束标识
PROCESS_STATE_CHECKING = "checking"
PROCESS_UPGRADE_FINISHED = "finished"

# 高密框型号
HIGH_DENSITY_ENCLOSURE_TYPE = "4U 75 Slot 3.5 SAS Disks Enclosure"

# 有风险的型号
ENCLOSURE_RISK_PRODUCT_MODE = ["2800 V3",
                               "5300 V3",
                               "5500 V3",
                               "5600 V3",
                               "5800 V3",
                               "6800 V3",
                               "6900 V3"]

# 有补丁场景
RISK_PRODUCT_AND_HAS_PATCH = {"V300R003C20": "V300R003C20SPH207",
                              "V300R006C00": "V300R006C00SPH105",
                              "V300R003C10": "V300R003C10SPH117"
                              }

# 无补丁场景
RISK_PRODUCT_AND_NO_PATCH = {"V300R001C00": "V300R001C00SPH001",
                             "V300R001C10": "V300R001C10SPH001",
                             "V300R001C10SPC100": "V300R001C10SPH001",
                             "V300R001C10SPC200": "V300R001C10SPH001",
                             "V300R001C20": "V300R001C20SPH003",
                             "V300R001C20SPC100": "V300R001C20SPH102",
                             "V300R001C20SPC200": "V300R001C20SPH208",
                             "V300R002C00": "V300R002C00SPH001",
                             "V300R002C00SPC100": "V300R002C00SPH102",
                             "V300R002C10": "V300R002C10SPH001",
                             "V300R002C10SPC100": "V300R002C10SPH107",
                             "V300R002C10SPC200": "V300R002C10SPH203",
                             "V300R003C00": "V300R003C00SPH001",
                             "V300R003C00SPC100": "V300R003C00SPH105",
                             "V300R003C10": "V300R003C10SPH001",
                             "V300R003C10SPC100": "V300R003C10SPH117",
                             "V300R003C20": "V300R003C20SPH001",
                             "V300R003C20SPC200": "V300R003C20SPH207",
                             "V300R006C00": "V300R006C00SPH001",
                             "V300R006C00SPC100": "V300R006C00SPH105",
                             }

# 存储池硬盘冗余数量检查版本
STORAGE_POOL_DISK_NUM_CHECK_PRODUCT_VERSION = ['V300R003C20',
                                               'V300R005C00',
                                               'V300R005C01',
                                               'V300R006C00',
                                               'V300R006C10',
                                               'V300R006C20',
                                               'V300R006C30',
                                               'V300R006C50',
                                               'V500R007C00',
                                               'V500R007C10',
                                               'V500R007C20',
                                               'V500R007C30',
                                               ]

REMOTE_LUN_SINGLE_LINK_CHECK_PRODUCT_VERSION = ['V300R003C00',
                                                'V300R003C10',
                                                'V300R003C20',
                                                'V300R005C00',
                                                'V300R005C01',
                                                'V300R006C00',
                                                'V300R006C10',
                                                'V300R006C01',
                                                'V300R006C20',
                                                'V500R007C00',
                                                'V500R007C10',
                                                'V300R001C00',
                                                'V300R001C01',
                                                'V300R001C20',
                                                'V300R001C21'
                                                ]

# 不支持跨引擎心跳产品型号版本
NO_SUPPORT_CROSS_ENGINE_VERSION_DICT = {
    "Dorado18000 V3": "V300R001C30",
    "Dorado5000 V3": "V300R001C21",
    "Dorado6000 V3": "V300R001C21",
    "otherModel": "V300R006C00SPC100",
}

# 区分逻辑引擎的设备型号
LOGIC_ENG_PRODUCTS = ["Dorado3000 V3",
                      "Dorado5000 V3",
                      "Dorado6000 V3",
                      "Dorado18000 V3",
                      "6900 V3",
                      "6800 V3",
                      "6800F V3"]

# 6U小卡设备型号
SMALL_SAS_6U_PRODUCTS = [
    "Dorado18000 V3",
    "6900 V3",
    "6800 V3",
    "6800F V3"]

RISK_CONTROLLER_SN = ['210305771110J6000016', '210305771110J6000014', '210305771110J6000026', '210305771110J6000029',
                      '210305771110J6000027', '210305771110J6000106', '210305771110J6000015', '210305771110J6000019',
                      '210305771110J6000017', '210305771110J6000025', '210305771110J6000018', '210305771110J6000028',
                      '210305771110J6000024', '210305771110J6000107', '210305793410J3000015', '210305793410J3000016',
                      '210305793410J3000013', '210305793410J3000014', '210305793410J3000011', '210305793410J3000012',
                      '210305793410J3000021', '210305793410J3000022', '210305793410J3000024', '21030572029WJ5000075',
                      '21030572019WJ5000020', '21030572019WJ5000010', '21030572029WJ5000088', '21030572029WJ5000047',
                      '21030572019WJ5000012', '21030572019WJ5000016', '21030572019WJ5000032', '21030572019WJ5000004',
                      '21030572019WJ5000014', '21030572019WJ5000025', '21030572019WJ5000008', '21030572029WJ5000062',
                      '21030572029WJ5000061', '21030572029WJ5000018', '21030572029WJ5000035', '21030572029WJ5000027',
                      '21030572029WJ5000033', '21030572029WJ5000036', '21030572029WJ5000013', '21030572029WJ5000039',
                      '21030572029WJ5000038', '21030572029WJ5000028', '21030572029WJ5000042', '21030572029WJ5000041',
                      '21030572029WJ5000016', '21030572019WJ5000033', '21030572019WJ5000034', '21030572019WJ5000009',
                      '21030572029WJ5000089', '21030572029WJ5000037', '21030572029WJ5000034', '21030572029WJ5000021',
                      '21030572029WJ5000020', '21030572029WJ5000119', '21030572029WJ5000127', '21030572029WJ5000268',
                      '21030572029WJ5000339', '21030572029WJ5000348', '21030572019WJ5000133', '21030572019WJ5000161',
                      '21030572019WJ5000132', '21030572019WJ5000169', '21030572019WJ5000157', '21030572019WJ5000147',
                      '21030572019WJ5000131', '21030572019WJ5000158', '21030572029WJ5000343', '21030572029WJ5000359',
                      '21030572029WJ5000342', '21030572019WJ5000135', '21030572019WJ5000138', '210305720210J5000074',
                      '21030572019WJ5000171', '21030572019WJ5000148', '21030572019WJ5000120', '21030572019WJ5000128',
                      '21030572019WJ5000127', '21030572029WJ5000260', '210305720210J6000004', '210305720210J6000008',
                      '210305720210J5000058', '210305720210J5000071', '210305720210J5000047', '21030572019WJ5000181',
                      '210305720210J5000054', '210305720210J5000053', '210305720210J5000046', '210305720210J5000079',
                      '210305720210J6000078', '21030572019WJ5000176', '210305720210J5000073', '210305720210J5000062',
                      '21030572019WJ5000165', '210305720210J5000075', '210305720210J6000059', '210305720210J5000072',
                      '21030572029WJ5000344', '21030572019WJ5000173', '21030572029WJ5000341', '21030572019WJ5000155',
                      '21030572019WJ5000162', '21030572019WJ5000163', '21030572019WJ5000137', '21030572019WJ5000150',
                      '21030572019WJ5000149', '21030572019WJ5000172', '21030572029WJ5000353', '21030572019WJ5000174',
                      '21030572019WJ5000177', '21030572029WJ5000355', '21030572019WJ5000164', '21030572019WJ5000183',
                      '21030572029WJ5000347', '210305720210J6000066', '210305720210J6000079', '21030572019WJ6000030',
                      '210305720210J6000080', '21030572019WJ6000013', '21030572019WJ6000006', '21030572029WJ6000055',
                      '210305720210J6000065', '210305720210J6000006', '210305720210J6000064', '21030572019WJ6000034',
                      '21030572019WJ6000001', '21030572019WJ6000015', '21030572029WJ5000363', '21030572019WJ6000029',
                      '210305720210J5000063', '210305720210J5000052', '210305720210J5000050', '210305720210J5000070',
                      '21030572019WJ6000183', '210305720210J5000043', '210305720210J5000048', '210305720210J5000064',
                      '210305720210J5000055', '210305720210J5000076', '210305720210J6000009', '21030572029WJ6000006',
                      '21030572029WJ6000027', '21030572029WJ6000019', '21030572029WJ6000056', '210305720210J6000024',
                      '21030572019WJ6000036', '210305720210J6000039', '21030572029WJ6000028', '210305720210J6000038',
                      '21030572029WJ6000003', '21030572029WJ6000020', '21030572019WJ6000021', '21030572029WJ6000017',
                      '21030572019WJ6000028', '210305720210J6000023', '21030572029WJ6000061', '210305720210J6000002',
                      '21030572019WJ6000010', '210305720210J6000067', '21030572029WJ6000063', '21030572019WJ6000007',
                      '210305720210J6000001', '210305720210J6000069', '21030572029WJ6000158', '21030572029WJ6000169',
                      '21030572019WJ6000251', '210305720210J6000036', '21030572019WJ6000063', '21030572029WJ6000025',
                      '21030572029WJ6000014', '21030572019WJ6000032', '21030572029WJ6000066', '21030572019WJ6000005',
                      '210305720210J6000091', '21030572029WJ5000367', '21030572029WJ6000310', '21030572029WJ6000300',
                      '21030572029WJ6000316', '21030572029WJ6000255', '21030572029WJ6000289', '21030572029WJ6000266',
                      '21030572029WJ6000177', '21030572029WJ6000315', '21030572029WJ6000302', '21030572019WJ5000198',
                      '21030572029WJ6000012', '21030572019WJ6000026', '21030572019WJ6000195', '21030572019WJ6000209',
                      '21030572029WJ6000108', '21030572019WJ6000137', '21030572019WJ6000197', '21030572029WJ6000132',
                      '21030572029WJ6000024', '21030572029WJ6000021', '21030572019WJ6000040', '21030572019WJ6000038',
                      '21030572019WJ6000047', '21030572019WJ6000083', '21030572019WJ6000093', '21030572019WJ6000058',
                      '21030572029WJ6000067', '21030572029WJ6000048', '21030572029WJ6000029', '21030572019WJ6000043',
                      '21030572019WJ6000050', '21030572019WJ6000041', '21030572029WJ6000044', '21030572019WJ6000055',
                      '21030572019WJ6000138', '21030572019WJ6000141', '21030572019WJ6000094', '21030572029WJ6000068',
                      '21030572019WJ6000165', '21030572029WJ6000058', '21030572019WJ6000164', '21030572019WJ6000046',
                      '21030572029WJ6000174', '21030572019WJ6000085', '21030572019WJ6000176', '21030572019WJ6000042',
                      '21030572029WJ6000034', '21030572029WJ6000040', '21030572029WJ6000047', '21030572029WJ6000060',
                      '21030572019WJ6000187', '21030572019WJ6000221', '21030572019WJ6000232', '21030572029WJ6000235',
                      '21030572029WJ6000304', '21030572019WJ6000231', '21030572019WJ6000222', '21030572019WJ6000216',
                      '21030572019WJ6000223', '21030572019WJ6000229', '21030572019WJ6000230', '21030572029WJ6000189',
                      '21030572029WJ6000206', '21030572029WJ6000117', '21030572029WJ6000196', '21030572029WJ6000119',
                      '21030572029WJ6000210', '21030572029WJ6000213', '21030572029WJ6000247', '21030572029WJ6000284',
                      '21030572029WJ6000239', '21030572029WJ6000226', '21030572029WJ6000227', '210305720210J6000049',
                      '21030572029WJ6000193', '210305720210J6000055', '210305720210J6000033', '21030572029WJ6000195',
                      '210305720210J6000041', '210305720210J6000044', '210305720210J6000047', '210305720210J6000032',
                      '210305720210J6000057', '210305720210J6000025', '21030572019WJ6000168', '210305720210J6000056',
                      '21030572019WJ6000169', '210305720210J6000046', '21030572029WJ6000216', '210305720210J6000045',
                      '21030572029WJ6000124', '21030572029WJ6000197', '21030572019WJ6000177', '21030572029WJ6000130',
                      '21030572029WJ6000211', '21030572019WJ6000178', '21030572029WJ6000192', '210305720210J6000050',
                      '21030572019WJ6000170', '210305720210J6000051', '210305720210J6000034', '21030572019WJ6000161',
                      '21030572019WJ6000171', '21030572019WJ6000162', '21030572019WJ6000172', '21030572019WJ6000173',
                      '21030572019WJ6000241', '21030572019WJ6000337', '21030572019WJ6000360', '21030572019WJ6000359',
                      '21030572019WJ6000354', '21030572019WJ6000332', '21030572019WJ6000252', '21030572019WJ6000369',
                      '21030572019WJ6000373', '21030572019WJ6000375', '21030572019WJ6000338', '21030572019WJ6000339',
                      '21030572019WJ6000366', '21030572019WJ6000365', '21030572019WJ6000334', '21030572019WJ6000417',
                      '21030572019WJ6000342', '21030572019WJ6000368', '21030572019WJ6000376', '21030572019WJ6000353',
                      '21030572019WJ6000350', '21030572019WJ6000346', '21030572019WJ6000358', '21030572019WJ6000367',
                      '21030572019WJ6000242', '21030572019WJ6000341', '21030572019WJ6000349', '21030572019WJ6000355',
                      '21030572019WJ6000371', '21030572019WJ6000257', '21030572019WJ6000411', '21030572019WJ6000418',
                      '21030572019WJ6000408', '21030572019WJ6000271', '21030572019WJ6000414', '21030572019WJ6000421',
                      '21030572019WJ6000236', '21030572019WJ6000258', '21030572019WJ6000244', '21030572019WJ6000273',
                      '21030572019WJ6000245', '21030572019WJ7000007', '21030572019WJ6000315', '21030572019WJ6000312',
                      '21030572019WJ6000310', '21030572019WJ6000293', '21030572019WJ6000303', '21030572019WJ6000311',
                      '21030572019WJ6000284', '21030572019WJ6000314', '21030572019WJ6000281', '21030572019WJ6000285',
                      '21030572019WJ6000309', '21030572019WJ6000287', '21030572019WJ6000279', '21030572019WJ7000003',
                      '21030572029WJ7000105', '21030572019WJ7000022', '21030572019WJ7000020', '21030572029WJ7000032',
                      '21030572029WJ7000031', '21030572019WJ7000019', '21030572019WJ7000021', '21030572029WJ7000119',
                      '21030572029WJ7000038', '21030572029WJ7000037', '21030572029WJ7000120', '21030572029WJ7000114',
                      '210305720110J7000190', '210305720210J7000025', '210305720110J7000191', '21030572029WJ7000084',
                      '21030572029WJ7000034', '21030572029WJ7000083', '21030572029WJ7000081', '21030572029WJ7000025',
                      '21030572029WJ7000035', '21030572019WJ7000050', '210305720210J7000024', '210305720210J7000019',
                      '21030572019WJ5000026', '21030572019WJ5000031', '21030572029WJ5000011', '21030572029WJ5000012',
                      '21030572029WJ5000015', '21030572029WJ5000017', '21030572029WJ5000029', '21030572029WJ5000014',
                      '21030572029WJ5000019', '21030572029WJ5000030', '21030572029WJ5000022', '21030572029WJ5000059',
                      '21030572019WJ5000054', '21030572029WJ5000261', '21030572019WJ5000118', '21030572019WJ5000117',
                      '21030572019WJ5000121', '21030572019WJ5000129', '21030572029WJ5000259', '21030572029WJ5000267',
                      '21030572019WJ5000123', '21030572019WJ5000125', '21030572019WJ5000154', '21030572019WJ5000119',
                      '21030572019WJ5000122', '21030572019WJ5000184', '210305720210J6000012', '21030572019WJ5000192',
                      '21030572019WJ5000194', '21030572019WJ5000175', '21030572019WJ5000180', '21030572029WJ5000349',
                      '210305720210J5000056', '21030572029WJ5000345', '210305720210J5000067', '210305720210J5000078',
                      '210305720210J5000059', '21030572019WJ5000193', '21030572019WJ5000182', '21030572029WJ5000350',
                      '21030572019WJ5000168', '21030572019WJ5000139', '21030572029WJ5000356', '210305720210J6000060',
                      '210305720210J6000070', '21030572029WJ5000364', '21030572029WJ6000004', '21030572019WJ6000014',
                      '21030572019WJ6000004', '21030572019WJ6000002', '21030572029WJ6000065', '21030572019WJ6000033',
                      '210305720210J5000069', '210305720210J5000051', '210305720210J5000061', '210305720210J5000077',
                      '210305720210J5000060', '21030572019WJ5000200', '21030572019WJ6000031', '21030572029WJ6000011',
                      '21030572019WJ6000003', '21030572029WJ6000005', '21030572029WJ6000026', '21030572019WJ6000020',
                      '21030572029WJ6000008', '21030572019WJ6000052', '210305720210J6000035', '21030572019WJ6000011',
                      '21030572029WJ6000062', '21030572029WJ6000294', '21030572029WJ6000309', '21030572029WJ6000133',
                      '21030572029WJ6000018', '21030572029WJ6000287', '21030572029WJ6000293', '21030572019WJ6000152',
                      '21030572029WJ6000265', '21030572029WJ6000260', '21030572029WJ6000136', '21030572019WJ6000199',
                      '21030572019WJ6000044', '21030572029WJ6000057', '21030572019WJ6000039', '21030572019WJ6000163',
                      '21030572019WJ6000059', '21030572029WJ6000257', '21030572019WJ6000099', '21030572029WJ6000173',
                      '21030572019WJ6000037', '21030572029WJ6000059', '21030572029WJ6000032', '21030572019WJ6000225',
                      '21030572019WJ6000226', '21030572029WJ6000248', '21030572029WJ6000224', '21030572019WJ6000228',
                      '21030572029WJ6000228', '21030572029WJ6000231', '21030572019WJ6000227', '21030572019WJ6000224',
                      '21030572019WJ6000220', '21030572019WJ6000174', '21030572029WJ6000118', '21030572029WJ6000194',
                      '21030572029WJ6000232', '21030572029WJ6000283', '21030572029WJ6000236', '21030572029WJ6000303',
                      '210305720210J6000042', '21030572029WJ6000207', '210305720210J6000048', '21030572029WJ6000212',
                      '210305720210J6000054', '210305720210J6000043', '21030572019WJ6000374', '21030572019WJ6000333',
                      '21030572019WJ6000340', '21030572019WJ6000372', '21030572019WJ6000370', '21030572019WJ6000345',
                      '21030572019WJ6000415', '21030572019WJ6000413', '21030572019WJ6000407', '21030572019WJ6000409',
                      '21030572019WJ6000423', '21030572019WJ6000410', '21030572019WJ6000412', '21030572019WJ6000422',
                      '21030572019WJ6000246', '21030572019WJ6000243', '21030572029WJ7000100', '21030572019WJ6000291',
                      '21030572019WJ6000304', '21030572029WJ7000099', '21030572019WJ6000292', '21030572019WJ6000288',
                      '21030572019WJ6000283', '21030572029WJ7000113', '21030572029WJ7000106', '21030572019WJ7000049',
                      '21030572029WJ7000033', '21030572019WJ7000028', '210305720110J7000192', '210305720110J7000193',
                      '210305720210J7000016', '210305720210J7000017', '21030572029WJ5000048', '21030572029WJ5000040',
                      '21030572029WJ5000085', '21030572019WJ5000018', '21030572019WJ5000160', '210305720210J5000080',
                      '21030572019WJ5000126', '210305720210J5000066', '210305720210J6000007', '21030572019WJ5000166',
                      '210305720210J5000065', '21030572019WJ5000170', '210305720210J6000068', '210305720210J6000003',
                      '21030572029WJ6000064', '21030572029WJ6000007', '210305720210J6000037', '210305720210J6000030',
                      '21030572019WJ6000009', '21030572019WJ6000012', '21030572029WJ6000013', '210305720210J6000028',
                      '210305720210J6000027', '21030572019WJ6000017', '21030572019WJ6000019', '21030572019WJ6000086',
                      '21030572019WJ6000049', '21030572029WJ6000030', '21030572019WJ6000060', '21030572029WJ6000036',
                      '21030572029WJ6000039', '21030572029WJ6000240', '21030572029WJ6000223', '21030572029WJ6000225',
                      '210305720210J6000053', '210305720210J6000058', '21030572019WJ6000167', '210305720210J6000052',
                      '21030572019WJ6000331', '21030572019WJ6000347', '21030572019WJ6000348', '21030572019WJ6000357',
                      '21030572019WJ6000416', '21030572019WJ6000419', '21030572019WJ6000274', '21030572019WJ6000272',
                      '21030572019WJ6000237', '21030572019WJ6000424', '21030572019WJ6000294', '21030572019WJ7000008',
                      '21030572019WJ6000286', '21030572029WJ7000054', '21030572029WJ7000036', '21030572019WJ7000027',
                      '21030572029WJ7000082', '210305720210J7000018', '21030572029WJ7000053', '21030572019WJ7000054',
                      '21030572019WJ5000124', '21030572019WJ5000156', '21030572019WJ6000016', '210305720210J5000057',
                      '21030572019WJ5000187', '21030572019WJ6000027', '21030572019WJ6000214', '21030572029WJ6000290',
                      '21030572019WJ6000057', '21030572029WJ6000045', '210305720210J6000031', '21030572019WJ6000406',
                      '21030572019WJ6000405', '21030572029WJ7000026', '21030572019WJ5000007', '21030572019WJ5000027',
                      '21030572029WJ5000340', '210305720210J5000081', '21030572019WJ5000153', '21030572019WJ6000022',
                      '21030572019WJ6000084', '21030572019WJ6000420', '21030572019WJ7000004', '21030572029WJ5000346',
                      '210305720210J5000049', '210305720210J6000026', '21030572019WJ6000356', '210305720210J6000092',
                      '21030572019WJ2000135', '21030572019WJ2000136', '21030572019WJ2000123', '21030572019WJ2000124',
                      '21030572019WJ2000081', '21030572019WJ2000082', '21030572019WJ2000131', '21030572019WJ2000132',
                      '21030572019WJ2000137', '21030572019WJ2000138', '21030572019WJ2000127', '21030572019WJ2000128',
                      '21030572019WJ2000129', '21030572019WJ2000133', '21030572019WJ2000134', '21030572019WJ2000115',
                      '21030572019WJ2000116', '21030572019WJ2000079', '21030572019WJ2000080', '21030572019WJ2000077',
                      '21030572019WJ2000078', '21030572019WJ2000093', '21030572019WJ2000094', '21030572029WJ3000185',
                      '21030572029WJ3000186', '21030572029WJ3000173', '21030572029WJ3000214', '21030572029WJ3000200',
                      '21030572029WJ3000195', '21030572029WJ3000196', '21030572029WJ3000152', '21030572029WJ3000178',
                      '21030572029WJ3000209', '21030572029WJ3000206', '21030572029WJ3000212', '21030572029WJ3000215',
                      '21030572019WJ2000097', '21030572019WJ2000098', '21030572019WJ3000135', '21030572019WJ3000136',
                      '21030572019WJ3000099', '21030572019WJ3000101', '21030572019WJ3000127', '21030572019WJ3000128',
                      '21030572019WJ3000133', '21030572019WJ3000134', '21030572019WJ3000125', '21030572019WJ3000126',
                      '21030572019WJ3000123', '21030572019WJ3000124', '21030572019WJ3000147', '21030572019WJ3000148',
                      '21030572019WJ3000145', '21030572019WJ3000146', '21030572019WJ3000139', '21030572019WJ3000140',
                      '21030572019WJ3000131', '21030572019WJ3000132', '21030572019WJ3000100', '21030572019WJ3000102',
                      '21030572019WJ3000141', '21030572019WJ3000142', '21030572029WJ3000271', '21030572029WJ3000272',
                      '21030572029WJ3000273', '21030572029WJ3000274', '21030572029WJ3000263', '21030572029WJ3000266',
                      '21030572019WJ3000090', '21030572019WJ3000094', '21030572019WJ3000097', '21030572019WJ3000098',
                      '21030572019WJ3000095', '21030572019WJ3000096', '21030572029WJ3000267', '21030572029WJ3000268',
                      '21030572019WJ3000075', '21030572019WJ3000076', '21030572019WJ3000077', '21030572019WJ3000078',
                      '21030572019WJ3000081', '21030572019WJ3000082', '21030572029WJ3000249', '21030572029WJ3000250',
                      '21030572019WJ3000089', '21030572019WJ3000091', '21030572029WJ3000247', '21030572029WJ3000248',
                      '21030572029WJ3000253', '21030572029WJ3000254', '21030572029WJ3000262', '21030572029WJ3000265',
                      '21030572029WJ3000269', '21030572029WJ3000270', '21030572019WJ3000151', '21030572019WJ3000152',
                      '21030572029WJ3000257', '21030572029WJ3000258', '21030572029WJ3000251', '21030572029WJ3000252',
                      '21030572029WJ3000259', '21030572029WJ3000260', '21030572029WJ3000255', '21030572029WJ3000256',
                      '21030572019WJ3000155', '21030572019WJ3000156', '21030572019WJ3000157', '21030572019WJ3000158',
                      '21030572019WJ3000161', '21030572019WJ3000162', '21030572019WJ3000165', '21030572019WJ3000166',
                      '21030572019WJ3000167', '21030572019WJ3000168', '21030572019WJ3000169', '21030572019WJ3000170',
                      '21030572019WJ3000079', '21030572019WJ3000080', '21030572019WJ3000083', '21030572019WJ3000084',
                      '21030572019WJ3000087', '21030572019WJ3000088', '21030572019WJ3000092', '21030572019WJ3000093',
                      '21030572019WJ3000129', '21030572019WJ3000130', '21030572019WJ3000144', '21030572019WJ3000137',
                      '21030572019WJ3000138', '21030572019WJ3000149', '21030572019WJ3000150', '21030572019WJ3000153',
                      '21030572019WJ3000154', '21030572019WJ3000163', '21030572019WJ3000164', '21030572019WJ3000171',
                      '21030572019WJ3000172', '21030572019WJ3000175', '21030572019WJ3000176', '21030572019WJ3000179',
                      '21030572019WJ3000180', '21030572019WJ3000183', '21030572019WJ3000184', '21030572019WJ3000185',
                      '21030572019WJ3000186', '21030572019WJ3000177', '21030572019WJ3000178', '21030572019WJ3000191',
                      '21030572019WJ3000192', '21030572019WJ3000193', '21030572019WJ3000194', '21030572019WJ3000195',
                      '21030572019WJ3000196', '21030572019WJ3000197', '21030572019WJ3000198', '21030572019WJ3000199',
                      '21030572019WJ3000200', '21030572019WJ3000201', '21030572019WJ3000202', '21030572019WJ3000203',
                      '21030572019WJ3000204', '21030572019WJ3000207', '21030572019WJ3000208', '21030572019WJ3000239',
                      '21030572019WJ3000240', '21030572019WJ3000246', '21030572029WJ3000283', '21030572029WJ3000284',
                      '21030572029WJ3000291', '21030572029WJ3000292', '21030572029WJ3000289', '21030572029WJ3000290',
                      '21030572029WJ3000277', '21030572029WJ3000278', '21030572029WJ3000279', '21030572029WJ3000353',
                      '21030572029WJ3000354', '21030572029WJ3000357', '21030572029WJ3000358', '21030572029WJ3000351',
                      '21030572029WJ3000352', '21030572029WJ3000343', '21030572029WJ3000344', '21030572029WJ3000315',
                      '21030572029WJ3000316', '21030572029WJ3000317', '21030572029WJ3000318', '21030572029WJ3000319',
                      '21030572029WJ3000320', '21030572029WJ3000323', '21030572029WJ3000324', '21030572029WJ3000325',
                      '21030572029WJ3000326', '21030572029WJ3000339', '21030572029WJ3000340', '21030572029WJ3000335',
                      '21030572029WJ3000336', '21030572029WJ3000333', '21030572029WJ3000334', '21030572029WJ3000285',
                      '21030572029WJ3000286', '21030572029WJ3000337', '21030572029WJ3000338', '21030572029WJ3000341',
                      '21030572029WJ3000342', '21030572029WJ3000355', '21030572029WJ3000356', '21030572029WJ3000347',
                      '21030572029WJ3000348', '21030572029WJ3000275', '21030572029WJ3000276', '21030572029WJ3000349',
                      '21030572029WJ3000350', '21030572019WJ3000085', '21030572019WJ3000086', '21030572019WJ3000249',
                      '21030572019WJ3000250', '21030572029WJ3000327', '21030572029WJ3000328', '21030572029WJ3000331',
                      '21030572029WJ3000332', '21030572019WJ3000216', '21030572029WJ3000313', '21030572029WJ3000314',
                      '21030572029WJ3000311', '21030572029WJ3000312', '21030572019WJ3000205', '21030572019WJ3000206',
                      '21030572019WJ3000251', '21030572019WJ3000252', '21030572029WJ3000321', '21030572029WJ3000322',
                      '21030572029WJ3000329', '21030572029WJ3000330', '21030572029WJ3000345', '21030572029WJ3000346',
                      '21030572019WJ3000217', '21030572019WJ3000218', '21030572019WJ3000159', '21030572019WJ3000160',
                      '21030572019WJ3000173', '21030572019WJ3000174', '21030572019WJ3000181', '21030572019WJ3000182',
                      '21030572019WJ3000187', '21030572019WJ3000188', '21030572019WJ3000189', '21030572019WJ3000190',
                      '21030572029WJ4000055', '21030572029WJ4000056', '21030572029WJ4000040', '21030572029WJ4000042',
                      '21030572029WJ4000035', '21030572029WJ4000036', '21030572029WJ4000034', '21030572029WJ4000031',
                      '21030572029WJ4000032', '21030572029WJ4000059', '21030572029WJ4000060', '21030572029WJ4000057',
                      '21030572029WJ4000058', '21030572029WJ4000065', '21030572029WJ5000130', '21030572019WJ5000107',
                      '21030572019WJ5000108', '21030572019WJ5000093', '21030572019WJ5000098', '21030572029WJ5000055',
                      '21030572029WJ5000052', '21030572019WJ5000001', '21030572019WJ5000075', '21030572019WJ5000115',
                      '21030572019WJ5000116', '21030572019WJ5000110', '21030572019WJ5000111', '21030572019WJ5000112',
                      '21030572019WJ5000103', '21030572019WJ5000104', '21030572019WJ5000099', '210305720210J5000028',
                      '210305720210J5000019', '210305720210J5000022', '210305720210J5000027', '210305720210J5000015',
                      '210305720210J5000024', '210305720210J5000021', '21030572019WHC000321', '21030572019WHC000306',
                      '21030572019WHC000291', '21030572029WHC000300', '21030572029WHC000140', '21030572029WHC000299',
                      '21030572029WHC000173', '21030572019WHC000296', '21030572029WHC000268', '21030572029WHC000298',
                      '21030572029WHC000255', '21030572029WHC000235', '21030572029WHC000176', '21030572029WHC000180',
                      '21030572029WHC000324', '21030572019WHC000294', '21030572029WHC000321', '21030572029WHC000323',
                      '21030572029WHC000296', '21030572029WHC000137', '21030572029WHC000179', '21030572029WHC000237',
                      '21030572019WHC000331', '21030572029WHC000200', '21030572019WHC000326', '21030572029WHC000181',
                      '21030572019WHC000345', '21030572019WHC000304', '21030572019WHC000303', '21030572019WHC000308',
                      '21030572019WHC000401', '21030572019WHC000252', '21030572019WHC000359', '21030572019WHC000348',
                      '21030572019WHC000357', '21030572019WHC000399', '21030572019WHC000408', '21030572029WHC000244',
                      '21030572019WHC000400', '21030572019WHC000307', '21030572029WHC000232', '21030572019WHC000314',
                      '21030572029WHC000234', '21030572029WHC000218', '21030572019WHC000402', '21030572029WHC000214',
                      '21030572019WHC000313', '21030572019WHC000351', '21030572019WHC000386', '21030572029WHC000245',
                      '21030572019WHC000346', '21030572019WHC000368', '21030572019WHC000356', '21030572029WHC000231',
                      '21030572029WHC000293', '21030572019WHC000250', '21030572029WHC000213', '21030572019WHC000334',
                      '21030572019WHC000339', '21030572019WHC000406', '21030572029WHC000222', '21030572019WHC000403',
                      '21030572029WHC000246', '21030572019WHC000352', '21030572019WHC000283', '21030572019WHC000148',
                      '21030572019WHC000237', '21030572019WHC000272', '21030572019WHC000257', '21030572019WHC000246',
                      '21030572019WHC000265', '21030572019WJ1000054', '21030572019WHC000377', '21030572019WHC000173',
                      '21030572029WHC000343', '21030572019WHC000216', '21030572019WHC000217', '21030572029WHC000344',
                      '21030572019WHC000289', '21030572019WHC000213', '21030572019WHC000204', '21030572019WHC000363',
                      '21030572019WHC000235', '21030572019WHC000167', '21030572019WHC000189', '21030572019WHC000193',
                      '21030572019WHC000184', '21030572019WHC000225', '21030572019WHC000218', '21030572019WHC000226',
                      '21030572019WHC000179', '21030572019WHC000178', '21030572019WHC000188', '21030572019WHC000176',
                      '21030572019WHC000195', '21030572019WHC000236', '21030572019WHC000180', '21030572019WHC000290',
                      '21030572019WHC000372', '21030572029WHC000340', '21030572019WHC000192', '21030572019WHC000364',
                      '21030572019WHC000194', '21030572019WHC000196', '21030572019WHC000203', '21030572019WHC000214',
                      '21030572019WHC000186', '21030572019WJ1000003', '21030572019WHB000385', '21030572019WHB000387',
                      '21030572029WHC000053', '21030572029WHB000990', '21030572019WHB000287', '21030572029WHB000996',
                      '21030572029WHB001017', '21030572029WHB000972', '21030572029WHB000994', '21030572029WHB001038',
                      '21030572029WHB000978', '21030572019WHB000236', '21030572019WHB000264', '21030572019WHB000278',
                      '21030572019WHB000274', '21030572019WHC000071', '21030572029WHB000940', '21030572019WHB000262',
                      '21030572019WHB000276', '21030572019WHB000280', '21030572019WHB000243', '21030572019WHC000065',
                      '21030572019WHC000034', '21030572019WHB000212', '21030572029WHB000954', '21030572029WHB000937',
                      '21030572019WHC000059', '21030572019WHC000035', '21030572019WHC000066', '21030572019WHC000015',
                      '21030572019WHC000030', '21030572019WHB000210', '21030572029WHB000941', '21030572019WHB000291',
                      '21030572019WHC000057', '21030572019WHB000269', '21030572019WHB000292', '21030572019WHC000024',
                      '21030572019WHB000277', '21030572019WHC000060', '21030572019WHB000263', '21030572019WHC000073',
                      '21030572019WHC000032', '21030572019WHB000214', '21030572029WHB000942', '21030572029WHB000949',
                      '21030572029WHB000939', '21030572019WHB000285', '21030572019WHB000211', '21030572029WHB000983',
                      '21030572019WHB000213', '21030572019WHC000063', '21030572019WHB000271', '21030572019WHC000056',
                      '21030572019WHC000068', '21030572019WHC000062', '21030572019WHB000248', '21030572019WHB000279',
                      '21030572029WHB000950', '21030572019WHC000064', '21030572019WHB000209', '21030572029WHB000991',
                      '21030572019WHC000019', '21030572019WHC000016', '21030572019WHC000074', '21030572029WHB000984',
                      '21030572019WHC000028', '21030572029WHA000072', '21030572029WHA000303', '21030572029WHA000153',
                      '21030572029WHA000150', '21030572029WHA000147', '21030572029WHA000128', '21030572029WHA000304',
                      '21030572029WHA000095', '21030572029WHA000301', '21030572029WHA000127', '21030572029WH9000403',
                      '21030572029WH9000374', '21030572029WH9000400', '21030572019WH9000302', '21030572029WH9000355',
                      '21030572029WH9000421', '21030572029WH9000414', '21030572029WH9000388', '21030572029WH9000415',
                      '21030572019WH9000306', '21030572029WH9000345', '21030572029WH9000406', '21030572029WH9000356',
                      '21030572029WH9000384', '21030572029WH9000387', '21030572029WH9000408', '21030572019WH9000309',
                      '21030572029WH9000407', '21030572019WH9000293', '21030572029WH9000413', '21030572029WH9000367',
                      '21030572029WH9000404', '21030572019WH9000296', '21030572029WH9000359', '21030572029WH9000378',
                      '21030572029WH9000399', '21030572029WH9000352', '21030572029WH9000422', '21030572029WH9000417',
                      '21030572029WH9000381', '21030572029WH9000260', '21030572019WH9000071', '21030572019WH9000176',
                      '21030572019WH9000068', '21030572019WH9000151', '21030572029WH9000015', '21030572019WH9000140',
                      '21030572019WH9000133', '21030572019WH9000079', '21030572029WH9000180', '21030572019WH9000120',
                      '21030572019WH9000074', '21030572019WH9000044', '21030572019WH9000156', '21030572029WH9000014',
                      '21030572019WH9000175', '21030572019WH9000059', '21030572019WH9000115', '21030572029WH9000167',
                      '21030572019WH9000139', '21030572019WH9000152', '21030572019WH9000164', '21030572019WH9000163',
                      '21030572019WH9000069', '21030572019WH9000072', '21030572029WH9000264', '21030572019WH9000057',
                      '21030572019WH9000137', '21030572029WH9000108', '21030572029WH9000126', '21030572019WH9000082',
                      '21030572029WH9000170', '21030572019WH9000166', '21030572019WH9000124', '21030572019WH9000180',
                      '21030572019WH9000165', '21030572029WH9000125', '21030572029WH9000010', '21030572019WH9000155',
                      '21030572019WH9000060', '21030572019WH9000179', '21030572029WH9000016', '21030572029WH9000160',
                      '21030572019WH9000067', '21030572019WH9000083', '21030572029WH9000276', '21030572029WH9000116',
                      '21030572019WH9000116', '21030572019WH9000076', '21030572029WH9000007', '21030572029WH9000168',
                      '21030572019WH9000080', '21030572029WH9000013', '21030572029WH9000259', '21030572019WH9000122',
                      '21030572019WH9000167', '21030572029WH9000275', '21030572019WH9000138', '21030572019WH9000168',
                      '21030572019WH9000123', '21030572019WH9000073', '21030572029WH9000009', '21030572019WH9000084',
                      '21030572019WH9000085', '21030572019WH9000117', '21030572019WH9000130', '21030572019WH9000136',
                      '21030572029WH9000115', '21030572029WH9000008', '21030572029WH9000107', '21030572019WH9000075',
                      '21030572019WH9000144', '21030572019WH9000081', '21030572019WH9000121', '21030572029WH9000179',
                      '21030572019WH9000070', '21030572019WH9000118', '21030572019WH9000134', '21030572019WH9000129',
                      '21030572019WH9000135', '21030572019WH9000119', '21030572029WH9000273', '21030572019WH9000043',
                      '21030572019WJ5000204', '21030572019WJ5000178', '21030572019WJ5000167', '21030572019WJ5000136',
                      '21030572019WJ5000159', '21030572029WJ5000262', '21030572029WJ5000354', '210305720210J5000068',
                      '21030572029WJ6000010', '210305720210J6000005', '210305720210J6000010', '210305720210J6000063',
                      '21030572029WJ5000360', '21030572019WJ6000051', '21030572019WJ5000140', '21030572019WJ5000179',
                      '21030572029WJ6000170', '21030572019WJ2000099', '21030572019WJ2000100']

RISK_QUORUM_PRODUCT_VERSION = ["V300R006C10",
                               "V300R006C10SPC100",
                               "V500R007C00",
                               "V500R007C00SPC100"]
# 硬盘固件版本检测检查Model字段值为HUC101818CS4200或者HUC101812CS4200，且Firmware Version字段值小于AAG4涉及的产品型号
RISK_PRODUCT_MODEL_STANDARD_ONE = ['18500 V3', '18800 V3', '18500', '18800', 'HVS85T', 'HVS88T', '6800 V3', '6900 V3',
                                   '5300 V3', '5500 V3', '5600 V3', '5800 V3', '2100 V3', '2200 V3', '2600 V3',
                                   '2800 V3']
# 硬盘固件版本检测检查Model字段值为HUS156060VLS600，且Firmware Version字段值小于A8G0涉及的产品型号
RISK_PRODUCT_MODEL_STANDARD_TWO = ['6800 V3', '6900 V3', '5300 V3', '5500 V3', '5600 V3', '5800 V3', '2100 V3',
                                   '2200 V3', '2600 V3', '2800 V3']
# 硬盘固件版本检测检查
# Model字段值以HSSD-D5开头，且Firmware Version字段值小于2142，且步骤3中存在NAS文件系统
# Model字段值以HSSD-D3J开头，且Firmware Version字段值小于9203，且步骤3中存在NAS文件系统
# Model字段值以HSSD-D322XAM开头，HSSD-D322ZAM开头，或者HSSD-D3220AM开头，且Firmware Version字段值小于5506，且步骤3中存在NAS文件系统
# 涉及的产品版本
RISK_PRODUCT_VERSION_STANDARD_THREE_FOUR_FIVE = ['V300R001C00', 'V300R001C10', 'V300R001C20', 'V300R002C10',
                                                 'V300R003C00', 'V300R003C10', 'V300R003C20', 'V300R005C00',
                                                 'V300R006C10', 'V300R006C20']
# 硬盘固件版本检测检查# Model字段值以HSSD-D5开头，且Firmware Version字段值小于2142，且步骤3中存在NAS文件系统
# Model字段值以HSSD-D3J开头，且Firmware Version字段值小于9203，且步骤3中存在NAS文件系统
# Model字段值以HSSD-D322XAM开头，HSSD-D322ZAM开头，或者HSSD-D3220AM开头，且Firmware Version字段值小于5506，且步骤3中存在NAS文件系统
# 涉及的产品型号
RISK_PRODUCT_MODEL_STANDARD_THREE_FOUR_FIVE = ['18500 V3', '18500F V3', '18800 V3', '18800F V3', '6800 V3', '6800F V3',
                                               '6900 V3', '5300 V3', '5500 V3', '5500F V3', '5600 V3', '5600F V3',
                                               '5800 V3', '5800F V3', '2100 V3', '2200 V3', '2600 V3', '2600F V3',
                                               '2800 V3']
# 硬盘固件版本检测检查Model字段值为HSSD-D6D23AL960N、HSSD-D6D23AL1T9N、HSSD-D6D23AL3T8N、HSSD-D6D23AL7T6N、HSSD-D6223AL960N、
# HSSD-D6223AL1T9N、HSSD-D6223AL3T8N或者HSSD-D6223AL7T6N，且Firmware Version字段值等于1010涉及的产品型号
RISK_PRODUCT_MODEL_STANDARD_SIX = ['18500 V3', '18500F V3', '18800 V3', '18800F V3', '6800 V3', '6800F V3', '6900 V3',
                                   '5300 V3', '5500 V3', '5500F V3', '5600 V3', '5600F V3', '5800 V3', '5800F V3',
                                   '2100 V3', '2200 V3', '2600 V3', '2600F V3', '2800 V3', '5110 V5', '5110F V5',
                                   '5210 V5', '5210F V5', '5300 V5', '5500 V5', '5500 V5 Elite', '5600 V5', '5800 V5',
                                   '6800 V5', '18500 V5', '18800 V5', '5300F V5', '5500F V5', '5600F V5', '5800F V5',
                                   '6800F V5', '18500F V5', '18800F V5', 'Dorado3000 V3',
                                   'Dorado5000 V3', 'Dorado6000 V3', 'Dorado18000 V3']

HETERO_LUN_CONF = [
    ["5300 V3", "V300R001C10", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R001C10", 750, 1006, None, "V300R006C20"],
    ["5600 V3", "V300R001C10", 1000, 1512, None, "V300R006C20"],
    ["5800 V3", "V300R001C10", 1250, 1762, None, "V300R006C20"],
    ["6800 V3", "V300R001C10", 1500, 2524, None, "V300R006C20"],
    ["6900 V3", "V300R001C10", 2000, 3024, None, "V300R006C20"],
    ["5300 V3", "V300R001C10SPC100", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R001C10SPC100", 750, 1006, None, "V300R006C20"],
    ["5600 V3", "V300R001C10SPC100", 1000, 1512, None, "V300R006C20"],
    ["5800 V3", "V300R001C10SPC100", 1250, 1762, None, "V300R006C20"],
    ["6800 V3", "V300R001C10SPC100", 1500, 2524, None, "V300R006C20"],
    ["6900 V3", "V300R001C10SPC100", 2000, 3024, None, "V300R006C20"],
    ["5300 V3", "V300R001C10SPC200", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R001C10SPC200", 750, 1006, None, "V300R006C20"],
    ["5600 V3", "V300R001C10SPC200", 1000, 1512, None, "V300R006C20"],
    ["5800 V3", "V300R001C10SPC200", 1250, 1762, None, "V300R006C20"],
    ["6800 V3", "V300R001C10SPC200", 1500, 2524, None, "V300R006C20"],
    ["6900 V3", "V300R001C10SPC200", 2000, 3024, None, "V300R006C20"],
    ["5300 V3", "V300R001C20", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R001C20", 750, 1006, None, "V300R006C20"],
    ["5600 V3", "V300R001C20", 1000, 1512, None, "V300R006C20"],
    ["5800 V3", "V300R001C20", 1250, 1762, None, "V300R006C20"],
    ["6800 V3", "V300R001C20", 1500, 2524, None, "V300R006C20"],
    ["6900 V3", "V300R001C20", 2000, 3024, None, "V300R006C20"],
    ["5300 V3", "V300R001C20SPC100", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R001C20SPC100", 750, 1006, None, "V300R006C20"],
    ["5600 V3", "V300R001C20SPC100", 1000, 1512, None, "V300R006C20"],
    ["5800 V3", "V300R001C20SPC100", 1250, 1762, None, "V300R006C20"],
    ["6800 V3", "V300R001C20SPC100", 1500, 2524, None, "V300R006C20"],
    ["6900 V3", "V300R001C20SPC100", 2000, 3024, None, "V300R006C20"],
    ["5300 V3", "V300R001C20SPC200", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R001C20SPC200", 750, 1006, None, "V300R006C20"],
    ["5600 V3", "V300R001C20SPC200", 1000, 1512, None, "V300R006C20"],
    ["5800 V3", "V300R001C20SPC200", 1250, 1762, None, "V300R006C20"],
    ["6800 V3", "V300R001C20SPC200", 1500, 2524, None, "V300R006C20"],
    ["6900 V3", "V300R001C20SPC200", 2000, 3024, None, "V300R006C20"],
    ["5300 V3", "V300R002C10", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R002C10", 750, 1006, None, "V300R006C20"],
    ["5600 V3", "V300R002C10", 1000, 1512, None, "V300R006C20"],
    ["5800 V3", "V300R002C10", 1250, 1762, None, "V300R006C20"],
    ["6800 V3", "V300R002C10", 1500, 2524, None, "V300R006C20"],
    ["5300 V3", "V300R002C10SPC100", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R002C10SPC100", 750, 1006, None, "V300R006C20"],
    ["5600 V3", "V300R002C10SPC100", 1000, 1512, None, "V300R006C20"],
    ["5800 V3", "V300R002C10SPC100", 1250, 1762, None, "V300R006C20"],
    ["6800 V3", "V300R002C10SPC100", 3200, 4224, None, "V300R006C20"],
    ["5300 V3", "V300R002C10SPC200", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R002C10SPC200", 750, 1006, None, "V300R006C20"],
    ["5600 V3", "V300R002C10SPC200", 1000, 1512, None, "V300R006C20"],
    ["5800 V3", "V300R002C10SPC200", 1250, 1762, None, "V300R006C20"],
    ["6800 V3", "V300R002C10SPC200", 3200, 4224, None, "V300R006C20"],
    ["2800 V3", "V300R003C00", 750, 1006, None, "V300R006C20"],
    ["5300 V3", "V300R003C00", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R003C00", 750, 1006, None, "V300R006C20"],
    ["5600 V3", "V300R003C00", 1000, 1512, None, "V300R006C20"],
    ["5800 V3", "V300R003C00", 1500, 2012, None, "V300R006C20"],
    ["6800 V3", "V300R003C00", 3200, 4224, None, "V300R006C20"],
    ["18500 V3", "V300R003C00", 2400, 3424, None, "V300R006C20"],
    ["18800 V3", "V300R003C00", 2400, 4448, None, "V300R006C20"],
    ["2800 V3", "V300R003C00SPC100", 750, 1006, None, "V300R006C20"],
    ["5300 V3", "V300R003C00SPC100", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R003C00SPC100", 750, 1006, None, "V300R006C20"],
    ["5600 V3", "V300R003C00SPC100", 1000, 1512, None, "V300R006C20"],
    ["5800 V3", "V300R003C00SPC100", 1500, 2012, None, "V300R006C20"],
    ["6800 V3", "V300R003C00SPC100", 3200, 4224, None, "V300R006C20"],
    ["18500 V3", "V300R003C00SPC100", 2400, 3424, None, "V300R006C20"],
    ["18800 V3", "V300R003C00SPC100", 2400, 4448, None, "V300R006C20"],
    ["5300 V3", "V300R003C10", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R003C10", 750, 1006, None, "V300R006C20"],
    ["5600 V3", "V300R003C10", 1000, 1512, None, "V300R006C20"],
    ["5800 V3", "V300R003C10", 1500, 2012, None, "V300R006C20"],
    ["6800 V3", "V300R003C10", 3200, 4224, None, "V300R006C20"],
    ["18500 V3", "V300R003C10", 2400, 3424, None, "V300R006C20"],
    ["18800 V3", "V300R003C10", 2400, 4448, None, "V300R006C20"],
    ["5300 V3", "V300R003C10SPC100", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R003C10SPC100", 750, 2798, None, "V300R006C20"],
    ["5600 V3", "V300R003C10SPC100", 1000, 3048, None, "V300R006C20"],
    ["5800 V3", "V300R003C10SPC100", 1500, 5596, None, "V300R006C20"],
    ["6800 V3", "V300R003C10SPC100", 3200, 7296, None, "V300R006C20"],
    ["18500 V3", "V300R003C10SPC100", 2400, 10592, None, "V300R006C20"],
    ["18800 V3", "V300R003C10SPC100", 2400, 10592, None, "V300R006C20"],
    ["5300 V3", "V300R003C20", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R003C20", 750, 2798, None, "V300R006C20"],
    ["5600 V3", "V300R003C20", 1000, 3048, None, "V300R006C20"],
    ["5800 V3", "V300R003C20", 1500, 5596, None, "V300R006C20"],
    ["6800 V3", "V300R003C20", 3200, 7596, None, "V300R006C20"],
    ["18500 V3", "V300R003C20", 2400, 10592, None, "V300R006C20"],
    ["18800 V3", "V300R003C20", 2400, 10592, None, "V300R006C20"],
    ["5300 V3", "V300R003C20SPC100", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R003C20SPC100", 750, 2798, None, "V300R006C20"],
    ["5600 V3", "V300R003C20SPC100", 1000, 3048, None, "V300R006C20"],
    ["5800 V3", "V300R003C20SPC100", 1500, 5596, None, "V300R006C20"],
    ["6800 V3", "V300R003C20SPC100", 3200, 7296, None, "V300R006C20"],
    ["18500 V3", "V300R003C20SPC100", 2400, 10592, None, "V300R006C20"],
    ["18800 V3", "V300R003C20SPC100", 2400, 10592, None, "V300R006C20"],
    ["2800 V3", "V300R003C20SPC200", 750, 1006, None, "V300R006C20"],
    ["5300 V3", "V300R003C20SPC200", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R003C20SPC200", 750, 2798, None, "V300R006C20"],
    ["5600 V3", "V300R003C20SPC200", 1000, 3048, None, "V300R006C20"],
    ["5800 V3", "V300R003C20SPC200", 1500, 5596, None, "V300R006C20"],
    ["6800 V3", "V300R003C20SPC200", 3200, 7296, None, "V300R006C20"],
    ["18500 V3", "V300R003C20SPC200", 2400, 10592, None, "V300R006C20"],
    ["18800 V3", "V300R003C20SPC200", 2400, 10592, None, "V300R006C20"],
    ["2200 V3", "V300R005C00SPC300", 300, 556, None, "V300R006C20"],
    ["2600 V3", "V300R005C00SPC300", 500, 756, None, "V300R006C20"],
    ["2600 V3 for Video", "V300R005C00SPC300", 500, 756, None, "V300R006C20"],
    ["2200 V3", "V300R006C00", 300, 556, None, "V300R006C20"],
    ["2600 V3", "V300R006C00", 500, 756, None, "V300R006C20"],
    ["2600 V3 for Video", "V300R006C00", 500, 756, None, "V300R006C20"],
    ["2800 V3", "V300R006C00", 750, 1006, None, "V300R006C20"],
    ["5300 V3", "V300R006C00", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R006C00", 750, 2798, None, "V300R006C20"],
    ["5600 V3", "V300R006C00", 1000, 3048, None, "V300R006C20"],
    ["5800 V3", "V300R006C00", 1500, 5596, None, "V300R006C20"],
    ["6800 V3", "V300R006C00", 3200, 7296, None, "V300R006C20"],
    ["18500 V3", "V300R006C00", 2400, 10592, None, "V300R006C20"],
    ["18800 V3", "V300R006C00", 2400, 10592, None, "V300R006C20"],
    ["2200 V3", "V300R006C00SPC100", 300, 556, None, "V300R006C20"],
    ["2600 V3", "V300R006C00SPC100", 500, 756, None, "V300R006C20"],
    ["2600 V3 for Video", "V300R006C00SPC100", 500, 756, None, "V300R006C20"],
    ["2600F V3", "V300R006C00SPC100", 500, 756, None, "V300R006C20"],
    ["2800 V3", "V300R006C00SPC100", 750, 1006, None, "V300R006C20"],
    ["5300 V3", "V300R006C00SPC100", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R006C00SPC100", 750, 2798, None, "V300R006C20"],
    ["5600 V3", "V300R006C00SPC100", 1000, 3048, None, "V300R006C20"],
    ["5800 V3", "V300R006C00SPC100", 1500, 5596, None, "V300R006C20"],
    ["6800 V3", "V300R006C00SPC100", 3200, 7296, None, "V300R006C20"],
    ["5500F V3", "V300R006C00SPC100", 750, 2798, None, "V300R006C20"],
    ["5600F V3", "V300R006C00SPC100", 1000, 3048, None, "V300R006C20"],
    ["5800F V3", "V300R006C00SPC100", 1500, 5596, None, "V300R006C20"],
    ["6800F V3", "V300R006C00SPC100", 3200, 7296, None, "V300R006C20"],
    ["18500 V3", "V300R006C00SPC100", 2400, 10592, None, "V300R006C20"],
    ["18800 V3", "V300R006C00SPC100", 2400, 10592, None, "V300R006C20"],
    ["18500F V3", "V300R006C00SPC100", 2400, 10592, None, "V300R006C20"],
    ["18800F V3", "V300R006C00SPC100", 2400, 10592, None, "V300R006C20"],
    ["2200 V3", "V300R006C10", 300, 556, None, "V300R006C20"],
    ["2600 V3", "V300R006C10", 500, 756, None, "V300R006C20"],
    ["2600 V3 for Video", "V300R006C10", 500, 756, None, "V300R006C20"],
    ["2800 V3", "V300R006C10", 750, 1006, None, "V300R006C20"],
    ["5300 V3", "V300R006C10", 500, 756, None, "V300R006C20"],
    ["5500 V3", "V300R006C10", 750, 2798, None, "V300R006C20"],
    ["5600 V3", "V300R006C10", 1200, 3048, None, "V300R006C20"],
    ["5800 V3", "V300R006C10", 1500, 5596, None, "V300R006C20"],
    ["6800 V3", "V300R006C10", 3200, 7296, None, "V300R006C20"],
    ["18500 V3", "V300R006C10", 2400, 10592, None, "V300R006C20"],
    ["18800 V3", "V300R006C10", 2400, 10592, None, "V300R006C20"],
    ["2200 V3", "V300R006C10SPC100", 300, 556, "V300R006C10SPH102", "V300R006C20"],
    ["2600 V3", "V300R006C10SPC100", 500, 756, "V300R006C10SPH102", "V300R006C20"],
    ["2600 V3 for Video", "V300R006C10SPC100", 500, 756, "V300R006C10SPH102", "V300R006C20"],
    ["2600F V3", "V300R006C10SPC100", 500, 756, "V300R006C10SPH102", "V300R006C20"],
    ["2800 V3", "V300R006C10SPC100", 750, 1006, "V300R006C10SPH102", "V300R006C20"],
    ["5300 V3", "V300R006C10SPC100", 500, 756, "V300R006C10SPH102", "V300R006C20"],
    ["5500 V3", "V300R006C10SPC100", 750, 2798, "V300R006C10SPH102", "V300R006C20"],
    ["5600 V3", "V300R006C10SPC100", 1200, 3048, "V300R006C10SPH102", "V300R006C20"],
    ["5800 V3", "V300R006C10SPC100", 1500, 5596, "V300R006C10SPH102", "V300R006C20"],
    ["6800 V3", "V300R006C10SPC100", 3200, 7296, "V300R006C10SPH102", "V300R006C20"],
    ["5500F V3", "V300R006C10SPC100", 750, 2798, "V300R006C10SPH102", "V300R006C20"],
    ["5600F V3", "V300R006C10SPC100", 1200, 3048, "V300R006C10SPH102", "V300R006C20"],
    ["5800F V3", "V300R006C10SPC100", 1500, 5596, "V300R006C10SPH102", "V300R006C20"],
    ["6800F V3", "V300R006C10SPC100", 3200, 7296, "V300R006C10SPH102", "V300R006C20"],
    ["18500 V3", "V300R006C10SPC100", 2400, 10592, "V300R006C10SPH102", "V300R006C20"],
    ["18800 V3", "V300R006C10SPC100", 2400, 10592, "V300R006C10SPH102", "V300R006C20"],
    ["18500F V3", "V300R006C10SPC100", 2400, 10592, "V300R006C10SPH102", "V300R006C20"],
    ["18800F V3", "V300R006C10SPC100", 2400, 10592, "V300R006C10SPH102", "V300R006C20"],
    ["2800 V5", "V500R007C00", 750, 1006, None, "V500R007C10"],
    ["5300 V5", "V500R007C00", 500, 756, None, "V500R007C10"],
    ["5500 V5 Elite", "V500R007C00", 750, 2798, None, "V500R007C10"],
    ["5500 V5", "V500R007C00", 750, 2798, None, "V500R007C10"],
    ["5600 V5", "V500R007C00", 1200, 3048, None, "V500R007C10"],
    ["5800 V5", "V500R007C00", 1500, 5596, None, "V500R007C10"],
    ["6800 V5", "V500R007C00", 3200, 7296, None, "V500R007C10"],
    ["5300F V5", "V500R007C00", 500, 2798, None, "V500R007C10"],
    ["5500F V5", "V500R007C00", 500, 2798, None, "V500R007C10"],
    ["5600F V5", "V500R007C00", 1000, 3048, None, "V500R007C10"],
    ["5800F V5", "V500R007C00", 1200, 5596, None, "V500R007C10"],
    ["6800F V5", "V500R007C00", 1500, 7296, None, "V500R007C10"],
    ["18500 V5", "V500R007C00", 2400, 10592, None, "V500R007C10"],
    ["18800 V5", "V500R007C00", 2400, 10592, None, "V500R007C10"],
    ["18500F V5", "V500R007C00", 2400, 10592, None, "V500R007C10"],
    ["18800F V5", "V500R007C00", 3200, 10592, None, "V500R007C10"],
    ["2800 V5", "V500R007C00SPC100", 750, 1006, "V500R007C00SPH102", "V500R007C10"],
    ["5300 V5", "V500R007C00SPC100", 500, 756, "V500R007C00SPH102", "V500R007C10"],
    ["5500 V5 Elite", "V500R007C00SPC100", 750, 2798, "V500R007C00SPH102", "V500R007C10"],
    ["5500 V5", "V500R007C00SPC100", 750, 2798, "V500R007C00SPH102", "V500R007C10"],
    ["5600 V5", "V500R007C00SPC100", 1200, 3048, "V500R007C00SPH102", "V500R007C10"],
    ["5800 V5", "V500R007C00SPC100", 1500, 5596, "V500R007C00SPH102", "V500R007C10"],
    ["6800 V5", "V500R007C00SPC100", 3200, 7296, "V500R007C00SPH102", "V500R007C10"],
    ["5300F V5", "V500R007C00SPC100", 500, 2798, "V500R007C00SPH102", "V500R007C10"],
    ["5500F V5", "V500R007C00SPC100", 500, 2798, "V500R007C00SPH102", "V500R007C10"],
    ["5600F V5", "V500R007C00SPC100", 1000, 3048, "V500R007C00SPH102", "V500R007C10"],
    ["5800F V5", "V500R007C00SPC100", 1200, 5596, "V500R007C00SPH102", "V500R007C10"],
    ["6800F V5", "V500R007C00SPC100", 1500, 7296, "V500R007C00SPH102", "V500R007C10"],
    ["18500 V5", "V500R007C00SPC100", 2400, 10592, "V500R007C00SPH102", "V500R007C10"],
    ["18800 V5", "V500R007C00SPC100", 2400, 10592, "V500R007C00SPH102", "V500R007C10"],
    ["18500F V5", "V500R007C00SPC100", 2400, 10592, "V500R007C00SPH102", "V500R007C10"],
    ["18800F V5", "V500R007C00SPC100", 3200, 10592, "V500R007C00SPH102", "V500R007C10"],
    ["Dorado6000 V3", "V300R001C00", 200, 712, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado5000 V3 SAS", "V300R001C00", 100, 612, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado6000 V3", "V300R001C00SPC100", 200, 712, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado5000 V3 SAS", "V300R001C00SPC100", 200, 712, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado6000 V3", "V300R001C01", 200, 712, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado5000 V3 SAS", "V300R001C01", 100, 612, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado5000 V3 NVMe", "V300R001C01", 100, 612, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado6000 V3", "V300R001C01SPC100", 200, 712, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado5000 V3 SAS", "V300R001C01SPC100", 200, 712, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado5000 V3 NVMe", "V300R001C01SPC100", 100, 612, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado6000 V3", "V300R001C20", 100, 712, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado5000 V3 SAS", "V300R001C20", 100, 612, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado5000 V3 NVMe", "V300R001C20", 25, 537, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado6000 V3", "V300R001C21", 120, 4296, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado5000 V3 SAS", "V300R001C21", 100, 4196, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado5000 V3 NVMe", "V300R001C21", 25, 4121, None, "V300R001C21SPC100 + V300R001C21SPH105"],
    ["Dorado6000 V3", "V300R001C21SPC100", 300, 4396, "V300R001C21SPH105", None],
    ["Dorado5000 V3 SAS", "V300R001C21SPC100", 100, 4196, "V300R001C21SPH105", None],
    ["Dorado5000 V3 NVMe", "V300R001C21SPC100", 25, 4121, "V300R001C21SPH105", None],
]
# 双活LOG分区资源检查巡检项涉及的版本及型号
hypermetro_resource_check_version = ['V300R003C00', 'V300R003C00SPC100', 'V300R003C10', 'V300R003C10SPC100',
                                     'V300R003C20', 'V300R003C20SPC100', 'V300R003C20SPC200', 'V300R005C00',
                                     'V300R005C00SPC300', 'V300R006C00', 'V300R006C00SPC100',
                                     'V300R001C00', 'V300R001C01', 'V300R001C00SPC100']
hypermetro_resource_check_model = ['2600 V3', '2600F V3', '5300 V3', '5500 V3', '5600 V3', '5800 V3', '6800 V3',
                                   '18500 V3', '18800 V3', '5500F V3', '5600F V3', '5800F V3', '6800F V3', '18500F V3',
                                   '18800F V3', 'Dorado5000 V3', 'Dorado6000 V3']
recommend_version_patch_for_v3 = {'version': 'V300R006C20', 'patch': 'V300R006C20SPH008'}
recommend_version_patch_for_v5 = {'version': 'V500R007C10', 'patch': 'V500R007C10SPH008'}
recommend_version_patch_for_dorado = {'version': 'V300R001C21SPC100', 'patch': 'V300R001C21SPH108'}
# 检查LUN拷贝的工作控制器涉及的版本及型号
checking_work_controller_for_lun_copy_version = ['V300R001C10', 'V300R001C10SPC100', 'V300R001C10SPC200', 'V300R001C20',
                                                 'V300R001C20SPC100', 'V300R001C20SPC200', 'V300R002C10',
                                                 'V300R002C10SPC100', 'V300R002C10SPC200', 'V300R003C00',
                                                 'V300R003C00SPC100', 'V300R003C10', 'V300R003C10SPC100',
                                                 'V300R003C20SPC100', 'V300R003C20SPC200', 'V300R005C00SPC300',
                                                 'V300R006C00', 'V300R006C00SPC100', 'V300R006C10']
checking_work_controller_for_lun_copy_model = ['2100 V3', '2200 V3', '2600 V3', '5300 V3', '5500 V3', '5600 V3',
                                               '5800 V3', '6800 V3', '18500 V3', '18800 V3']
# 无LUN拷贝问题的版本及补丁
no_risk_version_and_patch_for_lun_copy = {
    'V300R001C20SPC200': 'V300R001C20SPH211', 'V300R003C10SPC100': 'V300R003C10SPH117',
    'V300R003C20SPC200': 'V300R003C20SPH210', 'V300R005C00SPC300': 'V300R005C00SPH308',
    'V300R006C00SPC100': 'V300R006C00SPH111'
}
RISK_SLOT_A_B_CONTROLLER_V3 = ['V300R001C00',
                               'V300R001C10',
                               'V300R001C10SPC100',
                               'V300R001C10SPC200',
                               'V300R001C20',
                               'V300R001C20SPC100',
                               'V300R001C20SPC200',
                               'V300R002C00',
                               'V300R002C10',
                               'V300R002C10SPC100',
                               'V300R002C10SPC200',
                               'V300R003C00',
                               'V300R003C00SPC100',
                               'V300R003C10',
                               'V300R003C10SPC100',
                               'V300R003C20',
                               'V300R003C20SPC200',
                               'V300R005C00',
                               'V300R005C00SPC300',
                               'V300R005C01',
                               'V300R006C00',
                               'V300R006C00SPC100',
                               'V300R006C10SPC100',
                               'V500R007C00SPC100',
                               ]

RISK_SLOT_A_B_CONTROLLER_DORADO = ['V300R001C00SPC100',
                                   'V300R001C01SPC100']

DORADO_PRODUCT_LIST = ["Dorado3000 V3", "Dorado5000 V3", "Dorado6000 V3",
                       "Dorado18000 V3", "OceanStor Dorado 3000 V6", "OceanStor Dorado 2100",
                       "OceanStor Dorado 5000 V6", "OceanStor Dorado 5300 V6", "OceanStor Dorado 5500 V6",
                       "OceanStor Dorado 2000", "OceanStor Dorado 5600 V6", "OceanStor Dorado 5800 V6",
                       "OceanStor Dorado 2020",
                       "OceanStor Dorado 6000 V6", "OceanStor Dorado 6800 V6", "OceanStor Dorado 8000 V6",
                       "OceanStor Dorado 18000 V6", "OceanStor Dorado 18500 V6", "OceanStor Dorado 18800 V6",
                       "OceanStor Dorado 3000", "OceanStor Dorado 5000", "OceanStor Dorado 6000",
                       "OceanStor Dorado 8000", "OceanStor Dorado 18000", "OceanStor Dorado 5300",
                       "OceanStor Dorado 5500", "OceanStor Dorado 5600", "OceanStor Dorado 6800",
                       "OceanStor Dorado 18500", "OceanStor Dorado 18800", "OceanStor Dorado 18800K",
                       "OceanStor Dorado 5600K",
                       "OceanStor 2200", "OceanStor 2220", "OceanStor 5120", "OceanStor 2600", "OceanStor 2620",
                       "OceanStor 5210", "OceanStor 5220", "OceanStor 5310 Capacity Flash",
                       "OceanStor Dorado 5600K V6", "OceanStor 5310", "OceanStor 5510 Capacity Flash",
                       "OceanStor 2910", "OceanStor 5320", "OceanStor A300",
                       "OceanStor 5510", "OceanStor 5510S", "OceanStor 5610", "OceanStor 6810",
                       "OceanStor 5810-HS",
                       "OceanStor 18510", "OceanStor 18500K", "OceanStor 18810",
                       "OceanStor Dorado 18800K V6", "OceanProtect X8000", "OceanProtect E8000",
                       "OceanProtect X3000",
                       "OceanProtect X9000", "OceanProtect X6000",
                       "OceanProtect X8000K", "OceanProtect X9000K"]
# 美光风险整机条码
risk_sn_for_meiguang = ['2102350DHW10H5000075', '2102350DHW10H5000074', '2102350BVB10H5000046', '2102350HXC10H8000005',
                        '2102350BVB10H6000029', '2102350BVB10H7000062', '2102350BVD10H7000029', '2102350DHW10H6000022',
                        '2102350BVB10HB000053', '2102350DHW10HB000036', '2102350DHW10HB000035', '2102350DHW10HB000037',
                        '2102350DHW10HB000034', '2102350DHW10HB000033', '2102350BVB10HB000054', '2102350HXC10HB000115',
                        '2102350HWS10HB000011', '2102350BSJ10HB000003', '2102350BSJ10HB000004', '2102350HYS10HB000005',
                        '2102350HYS10HB000006', '2102350HYS10HB000004', '2102350HYS10HB000003', '2102350ULA10J1000004',
                        '2102350UME10J1000001']
# 支持查询单控的设备列表
config_model_list = ['2800 V3', '2800 V5', '2200 V3', '2600 V3 for Video', '2200 V3', '2100 V3']
# 异构lun检查涉及的型号
edev_lun_model = ['2200 V3', '2600 V3', '2800 V3', '5500 V3', '5300 V3', '5600 V3', '5800 V3', '6800 V3',
                  '18500 V3', '18800 V3', 'Dorado3000 V3', 'Dorado5000 V3', 'Dorado6000 V3', 'Dorado18000 V3']

# 低端存储配置ip scale-out业务检查涉及型号
ip_scale_out_model = ['2600 V3', '2600F V3', '5300 V5']
# 低端存储配置ip scale-out业务检查涉及版本
ip_scale_out_version = ["V300R005C00SPC300", "V300R006C00SPC100", "V300R006C10SPC100", "V300R006C20",
                        "V500R007C00SPC100", "V500R007C10"]

# 通用判断
# 支持跨引擎心跳开始版本
SUPPORT_ENGINE_HEART_BEAT_V3R6 = "V300R006C00SPC100"
SUPPORT_ENGINE_HEART_BEAT_V5R7 = "V500R007C00SPC100"

# 仅限Dorado V3R1C20
SUPPORT_ENGINE_HEART_BEAT_V3R1 = "V300R001C20"

# 直连组网支持跨引擎心跳版本
SUPPORT_DERICT_CONN_ENGINE_HEART_BEAT_V3R6 = "V300R006C20"
SUPPORT_DERICT_CONN_ENGINE_HEART_BEAT_V5R7 = "V500R007C10"

# 仅供【硬盘仲裁预留key值检查】
DISK_ARB_RESERVED_KEY_SLOT_0 = ['00fec00000000000', '10fec00000000000', '20fec00000000000', '30fec00000000000',
                                '40fec00000000000', '50fec00000000000', '60fec00000000000', '70fec00000000000',
                                '80fec00000000000', '90fec00000000000', 'a0fec00000000000', 'b0fec00000000000',
                                'c0fec00000000000', 'd0fec00000000000', 'e0fec00000000000']
DISK_ARB_RESERVED_KEY_SLOT_1 = ['01fec00000000000', '11fec00000000000', '21fec00000000000', '31fec00000000000',
                                '41fec00000000000', '51fec00000000000', '61fec00000000000', '71fec00000000000',
                                '81fec00000000000', '91fec00000000000', 'a1fec00000000000', 'b1fec00000000000',
                                'c1fec00000000000', 'd1fec00000000000', 'e1fec00000000000']
DISK_ARB_RESERVED_KEY_SLOT_2 = ['02fec00000000000', '12fec00000000000', '22fec00000000000', '32fec00000000000',
                                '42fec00000000000', '52fec00000000000', '62fec00000000000', '72fec00000000000',
                                '82fec00000000000', '92fec00000000000', 'a2fec00000000000', 'b2fec00000000000',
                                'c2fec00000000000', 'd2fec00000000000', 'e2fec00000000000']

# 并联3DC配置检查版本范围
parallel_connected_3DC_version = ['V300R001C10', 'V300R001C10SPC100', 'V300R001C10SPC200', 'V300R001C20',
                                  'V300R001C20SPC100', 'V300R001C20SPC200', 'V300R002C10', 'V300R002C10SPC100',
                                  'V300R002C10SPC200', 'V300R003C00', 'V300R003C00SPC100', 'V300R003C10',
                                  'V300R003C10SPC100', 'V300R003C20', 'V300R003C20SPC100', 'V300R003C20SPC200',
                                  'V300R005C00', 'V300R005C00SPC300', 'V300R005C01', 'V300R006C00', 'V300R006C00SPC100',
                                  'V300R006C01', 'V300R006C10', 'V300R006C10SPC100', 'V300R006C20', 'V500R007C00',
                                  'V500R007C00SPC100', 'V500R007C10']
parallel_connected_3DC_version_dorado = ['V300R001C01SPC100', 'V300R001C20', 'V300R001C21', 'V300R001C21SPC100',
                                         'V300R001C30']
# 并联3DC配置检查通过版本
parallel_connected_3DC_pass_version = {
    'V300R001C20SPC200': 'V300R001C20SPH211',
    'V300R003C00SPC100': 'V300R003C00SPH110',
    'V300R003C10SPC100': 'V300R003C10SPH118',
    'V300R003C20SPC200': 'V300R003C20SPH213',
    'V300R005C00SPC300': 'V300R005C00SPH308',
    'V300R006C00SPC100': 'V300R006C00SPH111',
    'V500R007C00SPC100': 'V500R007C00SPH105',
    'V500R007C10': 'V500R007C10SPH005',
    'V300R001C01SPC100': 'V300R001C01SPH105',
    'V300R001C21SPC100': 'V300R001C21SPH107'
}

# 端口漂移白名单
HBA_WHITE_LIST = ['HBA:FV2.01A13 DV8.3.5.48.2p',
                  'HBA:HPAJ764A FW:v5.06.03 DVR:v8.03.07.07-k',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV8.3.5.48.2p',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV8.3.7.10.6p',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.3.7.10.6p',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV8.3.7.10.6p',
                  'HBA:QLE2562 FW:v5.08.00 DVR:v8.04.00.13.11.3-k',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.04.00.13.11.3-k',
                  'HBA:HPAJ764A FW:v5.08.00 DVR:v8.04.00.13.11.3-k',
                  'HBA:Emulex AJ763A/AH403A FV1.00A12 DV8.3.7.10.6p',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV8.3.7.10.6p',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.4.8000.0',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV10.4.8000.0.',
                  'HBA:QLE2562 FW:v8.00.00 DVR:v8.07.00.18-k',
                  'HBA:HPAJ764A FW:v8.00.00 DVR:v8.07.00.18-k',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.4.8000.0.',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.2.8040.1',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.2.8040.1',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV10.2.8040.1',
                  'HBA:QLE2562 FW:v7.03.00 DVR:v8.07.00.08.12.0-k',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.08.12.0-k',
                  'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.08.12.0-k',
                  'HBA:Emulex AJ763A/AH403A FV1.00A12 DV10.2.8040.1',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.2.8040.1',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.5.0.2 HN:linux-t6p1 OS:Linux',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.5.0.2 HN:linux-966q OS:Linux',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV10.5.0.2 HN:linux-5cq1 OS:Linux',
                  'HBA:QLE2562 FW:v7.03.00 DVR:v8.07.00.18-k',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.18-k',
                  'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.18-k',
                  'HBA:Emulex AJ763A/AH403A FV1.00A12 DV10.5.0.2 HN:linux-6r93 OS:Linux',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.5.0.2 HN:linux-6r93 OS:Linux',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.1.0.1. HN:linux OS:Linux',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.1.0.1. HN:linux OS:Linux',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.33-k',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV11.4.0.1. HN:linux. OS:Linux',
                  'HBA:HPAJ764A FW:v8.04.00 DVR:v8.07.00.33-k',
                  'HBA:SN1100Q FW:v8.05.61 DVR:v8.07.00.33-k',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.1.0.1. HN:linux OS:Linux',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV11.4.0.1. HN:linux. OS:Linux',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.4.0.1',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.4.0.1. HN:linux. OS:Linux',
                  'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.4.0.1.',
                  'HBA:Emulex AJ763A/AH403A FV1.00A12 DV11.4.0.1. HN:linux. OS:Linux',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.4.0.1. HN:linux. OS:Linux',
                  'HBA:Emulex LPe12002    FV2.01A11 DV8.3.5.86.1p',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.3.5.86.1p',
                  'HBA:QLE2562 FW:v5.08.00 DVR:v8.04.00.08.06.4-k',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.04.00.08.06.4-k',
                  'HBA:HPAJ764A FW:v5.08.00 DVR:v8.04.00.08.06.4-k',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV8.3.5.86.1p',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.3.7.21.4p',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.05.00.03.06.5-k2',
                  'HBA:HPAJ764A FW:v7.00.01 DVR:v8.05.00.03.06.5-k2',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV8.3.7.21.4p',
                  'HBA:Emulex LPe12002    FV2.01A11 DV10.2.8020.1',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.2.8020.1',
                  'HBA:QLE2562 FW:v7.03.00 DVR:v8.07.00.08.06.6-k1',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.08.06.6-k1',
                  'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.08.06.6-k1',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.2.8020.1',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.6.0.20',
                  'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.16.06.7-k',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.6.0.20 HN:(none) OS:Linux',
                  'HBA:Emulex LPe12002    FV2.01A11 DV11.0.0.4 HN:(none) OS:Linux',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.0.0.4',
                  'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.0.0.4',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
                  'HBA:QLE2692 FW:v8.03.04 DVR:v8.07.00.26.06.8-k',
                  'HBA:SN1100Q FW:v8.05.61 DVR:v8.07.00.26.06.8-k',
                  'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
                  'HBA:Emulex AJ763A/AH403A FV1.00A12 DV11.0.0.4 HN:(none) OS:Linux',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.0.0.4 HN:(none) OS:Linux',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.0.0.5',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
                  'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
                  'HBA:SN1100Q FW:v8.05.61 DVR:v8.07.00.26.06.8-k',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.0.0.5 HN:(none) OS:Linux',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV8.3.7.34.3p',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.3.7.34.3p',
                  'HBA:QLE2562 FW:v7.01.00 DVR:v8.06.00.08.07.0-k2',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.06.00.08.07.0-k2',
                  'HBA:HPAJ764A FW:v7.01.00 DVR:v8.06.00.08.07.0-k2',
                  'HBA:Emulex AJ763A/AH403A FV1.00A12 DV8.3.7.34.3p',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV8.3.7.34.3p',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.2.8021.1',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.2.8021.1',
                  'HBA:QLE2562 FW:v7.03.00 DVR:v8.07.00.08.07.1-k2',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.08.07.1-k2',
                  'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.08.07.1-k2',
                  'HBA:Emulex AJ763A/AH403A FV1.00A12 DV10.2.8021.1',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.2.8021.1',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.7.0.1 HN:localhost.localdomain OS:Linux',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.7.0.1',
                  'HBA:Emulex LPe16002B-M6 FV11.1.217.0 DV10.7.0.1 HN:localhost.localdomain OS:Linux',
                  'HBA:QLE2562 FW:v7.03.00 DVR:v8.07.00.18.07.2-k',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.18.07.2-k',
                  'HBA:HPAJ764A FW:v7.03.00 DVR:v8.07.00.18.07.2-k',
                  'HBA:Emulex AJ763A/AH403A FV1.00A12 DV10.7.0.1 HN:localhost.localdomain OS:Linux',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.7.0.1 HN:localhost.localdomain OS:Linux',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.1.0.2',
                  'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.1.0.2',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.33.07.3-k1',
                  'HBA:SN1100Q FW:v8.05.61 DVR:v8.07.00.33.07.3-k1',
                  'HBA:Emulex AJ763A/AH403A FV1.00A12 DV11.1.0.2 HN:localhost.localdomain OS:Linux',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.1.0.2 HN:localhost.localdomain OS:Linux',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV11.2.0.6 HN:localhost.localdomain OS:Linux',
                  'HBA:Emulex LPe12002    FV2.01A11 DV11.2.0.6 HN:localhost.localdomain OS:Linux',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.2.0.6',
                  'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.2.0.6',
                  'HBA:QLE2562 FW:v8.06.00 DVR:v8.07.00.38.07.4-k1',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.38.07.4-k1',
                  'HBA:HPAJ764A FW:v8.06.00 DVR:v8.07.00.38.07.4-k1',
                  'HBA:SN1100Q FW:v8.05.61 DVR:v8.07.00.38.07.4-k1',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.2.0.6 HN:localhost.localdomain OS:Linux',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.4.0.4.',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.4.0.4. HN:localhost.localdomain. OS:Linux',
                  'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.4.0.4',
                  'HBA:Emulex AJ763A/AH403A FV1.00A12 DV11.4.0.4',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.4.0.4',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.2.2.1-18vmw',
                  'HBA:QLE2562 FW:v5.06.05 DVR:v934.5.4.0-1vmw',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV8.2.3.1-127vmw',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.2.3.1-127vmw',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV8.2.3.1-127vmw',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.2.3.1-127vmw',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV8.2.3.1-127vmw',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.2.3.1-127vmw',
                  'HBA:Emulex AJ763A/AH403A FV1.00A12 DV8.2.3.1-127vmw',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV8.2.3.1-127vmw',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.0.100.1',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.0.100.1',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV10.0.100.1',
                  'HBA:QLE2562 FW:v5.09.00 DVR:v1.0.12.0',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v1.0.12.0',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.0.100.1',
                  'HBA:QLE2562 FW:v5.09.00 DVR:v1.0.12.0',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v1.0.12.0',
                  'HBA:HPAJ764A FW:v5.09.00 DVR:v1.0.12.0',
                  'HBA:Emulex AJ763A/AH403A FV1.00A12 DV10.0.100.1',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.0.100.1',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.2.309.8',
                  'HBA:Emulex LPe12002    FV2.01A11 DV10.2.309.8',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.2.309.8',
                  'HBA:QLE2562 FW:v7.02.00 DVR:v2.0.12.0',
                  'HBA:QLE2562 FW:v8.07.00 DVR:v2.1.73.0',
                  'HBA:QLE2692 FW:v8.03.04 DVR:v2.1.73.0',
                  'HBA:HPAJ764A FW:v7.02.00 DVR:v2.0.12.0',
                  'HBA:Emulex AJ763A/AH403A FV1.00A12 DV10.2.309.8',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.2.309.8',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.2.309.8',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV11.0.237.0 HN:localhost OS:VMware ESXi 6.0.0',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV11.2.266.0 HN:localhost OS:VMware ESXi 6.0.0',
                  'HBA:QLE2562 FW:v8.05.00 DVR:v2.1.65.0',
                  'HBA:Emulex AJ763A/AH403A FV1.00A12 DV10.2.309.8',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV10.2.309.8',
                  'HBA:Emulex LPe12002    FV2.01A11 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
                  'HBA:Emulex LPe16002B-M6 FV11.1.217.0 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
                  'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
                  'HBA:QLE2562 FW:v8.01.02 DVR:v2.1.30.0',
                  'HBA:QLE2562 FW:v8.07.00 DVR:v2.1.73.0',
                  'HBA:QLE2692 FW:v8.03.04 DVR:v2.1.73.0',
                  'HBA:Emulex LPe16002B-M6 FV11.1.217.0 DV11.4.33.1 HN:localhost OS:VMware ESXi 6.5.0',
                  'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.4.33.1',
                  'HBA:QLE2692 FW:v8.03.04 DVR:v2.1.50.0',
                  'HBA:SN1100Q FW:v8.05.61 DVR:v2.1.50.0',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.4.33.1 HN:localhost OS:VMware ESXi 6.5.0',
                  'HBA:Emulex LPe12002    FV2.01A11 DV11.4.33.1 HN:localhost OS:VMware ESXi 6.7.0',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.4.33.1',
                  'HBA:Emulex LPe16002B-M6 FV11.1.217.0 DV11.4.33.1 HN:localhost OS:VMware ESXi 6.7.0',
                  'HBA:QLE2562 FW:v8.05.00 DVR:v3.0.1.0',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v3.0.1.0',
                  'HBA:QLE2692 FW:v8.03.04 DVR:v3.0.1.0',
                  'HBA:SN1100Q FW:v8.05.61 DVR:v3.0.1.0',
                  'HBA:HPAJ764A FW:v8.05.00 DVR:v3.0.1.0',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.4.33.1',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV8.3.7.18',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.3.7.18',
                  'HBA:QLE2562 FW:v5.08.00 DVR:v8.04.00.13.11.3-k',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.04.00.13.11.3-k',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV8.3.7.18',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.6.133.8',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.6.133.8 HN:(none) OS:Linux',
                  'HBA:Emulex LPe12002    FV2.01A11 DV10.6.133.8 HN:(none) OS:Linux',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV10.6.133.8',
                  'HBA:QLE2562 FW:v5.08.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:Emulex 42D0494 FV1.11A5 DV8.3.18',
                  'HBA:QLE2562 FW:v5.03.02 DVR:v8.03.01.02.32.1-k9',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV11.0.0.13. HN:(none) OS:Linux',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.0.0.13.',
                  'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.0.0.13',
                  'HBA:QLE2692 FW:v8.03.04 DVR:v8.07.00.33.40.0-k',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.33.40.0-k',
                  'HBA:HPAJ764A FW:v8.02.00 DVR:v8.07.00.33.40.0-k',
                  'HBA:SN1100Q FW:v8.05.61 DVR:v8.07.00.33.40.0-k',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.0.0.13',
                  'HBA:Emulex LPe1250-F8 FV2.01A13 DV11.2.0.5',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV11.2.0.5.',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.2.0.5.',
                  'HBA:Emulex LPe31002-M6 FV11.2.156.27 DV11.2.0.5',
                  'HBA:QLE2562 FW:v8.07.00 DVR:v8.07.00.38.40.0-k',
                  'HBA:QLE2692 FW:v8.03.04 DVR:v8.07.00.38.40.0-k',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.38.40.0-k',
                  'HBA:HPAJ764A FW:v8.07.00 DVR:v8.07.00.38.40.0-k',
                  'HBA:SN1100Q FW:v8.05.61 DVR:v8.07.00.38.40.0-k',
                  'HBA:Emulex AJ763A/AH403A FV1.00A12 DV11.2.0.5',
                  'HBA:Emulex SN1100E2P FV10.2.340.19 DV11.2.0.5',
                  'HBA:QLE2560 FW:v5.06.05 DVR:v934.5.4.0-1vmw',
                  'HBA:QLE2670 FW:v8.00.00 DVR:v934.5.4.0-1vmw',
                  'HBA:QLE2560 FW:v5.06.05 DVR:v934.5.4.0-1vmw',
                  'HBA:QLE2670 FW:v8.00.00 DVR:v934.5.4.0-1vmw',
                  'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV8.2.3.1-127vmw',
                  'HBA:QLE2560 FW:v5.09.00 DVR:v1.0.12.0',
                  'HBA:QLE2670 FW:v8.00.00 DVR:v1.0.12.0',
                  'HBA:Emulex LPe12000-M8 FV2.02a0 DV10.0.100.1',
                  'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV10.0.100.1',
                  'HBA:QLE2560 FW:v7.02.00 DVR:v2.0.12.0',
                  'HBA:QLE2570 FW:v8.01.02 DVR:v2.0.12.0',
                  'HBA:Emulex LPe12000-M8 FV2.02A3 DV10.2.309.8',
                  'HBA:Emulex LPe16000B-M6 FV10.2.252.16 DV10.2.309.8',
                  'HBA:QLE2560 FW:v5.06.05 DVR:v902.k1.1-9vmw',
                  'HBA:QLE2570 FW:v8.01.02 DVR:v2.1.30.0',
                  'HBA:Emulex LPe12000-M8 FV2.02A3 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
                  'HBA:Emulex LPe16000B-M6 FV10.2.252.16 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
                  'HBA:QLE2560 FW:v8.02.00 DVR:v9.1.17.21',
                  'HBA:QLE2570 FW:v7.01.00 DVR:v9.1.17.21',
                  'HBA:Emulex LPe12000 FV2.01A11 DV10.0.720.0 WIN-6E87PLUAJ5M',
                  'HBA:QLE2560 FW:v8.05.00 DVR:v9.2.6.22',
                  'HBA:QLE2570 FW:v7.01.00 DVR:v9.2.6.22',
                  'HBA:Emulex LPe12000 FV2.01A11 DV11.2.139.0 HN:WIN-8NVH3NFPICQ OS:Windows2012',
                  'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV11.2.139.0',
                  'HBA:QLE2560 FW:v5.09.00 DVR:v9.1.11.3',
                  'HBA:QLE2570 FW:v7.01.00 DVR:v9.1.11.3',
                  'HBA:Emulex LPe12000    FV2.01A11 DV2.74.214.004 WIN-65TU9932AA2',
                  'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV2.74.214.004 WIN-65TU9932AA2',
                  'HBA:QLE2560 FW:v8.01.02 DVR:v9.1.15.1',
                  'HBA:QLE2570 FW:v7.01.00 DVR:v9.1.15.1',
                  'HBA:Emulex LPe12000 FV2.01A11 DV11.0.247.8000 HN:WIN-I52RHUC6JF2 OS:Windows2016',
                  'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV11.0.247.8000 HN:WIN-I52RHUC6JF2 OS:Windows2016',
                  'HBA:QLE2560 FW:v8.00.00 DVR:v8.07.00.18-k',
                  'HBA:QLE2570 FW:v8.00.00 DVR:v8.07.00.18-k',
                  'HBA:QLE2560 FW:v5.06.03 DVR:v8.03.07.07-k',
                  'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV8.3.5.48.2p',
                  'HBA:QLE2560 FW:v8.00.00 DVR:v8.07.00.18-k',
                  'HBA:QLE2570 FW:v8.01.02 DVR:v8.07.00.18-k',
                  'HBA:Emulex LPe12000-M8 FV2.01A10 DV10.4.8000.0.',
                  'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV10.4.8000.0.',
                  'HBA:QLE2560 FW:v7.03.00 DVR:v8.07.00.08.12.0-k',
                  'HBA:QLE2570 FW:v6.06.03 DVR:v8.07.00.08.12.0-k',
                  'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV10.2.8040.1',
                  'HBA:Emulex LPe12000-M8 FV2.01A10 DV11.4.0.1. HN:linux-n4sr. OS:Linux',
                  'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV11.4.0.1. HN:linux-n4sr. OS:Linux',
                  'HBA:QLE2560 FW:v8.07.00 DVR:v8.07.00.38.40.0-k',
                  'HBA:QLE2670 FW:v8.01.02 DVR:v8.07.00.38.40.0-k',
                  'HBA:Emulex LPe12000-M8 FV2.01A10 DV11.2.0.5. HN:localhost.localdomain OS:Linux',
                  'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV11.2.0.5. HN:localhost.localdomain OS:Linux',
                  'HBA:QLE2560 FW:v7.00.01 DVR:v8.05.00.03.06.5-k2',
                  'HBA:QLE2670 FW:v7.03.00 DVR:v8.05.00.03.06.5-k2',
                  'HBA:Emulex LPe12000-M8 FV2.02A1 DV8.3.7.21.4p',
                  'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV8.3.7.21.4p',
                  'HBA:QLE2560 FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
                  'HBA:QLE2670 FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
                  'HBA:Emulex LPe12000-M8 FV2.02A1 DV11.0.0.4 HN:(none) OS:Linux',
                  'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV11.0.0.4 HN:(none) OS:Linux',
                  'HBA:QLE2560 FW:v7.01.00 DVR:v8.06.00.08.07.0-k2',
                  'HBA:Emulex LPe12000-M8 FV2.02A1 DV8.3.7.34.3p',
                  'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV8.3.7.34.3p',
                  'HBA:QLE2560 FW:v8.01.02 DVR:v8.07.00.18.07.2-k',
                  'HBA:QLE2570 FW:v7.03.00 DVR:v8.07.00.18.07.2-k',
                  'HBA:Emulex LPe12000-M8 FV2.02A1 DV10.7.0.1 HN:localhost OS:Linux',
                  'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV10.7.0.1 HN:localhost OS:Linux',
                  'HBA:QLE2560 FW:v5.08.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:QLE2570 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:Emulex LPe12000-M8 FV2.02A0 DV10.6.133.8 HN:(none) OS:Linux',
                  'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV10.6.133.8 HN:(none) OS:Linux',
                  'HBA:QLE2560 FW:v5.08.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:QLE2570 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:Emulex LPe12000-M8 FV2.02A0 DV10.6.133.8 HN:(none) OS:Linux',
                  'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV10.6.133.8 HN:(none) OS:Linux',
                  'HBA:QLE2560 FW:v5.08.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:QLE2570 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:Emulex LPe12000-M8 FV2.02A0 DV8.3.7.18 HN:(none) OS:Linux',
                  'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV8.3.7.18 HN:(none) OS:Linux',
                  'HBA:QLE2560 FW:v8.02.00 DVR:v8.07.00.33.40.0-k',
                  'HBA:QLE2570 FW:v7.03.00 DVR:v8.07.00.33.40.0-k',
                  'HBA:Emulex LPe12000-M8 FV2.00A4 DV11.0.0.13. HN:(none) OS:Linux',
                  'HBA:Emulex LPe16000B-M6 FV11.2.156.27 DV11.0.0.13. HN:(none) OS:Linux',
                  'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV10.2.309.8',
                  'HBA:Emulex LPe12000    FV2.01A11 DV10.2.309.8',
                  'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV10.2.309.8',
                  'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV11.1.145.18',
                  'HBA:QLE2560 FW:v7.02.00 DVR:v2.0.12.0',
                  'HBA:QLE2560 FW:v7.03.00 DVR:v8.07.00.16.06.7-k',
                  'HBA:QLE2560 FW:v8.02.00 DVR:v2.1.50.0',
                  'HBA:QLE2560 FW:v8.03.00 DVR:v8.07.00.33.07.3-k1',
                  'HBA:QLE2562 FW:v5.06.05 DVR:v934.5.4.0-1vmw',
                  'HBA:QLE2672 FW:v8.00.00 DVR:v934.5.4.0-1vmw',
                  'HBA:QLE2562 FW:v5.06.05 DVR:v934.5.4.0-1vmw',
                  'HBA:QLE2672 FW:v8.00.00 DVR:v934.5.4.0-1vmw',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV8.2.3.1-127vmw',
                  'HBA:QLE2562 FW:v5.09.00 DVR:v1.0.12.0',
                  'HBA:QLE2672 FW:v8.00.00 DVR:v1.0.12.0',
                  'HBA:Emulex LPe12002-M8 FV2.02a0 DV10.0.100.1',
                  'HBA:Emulex 42D0494 FV2.01A12 DV10.0.100.1',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV10.0.100.1',
                  'HBA:QLE2562 FW:v7.02.00 DVR:v2.0.12.0',
                  'HBA:QLE2672 FW:v8.01.02 DVR:v2.0.12.0',
                  'HBA:Emulex LPe12002-M8 FV2.02A3 DV10.2.309.8',
                  'HBA:Emulex LPe16002B-M6 FV10.2.252.16 DV10.2.309.8',
                  'HBA:QLE2562 FW:v5.06.05 DVR:v902.k1.1-9vmw',
                  'HBA:QLE2672 FW:v8.01.02 DVR:v2.1.30.0',
                  'HBA:Emulex 42D0494 FV2.02A3 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
                  'HBA:Emulex LPe12002-M8 FV2.02A3 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
                  'HBA:Emulex 00E3495 FV10.2.252.16 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
                  'HBA:Emulex LPe16002B-M6 FV10.2.252.16 DV11.1.0.6 HN:localhost OS:VMware ESXi 6.5.0',
                  'HBA:QLE2562 FW:v8.02.00 DVR:v9.1.17.21',
                  'HBA:QLE2672 FW:v7.01.00 DVR:v9.1.17.21',
                  'HBA:Emulex LPe12002 FV2.01A11 DV10.0.720.0 WIN-6E87PLUAJ5M',
                  'HBA:QLE2562 FW:v8.05.00 DVR:v9.2.6.22',
                  'HBA:QLE2672 FW:v7.01.00 DVR:v9.2.6.22',
                  'HBA:Emulex LPe12002 FV2.01A11 DV11.2.139.0 HN:WIN-8NVH3NFPICQ OS:Windows2012',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.2.139.0',
                  'HBA:QLE2562 FW:v5.09.00 DVR:v9.1.11.3',
                  'HBA:QLE2672 FW:v7.01.00 DVR:v9.1.11.3',
                  'HBA:Emulex LPe12002    FV2.01A11 DV2.74.214.004 WIN-65TU9932AA2',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV2.74.214.004 WIN-65TU9932AA2',
                  'HBA:QLE2562 FW:v8.01.02 DVR:v9.1.15.1',
                  'HBA:QLE2672 FW:v7.01.00 DVR:v9.1.15.1',
                  'HBA:Emulex LPe12002 FV2.01A11 DV11.0.247.8000 HN:WIN-I52RHUC6JF2 OS:Windows2016',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.0.247.8000 HN:WIN-I52RHUC6JF2 OS:Windows2016',
                  'HBA:QLE2672 FW:v8.00.00 DVR:v8.07.00.18-k',
                  'HBA:QLE2672 FW:v8.00.00 DVR:v8.07.00.18-k',
                  'HBA:QLE2562 FW:v5.06.03 DVR:v8.03.07.07-k',
                  'HBA:Emulex 42D0494 FV1.11A5 DV8.3.5.48.2p',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV8.3.5.48.2p',
                  'HBA:QLE2562 FW:v8.00.00 DVR:v8.07.00.18-k',
                  'HBA:QLE2672 FW:v8.01.02 DVR:v8.07.00.18-k',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.4.8000.0.',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV10.4.8000.0.',
                  'HBA:QLE2562 FW:v7.03.00 DVR:v8.07.00.08.12.0-k',
                  'HBA:QLE2672 FW:v6.06.03 DVR:v8.07.00.08.12.0-k',
                  'HBA:Emulex 42D0494 FV1.11A5 DV10.2.8040.1',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV10.2.8040.1',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV11.4.0.1. HN:linux-n4sr. OS:Linux',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV11.4.0.1. HN:linux-n4sr. OS:Linux',
                  'HBA:QLE2562 FW:v8.07.00 DVR:v8.07.00.38.40.0-k',
                  'HBA:QLE2672 FW:v8.01.02 DVR:v8.07.00.38.40.0-k',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV11.2.0.5. HN:localhost.localdomain OS:Linux',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV11.2.0.5. HN:localhost.localdomain OS:Linux',
                  'HBA:QLE2562 FW:v7.00.01 DVR:v8.05.00.03.06.5-k2',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.05.00.03.06.5-k2',
                  'HBA:Emulex LPe12002-M8 FV2.02A1 DV8.3.7.21.4p',
                  'HBA:Emulex 42D0494 FV2.01A12 DV8.3.7.21.4p',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV8.3.7.21.4p',
                  'HBA:QLE2562 FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.26.06.8-k',
                  'HBA:Emulex LPe12002-M8 FV2.02A1 DV11.0.0.4 HN:(none) OS:Linux',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV11.0.0.4 HN:(none) OS:Linux',
                  'HBA:QLE2562 FW:v7.01.00 DVR:v8.06.00.08.07.0-k2',
                  'HBA:Emulex LPe12002-M8 FV2.02A1 DV8.3.7.34.3p',
                  'HBA:Emulex 42D0494 FV2.01A12 DV8.3.7.34.3p',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV8.3.7.34.3p',
                  'HBA:QLE2562 FW:v8.01.02 DVR:v8.07.00.18.07.2-k',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.18.07.2-k',
                  'HBA:Emulex LPe12002-M8 FV2.02A1 DV10.7.0.1 HN:localhost OS:Linux',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV10.7.0.1 HN:localhost OS:Linux',
                  'HBA:QLE2562 FW:v5.08.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:Emulex LPe12002-M8 FV2.02A0 DV10.6.133.8 HN:(none) OS:Linux',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV10.6.133.8 HN:(none) OS:Linux',
                  'HBA:QLE2562 FW:v5.08.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:Emulex LPe12002-M8 FV2.02A0 DV10.6.133.8 HN:(none) OS:Linux',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV10.6.133.8 HN:(none) OS:Linux',
                  'HBA:QLE2562 FW:v5.08.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.06.00.10.11.1-k',
                  'HBA:Emulex LPe12002-M8 FV2.02A0 DV8.3.7.18 HN:(none) OS:Linux',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV8.3.7.18 HN:(none) OS:Linux',
                  'HBA:QLE2562 FW:v8.02.00 DVR:v8.07.00.33.40.0-k',
                  'HBA:QLE2672 FW:v7.03.00 DVR:v8.07.00.33.40.0-k',
                  'HBA:Emulex LPe12002-M8 FV2.00A4 DV11.0.0.13. HN:(none) OS:Linux',
                  'HBA:Emulex LPe16002B-M6 FV11.2.156.27 DV11.0.0.13. HN:(none) OS:Linux',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV10.2.309.8',
                  'HBA:Emulex LPe12002    FV2.01A11 DV10.2.309.8',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV10.2.309.8',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.1.145.18',
                  'HBA:QLE2560 FW:v7.02.00 DVR:v2.0.12.0',
                  'HBA:QLE2560 FW:v7.03.00 DVR:v8.07.00.16.06.7-k',
                  'HBA:QLE2560 FW:v8.03.00 DVR:v8.07.00.33.07.3-k1',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV11.1.145.18',
                  'HBA:Emulex LPe12002-M8 FV2.01A10 DV10.2.8021.1',
                  'HBA:Emulex LPe12002    FV2.01A11 DV11.2.266.0',
                  'HBA:QLE2562 FW:v5.08.00  DVR:v8.04.00.13.11.3-k',
                  'HBA:QLE2672 FW:v7.01.00  DVR:v8.04.00.13.11.3-k',
                  'HBA:Emulex LPe12002-M8 FV2.01A11 DV8.3.7.10.6p',
                  'HBA:Emulex LPe16002B-M6 FV10.4.255.23 DV8.3.7.10.6p',
                  'HBA:Emulex 42D0494 FV2.01A12  DV8.2.2.1-18vmw',
                  'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV11.1.145.18',
                  'HBA:Emulex LPe12000-M8 FV2.01A10 DV10.2.8021.1',
                  'HBA:Emulex LPe12000    FV2.01A11 DV11.2.266.0',
                  'HBA:QLE2560 FW:v5.08.00 DVR:v8.04.00.13.11.3-k',
                  'HBA:QLE2670 FW:v7.01.00 DVR:v8.04.00.13.11.3-k',
                  'HBA:Emulex LPe12000-M8 FV2.01A11 DV8.3.7.10.6p',
                  'HBA:Emulex LPe16000B-M6 FV10.4.255.23 DV8.3.7.10.6p']

CHECK_FAILOVER_RISK_VERSION = {
    u'DORADO': [u'V300R001C00', u'V300R001C01', u'V300R001C20',
                u'V300R001C21', u'V300R001C30', u'V300R002C00'],
    u'VSERIES': [u'V300R006C00', u'V300R006C01', u'V300R006C10',
                 u'V300R006C20', u'V300R006C21', u'V500R007C00',
                 u'V500R007C10', u'V500R007C20']
}

# 双活两端版本及控制器一致性检查-互通版本配置规则
# 6U高端支持的互通型号
HYPER_MODEL_HIGH = ['18500 V3', '18800 V3', '6800 V3', '18500F V3',
                    '18800F V3', '6800F V3', '6800 V5',
                    '6800F V5', '18500 V5', '18500F V5', '18800 V5',
                    '18800F V5', '6810 V5', '6810F V5', '18510 V5',
                    '18510F V5', '18810 V5', '18810F V5',
                    '6800K V5', '18500K V5', '18800K V5']

# 中端产品支持的互通型号
HYPER_MODEL_MID = ['5600 V3', '5800 V3', '5500 V3', '5500F V3',
                   '5600F V3', '5800F V3', '5500 V5',
                   '5500F V5', '5600 V5', '5600F V5', '5800 V5',
                   '5800F V5', '5510 V5', '5510F V5', '5610 V5',
                   '5610F V5', '5810 V5', '5810F V5',
                   '5500K V5', '5600K V5', '5800K V5']

# 低端支持互通的型号
HYPER_MODEL_LOWER = ['2210', '2220', '2200 V5', '2600 V3', '5300 V3', '2600F V3', '5110 V5',
                     '5110F V5', '5210 V5', '5210F V5', '5300 V5',
                     '5300F V5', '2600 V3 Enhanced',
                     '2600F V3 Enhanced', '5300 V5 Enhanced',
                     '5310 V5', '5310F V5', '5100K V5', '5200K V5',
                     '2600 V5', '5110 V5 Enhanced', '5120 V5', '5110F V5 Enhanced',
                     '5210 V5 Enhanced', '5220 V5', '5210F V5 Enhanced', '2810 V5'
                     ]

# 双活两端版本及控制器一致性检查 支持互通的版本和型号配置
# 有明确版本和型号限制的配在general中，其他的配在special中
general_hyper_rule_list = [
    {
        "c_version": ["V300R006C50", "V500R007C30"],
        "model_rule_list": [HYPER_MODEL_HIGH, HYPER_MODEL_MID,
                            HYPER_MODEL_LOWER]
    },
    {
        "c_version": ["V300R006C60", "V500R007C50"],
        "model_rule_list": [HYPER_MODEL_HIGH, HYPER_MODEL_MID,
                            HYPER_MODEL_LOWER]
    },
    {
        "c_version": ["V500R007C60", "V500R007C60 Kunpeng"],
        "model_rule_list": [HYPER_MODEL_HIGH, HYPER_MODEL_MID,
                            HYPER_MODEL_LOWER]
    },
    {
        "c_version": ["V500R007C61", "V500R007C70 Kunpeng"],
        "model_rule_list": [HYPER_MODEL_HIGH, HYPER_MODEL_MID,
                            HYPER_MODEL_LOWER]
    },
    {
        "c_version": ["V500R007C71", "V500R007C71"],
        "model_rule_list": [HYPER_MODEL_HIGH, HYPER_MODEL_MID,
                            HYPER_MODEL_LOWER]
    },
    {
        "c_version": ["V500R007C72", "V500R007C72"],
        "model_rule_list": [HYPER_MODEL_HIGH, HYPER_MODEL_MID,
                            HYPER_MODEL_LOWER]
    },
    {
        "c_version": ["V500R007C73", "V500R007C73"],
        "model_rule_list": [HYPER_MODEL_HIGH, HYPER_MODEL_MID,
                            HYPER_MODEL_LOWER]
    },
]

# 双活两端版本及控制器一致性检查
# 其他版本部分特殊的型号支持互通的版本和型号配置
special_hyper_rule_list = [
    {
        # V3R2只有dorado才有双活.
        "c_version": ["V300R002"],
        "model_rule_list": [['Dorado5000 V3', 'Dorado6000 V3']]
    },
    {
        # 其他版本，不限制版本，则不需要配置版本。
        "c_version": [],
        "model_rule_list": [['18500 V3', '6800 V3']]
    },
]

# 一层分区dirty quota使用总量检查 ,版本范围
InvolvingVersions = ["V300R002C10", "V300R002C10SPC100", "V300R003C00", "V300R003C10", "V300R005C00", "V300R005C01",
                     "V300R003C20", "V300R003C20SPC100", "V300R006C00", "V300R006C10", "V300R006C01",
                     "V300R002C10SPC200", "V300R003C00SPC100", "V300R003C10SPC100", "V300R005C00SPC300",
                     "V300R003C20SPC200",
                     "V300R006C00SPC100", "V300R006C10SPC100", "V300R006C20"]
InvolvingDeviceTypes = ["2200 V3", "2600 V3", "2600 V3 for Video", "5300 V3", "5500 V3", "5600 V3", "5800 V3",
                        "6800 V3", "6900 V3", "18500 V3", "18500F V3", "18800F V3", "18800 V3", "6800F V3",
                        "5500F V3", "5600F V3", "5800F V3", "2600F V3"]

noPassVersionSetp5 = ["V300R002C10", "V300R002C10SPC100", "V300R003C00", "V300R003C10", "V300R005C00", "V300R005C01"]
needInstallPatchVersionSetp5 = {"V300R002C10SPC200": "V300R002C10SPH211",
                                "V300R003C00SPC100": "V300R003C00SPH110",
                                "V300R003C10SPC100": "V300R003C10SPH118",
                                "V300R005C00SPC300": "V300R005C00SPH308"
                                }
noPassVersionSetp6 = ["V300R003C20", "V300R003C20SPC100", "V300R006C00", "V300R006C10", "V300R006C01",
                      "V300R006C20SPC100"]
needInstallPatchVersionSetp6 = {"V300R003C20SPC200": "V300R003C20SPH213",
                                "V300R006C00SPC100": "V300R006C00SPH111",
                                "V300R006C10SPC100": "V300R006C10SPH105",
                                "V300R006C20": "V300R006C20SPH006"
                                }

# 	Odyssey硬盘检测 风险型号
RISK_PRODUCT_MODEL_ODYSSEY_DISK = ["18500 V3", "18500 V5", "18500F V3", "18500F V5", "18800 V3", "18800 V5",
                                   "18800F V3", "18800F V5", "6800 V5", "6800F V5"]

# NAS业务冗余链路风险检查,当前版本检查范围
NAS_REDUNTANT_LINK_VER = {"minCurrentVersion": "V300R003C10"}

# dorado v6 风险型号
NAS_REDUNTANT_LINK_MODEL_V6 = ['OceanStor Dorado 3000 V6',
                               'OceanStor Dorado 2000',
                               'OceanStor Dorado 2020',
                               'OceanStor Dorado 2100',
                               'OceanStor Dorado 5000 V6',
                               'OceanStor Dorado 5300 V6',
                               'OceanStor Dorado 5500 V6',
                               'OceanStor Dorado 5600 V6',
                               'OceanStor Dorado 6000 V6',
                               'OceanStor Dorado 6800 V6',
                               'OceanStor Dorado 8000 V6',
                               'OceanStor Dorado 18000 V6',
                               'OceanStor Dorado 18500 V6',
                               'OceanStor Dorado 18800 V6',
                               'OceanStor Dorado 18800K V6',
                               'OceanStor Dorado 3000',
                               'OceanStor Dorado 5000',
                               'OceanStor Dorado 5300',
                               'OceanStor Dorado 5500',
                               'OceanStor Dorado 5600',
                               'OceanStor Dorado 6000',
                               'OceanStor Dorado 6800',
                               'OceanStor Dorado 8000',
                               'OceanStor Dorado 18000',
                               'OceanStor Dorado 18500',
                               'OceanStor Dorado 18800',
                               'OceanStor Dorado 18800K',
                               "OceanStor 2910",
                               "OceanProtect X3000",
                               "OceanProtect X8000",
                               "OceanProtect E8000",
                               "OceanProtect X9000",
                               "OceanProtect X6000",
                               "OceanProtect X8000K",
                               "OceanProtect X9000K"]

# 证书名称对应type值（前面是证书名称，后面是type参数，名称需要转化成小写进行匹配）
CERT_TYPE_2_NAME_DICT = {'key management center': 'key_management_center',
                         'device management': 'device_management',
                         'domain authentication': 'domain_authentication',
                         'hypermetro arbitration': 'hypermetro_arbitration',
                         'https protocol': 'https_protocol',
                         'ftps protocol': 'ftps_protocol',
                         'syslog server authentication': 'syslog_authentication',
                         'ntp server authentication': 'ntp_authentication',
                         'call Home authentication': 'call_home_authentication',
                         'domain authentication extension 1': 'domain_authentication_extension_1',
                         'domain authentication extension 2': 'domain_authentication_extension_2',
                         'domain authentication extension 3': 'domain_authentication_extension_3',
                         'remote om link': 'remote_om_link',
                         'cloudbackup server authentication': 'cloud_backup_authentication',
                         'sso authentication': 'sso_authentication',
                         'container service authentication': 'smart_container_authentication',
                         'devicemanager authentication': 'devicemanager_authentication',
                         'virtual network computing (vnc) '
                         'server authentication for vms': 'vm_vnc_server_authentication',
                         'vm vnc-based client authentication': 'vm_vnc_client_authentication',
                         'email server authentication': 'email_authentication',
                         'otp email server authentication': 'OTP_email_authentication',
                         'file service domain authentication': 'file_service_domain_authentication',
                         'certificate authority authentication': 'certification_authority',
                         'in-band management': 'In-band_management'
                         }

# cache对象数量检查设计版本
DELETE_REMAIN_OBJ_CHECK_VERSION_HOTPATCH_DICT = {
    "V300R003C10SPC100": "V300R003C10SPH118",
    "V300R003C20SPC200": "V300R003C20SPH217",
    "V300R005C00SPC300": "V300R005C00SPH308",
    "V300R006C00SPC100": "V300R006C00SPH111",
    "V500R007C00SPC100": "V500R007C00SPH105",
    "V300R006C10SPC100": "V300R006C10SPH105",
    "V500R007C10": "V500R007C10SPH006",
    "V300R006C20": "V300R006C20SPH006",
    "V500R007C10SPC100": "V500R007C10SPH115",
    "V300R006C20SPC100": "V300R006C20SPH115",
}

# nfsv4 state id检查涉及版本及补丁
CHECK_NFSV4_STATE_ID_VERSION_HOTPATCH_DICT = {"V300R002C10": "",
                                              "V300R002C10SPC100": "",
                                              "V300R002C10SPC200": "V300R002C10SPH212",
                                              "V300R003C00": "",
                                              "V300R003C00SPC100": "V300R003C00SPH111",
                                              "V300R003C10": "",
                                              "V300R003C10SPC100": "V300R003C10SPH119",
                                              "V300R003C20": "",
                                              "V300R003C20SPC100": "",
                                              "V300R003C20SPC200": "V300R003C20SPH220",
                                              "V300R005C00": "",
                                              "V300R005C00SPC300": "",
                                              "V300R005C01": "",
                                              "V300R006C00": "",
                                              "V300R006C00SPC100": "V300R006C00SPH111",
                                              "V300R006C01": ""}
# nfsv4 state id检查涉及型号
CHECK_NFSV4_STATE_ID_PRODUCT_MODEL_LIST = ["2200 V3", "2600 V3", "5300 V3", "5500 V3", "5600 V3", "5800 V3", "6800 V3",
                                           "18500 V3", "18800 V3"]

CHECK_HYPER_ARB_LINK_WHITE_PRODUCT_LIST = ["V300R003C10SPC100",
                                           "V300R003C20",
                                           "V300R003C20SPC100",
                                           "V300R003C20SPC200",
                                           "V300R005C00",
                                           "V300R005C00SPC300",
                                           "V300R005C01",
                                           "V300R006C00",
                                           "V300R006C00SPC100",
                                           "V300R006C01",
                                           "V300R006C10",
                                           "V300R006C20",
                                           "V300R006C10SPC100",
                                           "V500R007C00",
                                           "V500R007C00SPC100",
                                           "V500R007C10",
                                           "V300R001C01",
                                           "V300R001C00SPC100",
                                           "V300R001C01SPC100",
                                           "V300R001C20",
                                           "V300R001C21",
                                           "V300R001C21SPC100",
                                           "V300R001C30"]
# Dorado 用户有效容量规格: 型号--控制器内存规格--VRC版本--对应的有效容量 已GB为单位，1TB=1000GB
CHECK_DEV_CAPACITY = {
    "Dorado3000 V3": {
        "96": {"V300R002C10": 500000, "V300R002C20": 500000}
    },
    "Dorado5000 V3": {
        "128": {"V300R001C00": 250000, "V300R001C01": 250000,
                "V300R001C20": 250000, "V300R001C21": 250000,
                "V300R001C30": 1000000, "V300R002C00": 1000000,
                "V300R002C10": 1000000, "V300R002C20": 1000000},
        "256": {"V300R001C01": 500000, "V300R001C20": 500000,
                "V300R001C21": 500000,
                "V300R001C30": 1000000, "V300R002C00": 1000000,
                "V300R002C10": 1000000, "V300R002C20": 1000000}
    },
    "Dorado6000 V3": {
        "256": {"V300R001C00": 500000, "V300R001C01": 500000,
                "V300R001C20": 500000, "V300R001C21": 500000,
                "V300R001C30": 2000000, "V300R002C00": 2000000,
                "V300R002C10": 2000000, "V300R002C20": 2000000},
        "512": {"V300R001C00": 1000000, "V300R001C01": 1000000,
                "V300R001C20": 1000000, "V300R001C21": 1000000,
                "V300R001C30": 2000000, "V300R002C00": 2000000,
                "V300R002C10": 2000000, "V300R002C20": 2000000},
        "1": {"V300R001C00": 1000000, "V300R001C01": 1000000,
              "V300R001C20": 1000000, "V300R001C21": 1000000,
              "V300R001C30": 2000000, "V300R002C00": 2000000,
              "V300R002C10": 2000000, "V300R002C20": 2000000}
    },
    "Dorado18000 V3": {
        "256": {"V300R001C30": 2000000, "V300R002C00": 2000000,
                "V300R002C10": 2000000, "V300R002C20": 2000000},
        "512": {"V300R001C30": 2000000, "V300R002C00": 2000000,
                "V300R002C10": 2000000, "V300R002C20": 2000000},
        "1": {"V300R001C30": 2000000, "V300R002C00": 2000000,
              "V300R002C10": 2000000, "V300R002C20": 2000000}
    }
}

CHECK_PRODUCT_VERSION = {
    "Dorado3000 V3": ["V300R002C10", "V300R002C20"],
    "Dorado5000 V3": ["V300R001C01", "V300R001C20", "V300R001C21",
                      "V300R001C30", "V300R002C00", "V300R002C10",
                      "V300R002C20"],
    "Dorado6000 V3": ["V300R001C00", "V300R001C01", "V300R001C20",
                      "V300R001C21", "V300R001C30", "V300R002C00",
                      "V300R002C10", "V300R002C20"],
    "Dorado18000 V3": ["V300R001C30", "V300R002C00", "V300R002C10",
                       "V300R002C20"]}

V5R7C70_SUPPORT_VM_MODEL = ["5310 V5", "5300K V5", "5300 V5", "2810 V5",
                            "5510 V5", "5500K V5", "5500 V5"]

HIGH_SHARE_CARD_MODEL = ['18500 V5', '18500F V5', '18510 V5',
                         '18510F V5', '18800 V5', '18800F V5',
                         '18810 V5', '18810F V5',  '6800 V5',
                         '6800F V5', '6810 V5', '6810F V5']

FAN_TEMPRETURE_RISK_MODE = ["OceanStor Dorado 6800 V6",
                            "OceanStor Dorado 8000 V6",
                            "OceanStor Dorado 18000 V6",
                            "OceanStor Dorado 18500 V6",
                            "OceanStor Dorado 18800 V6",
                            "OceanStor Dorado 18800K V6",
                            "OceanStor Dorado 6800",
                            "OceanStor Dorado 8000",
                            "OceanStor Dorado 18000",
                            "OceanStor Dorado 18500",
                            "OceanStor Dorado 18800",
                            "OceanStor Dorado 18800K",
                            "OceanProtect X9000"]

smartIO_hot_ver_dict = {'V300R006C20': 'V300R006C20SPH038',
                        'V500R007C10': 'V500R007C10SPH038',
                        'V300R006C50SPC100': 'V300R006C50SPH109',
                        'V500R007C30SPC100': 'V500R007C30SPH109'}
