# -*- coding: UTF-8 -*-
#扩容评估统计硬盘信息
import common
from com.huawei.ism.tool.inspect.entity import Disk as JDisk
from com.huawei.ism.tool.inspect.entity import Enclosure as JEnclosure
from com.huawei.ism.tool.inspect.entity import DiskDomain as JDiskDomain
from java.util import ArrayList as JavaList  #@UnresolvedImport #JavaList可用，故屏蔽PyDev报错; IGNORE:F0401 #PyLint中引用会报错，但实际可引用，故屏蔽
from cbb.frame.base.product import isDigitalVer
from cbb.frame.base.baseUtil import isDoradoV6Dev
from cliUtil import getHorizontalCliRet
from cliUtil import excuteCmdInCliMode


NO_CAPACITY_DESC = "Cannot get the capacity"

#扩容评估收集现网硬盘配置
class Statistic():
    def __init__(self,py_java_env, devObj, logger, curProgress, endProgress):
        self.py_java_env = py_java_env
        self.devObj = devObj
        self.logger = logger
        self.curProgress = curProgress
        self.endProgress = endProgress
        
    def execute(self):
        try:
            self.logger.logInfo("[statistic disk] The scene data is :%s"%self.py_java_env.get("sceneData"))
            ver = self.py_java_env.get("devInfo").getProductVersion()
            self.logger.logInfo("[statistic disk] The product version is :%s"%ver)
            # V3及以后版本才收硬盘配置
            # dorado v6的6.x.x等数字版本会被判定为<v3，所以再加上数字版本的判断。
            if not self.checkConfData(self.py_java_env.get("sceneData")) or \
                    (ver < "V3" and not isDigitalVer(ver)):
                self.logger.logInfo(
                    "[statistic disk] The tool is not in expansion scene "
                    "or ver < v3")
                return
            cli = self.devObj.get("ssh")
            lang = self.py_java_env.get("lang")
            enclosuresDisks, ddDisks, performance_layer_disks = self.getStatisticDisks(cli, lang)
            self.logger.logInfo("[statistic disk] enclosuresDisks:%s"%enclosuresDisks)
            self.logger.logInfo("[statistic disk] ddDisks:%s"%ddDisks)
            self.logger.logInfo("[statistic disk] performance_layer_disks:{}".format(performance_layer_disks))
            enclosuresDisks = sorted(enclosuresDisks.items(),key=lambda item:item[0])
            enclist = self.toJEnclosureList(enclosuresDisks)
            # 如果是dorado v6，因为对外没有硬盘域概念，需要将硬盘域id转换为存储池id
            # 界面上也将展示为存储池ID而不是硬盘域ID
            device_type = self.py_java_env.get("devInfo").getDeviceType()
            if isDoradoV6Dev(str(device_type)):
                ddDisks = self.transfer_key_dd_id_to_pool_id(
                    cli, lang, ddDisks)
                self.logger.logInfo("[statistic disk] ddDisks after transfer:%s" % ddDisks)

            dd_disks = [(dd_id, ddDisks.get(dd_id)) for dd_id in sorted(ddDisks.keys())]
            performance_disks = [(performance_layer_id, performance_layer_disks.get(performance_layer_id))
                                 for performance_layer_id in sorted(performance_layer_disks.keys())]
            dd_list = self.toJDDList(dd_disks)
            performance_list = self.toJDDList(performance_disks)
            self.devObj.put("statisticEncloureList", enclist)
            self.devObj.put("statisticDDList", dd_list)
            self.devObj.put("smartPoolDisks", performance_list)
            return
        except Exception as e:
            self.logger.logInfo("[statistic disk] statistic exception:%s"%e)
            return
        except:
            self.logger.logInfo("[statistic disk] statistic other exception.")
            return
        
    def checkConfData(self, data):
        if data != None and \
            "Expansion" == data.get("mainScene") and \
            "perInspector" == data.get("toolScene"):
            return True
        return False
    
    def toJEnclosureList(self,enclosuresDisks):
        enclosureList = JavaList()
        for enclosure in enclosuresDisks:
            encDict = {}
            enc = enclosure[-1]
            encDict["ID"] = enc.encId
            encDict["type"] = enc.encType
            
            jEnclosure = JEnclosure(enc.encId, enc.encType)
            disks = enc.getStatisticResult()
            self.logger.logInfo("toJEnclosureList disks: %s" % str(disks))
            if disks == {}:
                #补充没有硬盘的硬盘框
                jDisk = JDisk("--", "--", "0")
                jEnclosure.addDisk(jDisk)
            else:
                for key in disks:
                    diskType = key[0]
                    diskCapacity = key[1]
                    jDisk = JDisk(diskType, diskCapacity, str(disks.get(key)))
                    jEnclosure.addDisk(jDisk)
                
            enclosureList.add(jEnclosure)
        return enclosureList
    
    def toJDDList(self, ddDisks):
        ddList = JavaList()
        for d in ddDisks:
            dd = d[-1]
            jDiskDomain = JDiskDomain(dd.ddId)
            disks = dd.getStatisticResult()
            for key in disks:
                diskType = key[0]
                diskCapacity = key[1]
                jDisk = JDisk(diskType, diskCapacity, str(disks.get(key)))
                jDiskDomain.addDisk(jDisk)
                
            ddList.add(jDiskDomain)
        return ddList
    
    def getStatisticDisks(self, cli, lang):
        '''
        @summary: 按照硬盘框和硬盘域统计硬盘信息
        '''
        enclosuresDisks = {}
        ddDisks = {}
        performance_layer_disks = dict()
        totalProgress = self.endProgress - self.curProgress
        flag, disksInfo, __=common.getDiskInfoList(cli, lang)
        self.curProgress = self.curProgress + totalProgress * 1.0/10
        common.refreshProcess(self.py_java_env, self.curProgress , self.logger)
        if not flag or not disksInfo:
            self.logger.logInfo("[statistic disk] failed to get disk info.")
            return enclosuresDisks,ddDisks, performance_layer_disks
        
        #获取框信息
        enclosuresInfo = common.getEncTypeInfo(cli, lang)
        self.logger.logInfo("[statistic disk] get enclosure result:%s" %enclosuresInfo)
        self.curProgress = self.curProgress + totalProgress * 0.5/10
        common.refreshProcess(self.py_java_env, self.curProgress, self.logger)
        
        totalProgress = self.endProgress - self.curProgress
        perProgress = totalProgress * 1.0 / len(disksInfo)
        for diskInfo in disksInfo:
            diskId = diskInfo.get("ID")
            diskType = diskInfo.get("Type")
            
            #获取容量
            result, capacity, __ = common.getDiskCapacityByDiskId(cli, diskId, lang, isOrigin=True, isHasLog=False)
            self.curProgress = self.curProgress + perProgress
            common.refreshProcess(self.py_java_env, self.curProgress, self.logger)
            if not result:
                capacity = NO_CAPACITY_DESC
            
            disk = Disk(diskId, diskType, capacity)
            
            #归属到控制框/硬盘框
            encId = diskId.split(".")[0]
            encType = enclosuresInfo.get(encId,"--")
            enclosure = enclosuresDisks.get(encId,Enclosure(encId, encType))
            enclosure.addDisk(disk)
            enclosuresDisks[encId] = enclosure
            
            #归属到硬盘域
            ddId = diskInfo.get("Disk Domain ID")
            performance_layer_id = diskInfo.get("Performance Layer ID")
            #无硬盘域跳过
            if ddId == "--" and (performance_layer_id == "--" or not performance_layer_id):
                continue
            if performance_layer_id and performance_layer_id != "--":
                disk_domain = performance_layer_disks.get(performance_layer_id, Disk_Domain(performance_layer_id))
                disk_domain.addDisk(disk)
                performance_layer_disks[performance_layer_id] = disk_domain
            else:
                disk_domain = ddDisks.get(ddId, Disk_Domain(ddId))
                disk_domain.addDisk(disk)
                ddDisks[ddId] = disk_domain

        #补充没有硬盘的硬盘框
        for diskEnclosureId in enclosuresInfo.keys():
            if diskEnclosureId in enclosuresDisks:
                continue

            if "DAE" in diskEnclosureId:
                diskEnclosureType = enclosuresInfo.get(diskEnclosureId, "--")
                diskEnclosure = Enclosure(diskEnclosureId, diskEnclosureType)
                enclosuresDisks[diskEnclosureId] = diskEnclosure
        
        return enclosuresDisks, ddDisks, performance_layer_disks

    @staticmethod
    def get_dd_and_pool_id_map(cli, lang):
        """
        获取存储池和硬盘域的id对应关系
        :param cli:
        :param lang:
        :return: flag, cli_ret, err_msg, {"domain_id": "pool_id"}
        """
        cmd = r"show storage_pool general|filterColumn include " \
              r"columnList=ID,Disk\sDomain\sID"
        flag, cli_ret, _ = excuteCmdInCliMode(
            cli, cmd, True, lang)
        if flag is not True:
            return {}

        cli_ret_line = getHorizontalCliRet(cli_ret)
        id_map = {}
        for pool_info in cli_ret_line:
            pool_id = pool_info.get("ID")
            domain_id = pool_info.get("Disk Domain ID")
            if domain_id:
                id_map[domain_id] = pool_id
        return id_map

    @staticmethod
    def transfer_key_dd_id_to_pool_id(cli, lang, dd_disk):
        """
        将硬盘域id转换为存储池id(for dorado v6)
        只展示被关联存储池的硬盘数据，如果硬盘域id没有在show storage pool结果中，则不用展示
        :return:
        """
        ip_map = Statistic.get_dd_and_pool_id_map(cli, lang)
        sp_disk = {}
        for dd_id in dd_disk:
            pool_id = ip_map.get(dd_id, None)
            if pool_id:
                dd_disk[dd_id].ddId = pool_id
                sp_disk[pool_id] = dd_disk[dd_id]
        # 空池场景
        empty_pool_ids = [pool_id for dd_id, pool_id in ip_map.items() if dd_id not in dd_disk.keys()]
        for empty_pool_id in empty_pool_ids:
            disk_domain = Disk_Domain(empty_pool_id)
            sp_disk[empty_pool_id] = disk_domain

        return sp_disk


class Disk():
    def __init__(self, diskId, diskType, diskCapacity):
        self.diskId = diskId
        self.diskType = diskType
        self.diskCapacity = diskCapacity
    
    
class Object():
    def __init__(self):
        self.disks = []
        
    def addDisk(self,disk):
        if disk not in self.disks:
            self.disks.append(disk)
            return
        return
    
    def getStatisticResult(self):
        '''
        @summary: 统计同类型
        '''
        result = {}
        for disk in self.disks:
            diskType = disk.diskType
            diskCapacity = disk.diskCapacity
            key = (diskType, diskCapacity)
            result[key] = result.get(key,0) + 1
        
        return result
            
    
class Enclosure(Object):
    '''
    按照硬盘框统计硬盘
    '''
    def __init__(self,encId,encType):
        self.encId = encId
        self.encType = encType
        self.disks = []

class Disk_Domain(Object):
    '''
    按照硬盘域统计硬盘
    '''
    def __init__(self,ddId):
        self.ddId = ddId    #非成员盘dd为--
        self.disks = []
