# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        紧急级别告警检查： 
                如果不存在Level为Critical的告警属于正常，否则属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show alarm level=critical number=10"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        #正常告警回显Name中可能包含is not supported，造成公共方法误报不涉及
        #加入"----"关键字识别，若包含该分隔符，则认为正常回显，消除不支持虚拟机误报
        if checkRet[0] != True and "----" not in checkRet[1]:
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        flag = False
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.alarm.info")
            LOGGER.logNoPass("Cannot get information about alarm")
        else:
            errMsg = common.getMsg(LANG, "system.exists.critical.alarm")
            LOGGER.logNoPass("System exists critical alarm")
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
