# -*- coding: UTF-8 -*-
import cliUtil
import common
import datetime, time

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    """
    Create date        : 2016/10/13
    Function name      : execute(cliConnection)
    Function describe  : execute repeated recovered Critical or Major alarm.
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    allCliRet = ""
    alarmCliRet = ""
    errMsg = ""
    #记录检查开始时间
    startTime = time.time()
    
    try:
        isSucc, sysDate, cliRet = common.getCurSysDate(cli)
        allCliRet += cliRet
        if not isSucc:
            errMsg = common.getMsg(LANG, "query.system.date.abnormal")
            LOGGER.logNoPass("get system date abnormal.")
            return (False, allCliRet, errMsg)
        
        year, month, day =  map(int, sysDate.split('-'))
        lastMonth = datetime.date(year, month, day) - datetime.timedelta(30) 
        
        # 获取最近30天内的紧急告警信息    
        cmd = "show event level=critical from_time=%s/00:00:00" % lastMonth.strftime('%Y-%m-%d')
        isSucc, criticalAlarmCliRet, errMsg = cliUtil.excuteCmdTimeOutInCliMode(cli, cmd, True, LANG, 5*60)
        allCliRet += criticalAlarmCliRet
        
        # 因数据量大，5min（用户可接受的时间）内未完成查询时不再做检查
        if "TOOLKIT_SEND_CMD_TIME_OUT" in criticalAlarmCliRet or isTimeOut(startTime):
            errMsg = common.getMsg(LANG, "get.event.timeout")
            return ("NOCHECK", allCliRet, errMsg)
        #正常告警回显Name中可能包含is not supported，造成公共方法误报不涉及
        #加入"----"关键字识别，若包含该分隔符，则认为正常回显，消除不支持虚拟机误报
        if not isSucc and "----" not in criticalAlarmCliRet:
            LOGGER.logSysAbnormal()
            return (False, allCliRet, errMsg)
        errMsg = ""
        # 获取最近30天内的重要告警信息
        cmd = "show event level=major from_time=%s/00:00:00" % lastMonth.strftime('%Y-%m-%d')
        isSucc, majorAlarmCliRet, errMsg = cliUtil.excuteCmdTimeOutInCliMode(cli, cmd, True, LANG, 5*60)
        allCliRet += majorAlarmCliRet
        
        # 因数据量大，5min（用户可接受的时间）内未完成查询时不再做检查
        if "TOOLKIT_SEND_CMD_TIME_OUT" in majorAlarmCliRet or isTimeOut(startTime):
            errMsg = common.getMsg(LANG, "get.event.timeout")
            return ("NOCHECK", allCliRet, errMsg)
        #正常告警回显Name中可能包含is not supported，造成公共方法误报不涉及
        #加入"----"关键字识别，若包含该分隔符，则认为正常回显，消除不支持虚拟机误报
        if not isSucc and "----" not in majorAlarmCliRet:
            LOGGER.logSysAbnormal()
            return (False, allCliRet, errMsg)
        errMsg = ""
        #最近30天设备未产生重要及紧急告警
        if cliUtil.queryResultWithNoRecord(criticalAlarmCliRet) and cliUtil.queryResultWithNoRecord(majorAlarmCliRet):
            return (True, allCliRet, errMsg)
        
        alarmCliRet = criticalAlarmCliRet + majorAlarmCliRet
        
        alarmDict = {}
        for line in alarmCliRet.splitlines():
            if isTimeOut(startTime):
                errMsg = common.getMsg(LANG, "get.event.timeout")
                return ("NOCHECK", allCliRet, errMsg)
            
            itemList = line.split()
            if len(itemList) < 1:
                continue
            
            alarmSequence = itemList[0].strip()
            if alarmSequence.isdigit():
                alarmDetail, detailCliRet = common.qryEventDetail(cli, alarmSequence)
                alarmLineList = alarmDict.get(alarmDetail, [])
                alarmLineList.append(line.strip())
                alarmDict[alarmDetail] = alarmLineList
                allCliRet += detailCliRet
        
        for alarmDetail in alarmDict:
            alarmLineList = alarmDict.get(alarmDetail)
            alarmOccurTimes = len(alarmLineList)
            alarmLevel = alarmLineList[0].split()[1]
            
            if alarmLevel == "Major":
                if alarmOccurTimes == 3:
                    errMsg += common.getMsg(LANG, "alarm.3times.repeat.Occur", (alarmOccurTimes, "\n".join(alarmLineList)))
                if alarmOccurTimes > 3:
                    errMsg += common.getMsg(LANG, "alarm.than3times.repeat.Occur", (alarmOccurTimes, 3, "\n".join(alarmLineList[0:3])))
            
            if alarmLevel == "Critical":
                if alarmOccurTimes == 2:
                    errMsg += common.getMsg(LANG, "alarm.3times.repeat.Occur", (alarmOccurTimes, "\n".join(alarmLineList)))
                if alarmOccurTimes > 2:
                    errMsg += common.getMsg(LANG, "alarm.than3times.repeat.Occur", (alarmOccurTimes, 2, "\n".join(alarmLineList[0:2])))
                    
        if errMsg:
            LOGGER.logNoPass("System exists repeat alarm")
            return ('WARNING', allCliRet, errMsg)
        else:
            return (True, allCliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
    
    
def isTimeOut(startTime):
    '''
    @summary: 检查项是否执行超过5min
    '''
    if (time.time() - startTime) > 5 * 60:
        return True
    
    return False
    
