# -*- coding: UTF-8 -*-
import common
import cliUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def countchar(s):
    s=s.upper()
    cnt = 0
    for c in s:
        if  ord("A")<=ord(c)<=ord("Z") or " " == c:
            cnt +=1
        else:
            continue
    return cnt

def execute(cli):
    try:
        passRate = py_java_env.get("manualChkPassRate")
        manualChkItems = py_java_env.get("manualChkItems")
        manualChkRs = py_java_env.get("manualChkRs")
        cliRet = ""
        LOGGER.logNoPass("passRate:%s" % passRate)
        
        if manualChkItems and manualChkRs and len(manualChkItems) == len(manualChkRs):
            ljsutMaxLen = len(max(manualChkItems, key=len))
            if "zh" == LANG:
                cliRet += u"%s  %s\n" % (u"检查项".ljust(ljsutMaxLen,u"　"), u"检查结果")
            else:
                cliRet += "%s  %s\n" % ("Check Item".ljust(ljsutMaxLen), "Check Result")
            for i in xrange(0, len(manualChkItems)):
                itemName = manualChkItems[i]
                itemRs = manualChkRs[i]
                if "zh" == LANG:
                    if not itemRs:
                        itemRs = u"未检查"
                    #中文场景补齐字符串中中英文混杂时部分
                    cliRet += "%s  %s\n" % (itemName.ljust(ljsutMaxLen,u"　") + int(countchar(itemName) / 2) * u"　", itemRs)
                else:
                    if not itemRs:
                        itemRs = "Not Checked"
                    cliRet += "%s  %s\n" % (itemName.ljust(ljsutMaxLen), itemRs)
        
        if "100%" == passRate:
            return (True, cliRet, "")
        
        errMsg = "Pass ratio is %s" % passRate
        if "zh" == LANG:
            errMsg = u"人工检查通过率为：%s" % passRate
        return (False, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
