# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    allCliRet = ""
    errMsg = ""
    allErrHostIdList = []

    try:
        flag, cliRet, errMsg, hostInfo = cliUtil.getHostDict(cli, LANG)
        allCliRet += cliRet
        if flag == cliUtil.RESULT_NOCHECK:
            return (flag, allCliRet, errMsg)
        
        #无主机直接通过
        if not hostInfo:
            return (True, allCliRet, errMsg)
        
        #获取主机ID
        hostIdList = hostInfo.keys()
        hostIdList.sort()
        
        #检查FC启动器
        cliRet, errAluaInitList, errHostIdList = getErrInitiatorInfo(cli, "FC", hostIdList)
        allCliRet += cliRet
        #查询异常未检查
        if errAluaInitList is None:
            return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "alua.host.error"))
        
        #存在ALUA直接不通过
        if errAluaInitList:
            errMsg = common.getMsg(LANG,"alua.exist.alua.multipathType")
            return (False, allCliRet, errMsg)
        #保存需要确认的主机
        allErrHostIdList.extend(errHostIdList)
        
        #检查ISCSI启动器
        cliRet, errAluaInitList, errHostIdList = getErrInitiatorInfo(cli, "iSCSI", hostIdList)
        allCliRet += cliRet
        if errAluaInitList is None:
            return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
        
        if errAluaInitList:
            errMsg = common.getMsg(LANG,"alua.exist.alua.multipathType")
            return (False, allCliRet, errMsg)
        allErrHostIdList.extend(errHostIdList)
        
        #检查IB启动器
        cliRet, errAluaInitList, errHostIdList = getErrInitIBInfo(cli, hostIdList)
        allCliRet += cliRet
        if errAluaInitList is None:
            return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
        
        if errAluaInitList:
            errMsg = common.getMsg(LANG,"alua.exist.alua.multipathType")
            return (False, allCliRet, errMsg)
        
        #刷新待确认的主机信息
        allErrHostIdList.extend(errHostIdList)
        if allErrHostIdList:
            errMsg = getHostErrMsg(allErrHostIdList, hostInfo)
            return (False, allCliRet, errMsg)
        
        return (True, allCliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (False, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

def getHostErrMsg(errHostIdList, hostInfo):
    errHostIdSet = set(errHostIdList)
    hostList = sorted(errHostIdSet, cmp=None, key=None, reverse=False)
    errMsg = common.getMsg(LANG, "alua.host.error.config")
    for hostId in hostList:
        host = hostInfo.get(hostId)
        OperatingSystem = host.get("Operating System")
        errMsg += common.getMsg(LANG, "alua.host.info",(hostId,OperatingSystem))
        
    return errMsg
    
def getErrAluaInfo(initInfoList):
    
    errThirdPartyList = []
    errAluaInitList = []
    
    for info in initInfoList:
        multipathType = info.get("Multipath Type",info.get("Multi Path Type"))
        
        if "Default" == multipathType:
            continue
        
        #同一个版本ALUA和Third-Party只会存在一种
        if "ALUA" == multipathType:
            errAluaInitList.append(info.get("WWN",info.get("iSCSI IQN")))
            return (errThirdPartyList, errAluaInitList)
        
        failoverMode = info.get("Failover Mode")
        if "Third-party" == multipathType and "No ALUA" != failoverMode:
            errThirdPartyList.append(info.get("WWN",info.get("iSCSI IQN")))
            continue
        
    return (errThirdPartyList, errAluaInitList)

def getErrInitiatorInfo(cli, initType, hostIdList):
    '''
    @summary: 检查FC/iSCSI启动器是否满足ALUA要求
    '''
    cliRet = ""
    errHostIdList = []
    errAluaInitList = []
    
    for hostId in hostIdList:
    
        cmd = "show initiator initiator_type=%s host_id=%s" %(initType,hostId)
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet += checkRet[1] 
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (cliRet, None, None)
        
        if cliUtil.queryResultWithNoRecord(checkRet[1]):
            continue
    
        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        errThirdPartyList, errAluaInitList = getErrAluaInfo(cliRetLinesList)
        
        #存在ALUA直接返回不通过
        if errAluaInitList:
            return (cliRet, errAluaInitList, errHostIdList)
        
        #获取手动检查的主机
        if errThirdPartyList:
            errHostIdList.append(hostId)
            continue
        
    return (cliRet, errAluaInitList, errHostIdList)

def getErrInitIBInfo(cli, hostIdList):

    '''
    @summary: 检查IB启动器是否满足ALUA要求
    '''
    cliRet = ""
    errHostIdList = []
    errAluaInitList = []
    for hostId in hostIdList:
        cmd = "show ib_initiator general host_id=%s" %hostId
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet += checkRet[1] 

        if not cliUtil.hasCliExecPrivilege(checkRet[1]):
            break

        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (cliRet, None, None)
                
        if cliUtil.queryResultWithNoRecord(checkRet[1]):
            continue
    
        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        errThirdPartyList, errAluaInitList = getErrAluaInfo(cliRetLinesList)
        #存在ALUA直接返回不通过
        if errAluaInitList:
            return (cliRet, errAluaInitList, errHostIdList)
        
        #获取手动检查的主机
        if errThirdPartyList:
            errHostIdList.append(hostId)
            continue
        
    return (cliRet, errAluaInitList, errHostIdList)

    