# -*- coding: UTF-8 -*-
import common
import cliUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    @summary: 检查当前设备型号和版本号，且是否包含4K盘
    '''
    
    cliRet = ""
    errMsg = ""
    
    #定义风险型号和版本号
    bugProduct_V3 = ("5300 V3", "5500 V3", "5600 V3", "5800 V3", "6800 V3")
    bugVersion_V3 = ("V300R002C00", "V300R002C00SPC100")
    
    #查询产品型号
    result, productModel, cliRet, errMsg = cliUtil.getProductModelWithCliRet(cli, LANG)
    if not result:
        return (False, cliRet, errMsg)
    if productModel not in bugProduct_V3:
        return (cliUtil.RESULT_NOSUPPORT, cliRet, "")
    
    #获取版本号，并判断是否为风险版本
    resultList, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
    cliRet += resultList[1]
    if resultList[0] != True:
        return (resultList[0], cliRet, resultList[2])
    
    result, currentVersion, errInfo = common.getCurrentVersion(currentVersionDictList, LANG)
    if not result:
        errMsg += errInfo
        return (False, cliRet, errMsg)

    if currentVersion not in bugVersion_V3:
        return (True, cliRet, errMsg)
    
    #查询是否存在4K盘
    result, cmdRet, errInfo, diskSectorSizeDictList = common.getDiskSectorSize(cli, LANG)
    cliRet += cmdRet
    errMsg += errInfo
    if not result:
        return (result, cliRet, errMsg)
    
    result, is4KDiskIdList, errInfo = common.is4KDiskWithSectorSize(diskSectorSizeDictList,LANG)
    errMsg += errInfo

    return (result, cliRet, errMsg)
