# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    BBU状态检查：
                所有BBU均在位，Health Status为Normal且Running Status为Online、Charging或Discharging表示正常，其它情况均属于不正常状态。
    '''
    flag = True
    #是否上报告警
    warningFlag = False
    cliRet = ""
    cliRetAll = ""
    errMsg = ""

    try:
        cmd = "show bbu general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        cliRetAll = cliRet
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.bbu.info")
            LOGGER.logNoPass("Cannot get information about BBU")
            return (False, cliRet, errMsg)
        
        bbuEngineIdList = []
        for line in cliRetLinesList:
            bbuId = line.get("ID")
            bbuEngineIdList.append(bbuId.split(".")[0][-1])
            bbuHealthStatus = line.get("Health Status")
            bbuRunningStatus = line.get("Running Status")
                        
            if bbuHealthStatus != common.STATUS_NORMAL:
                if bbuHealthStatus == common.STATUS_LOW_BATTERY:
                    warningFlag = True
                    errMsg += common.getMsg(LANG, "bbu.health.status.lowbattery", bbuId)
                    LOGGER.logWarning("The Health Status of BBU [%s] is %s" % (bbuId, bbuHealthStatus))
                else:
                    flag = False
                    errMsg += common.getMsg(LANG, "bbu.health.status.abnormal", (bbuId, bbuHealthStatus))
                    LOGGER.logNoPass("The Health Status of BBU [%s] is abnormal (Health Status:%s)" % (bbuId, bbuHealthStatus))
            
            if bbuRunningStatus not in [common.STATUS_ONLINE, common.STATUS_CHARGING, common.STATUS_DISCHARGING]:
                flag = False
                errMsg += common.getMsg(LANG, "bbu.running.status.abnormal", (bbuId, bbuRunningStatus))
                LOGGER.logNoPass("The Running Status of BBU [%s] is abnormal (Running Status:%s)" % (bbuId, bbuRunningStatus))
        
        #需要上报告警且检查结果不为不通过时上报告警
        if flag == True and warningFlag == True:
            flag = cliUtil.RESULT_WARNING 
        
        bbuConfigRet = common.getBBUConfig(cli, LANG)
        if bbuConfigRet[0] != True:
            cliRetAll += bbuConfigRet[1]
            errMsg += bbuConfigRet[2]
            LOGGER.logNoPass("Cannot get information about BBU configuration")
            return (bbuConfigRet[0], cliRetAll, errMsg)
        standardBbuNumOfEngine = bbuConfigRet[1]
        
        getControllerIdCheckRet = cliUtil.getControllerIdList(cli, LANG)
        if getControllerIdCheckRet[0] != True:
            cliRetAll += getControllerIdCheckRet[1]
            errMsg += getControllerIdCheckRet[2]
            LOGGER.logNoPass("Cannot get information about controllers")
            return (getControllerIdCheckRet[0], cliRetAll, errMsg)
        controllerIdList = getControllerIdCheckRet[1]
        
        engineIdList = [controllerId[0] for controllerId in controllerIdList]
        engineIdSet = set(engineIdList)
        
        for engineId in engineIdSet:
            currentBbuNumofEngine = bbuEngineIdList.count(engineId)
            if currentBbuNumofEngine < standardBbuNumOfEngine:
                flag = False
                errMsg += common.getMsg(LANG, "bbu.number.not.enough", (engineId, standardBbuNumOfEngine, currentBbuNumofEngine))
                LOGGER.logNoPass("The number of BBU on engine [%s] is not enough (Required Number:%s, Current Number:%s)" 
                     % (engineId, standardBbuNumOfEngine, currentBbuNumofEngine))
                
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRetAll, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
