# -*- coding: UTF-8 -*-
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    PCIe端口误码：
                如果PCIe端口存在持续增加的误码表示不正常，其它情况均属于正常状态。
    '''
    cliRet = ""
    ports = ["PCIe"]
    
    try:
        cmd = "show port bit_error"
        LOGGER.logExecCmd(cmd)
        checkPortsBitErrorRet = common.checkPortsBitError(cli, cmd, ports, LANG)
        cliRet = checkPortsBitErrorRet[1]
        if checkPortsBitErrorRet[0] != True:
            LOGGER.logNoPass("PCIe ports has continuous bit errors:\n" + cliRet)
        else:
            LOGGER.logPass()
        return checkPortsBitErrorRet

    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
