# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
         引擎状态检查：
                 所有控制器均在线，Health Status为Normal且Running Status为Online表示正常，其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = r"show controller general|filterColumn include columnList=Controller,Health\sStatus,Running\sStatus"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.controller.info")
            LOGGER.logNoPass("Cannot get information about controller")
            return (False, cliRet, errMsg)
        
        engineList = []
        engineSlotDict = {}
        for retDict in cliRetLinesList:
            ctrlId = retDict.get("Controller").strip()
            healthStatus = retDict.get("Health Status")
            runningStatus = retDict.get("Running Status")
            
            engineId = ctrlId[:-1]
            slot = ctrlId[-1]
            engineList.append(engineId)
            
            if engineSlotDict.has_key(engineId):
                slots = engineSlotDict.get(engineId).append(slot)
                engineSlotDict.setdefault(engineId, slots)
            else:
                engineSlotDict.setdefault(engineId, [slot])
                
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "controller.health.status.abnormal", (ctrlId, healthStatus))
                LOGGER.logNoPass("The Health Status of Controller [%s] is abnormal (Health Status:%s)"  % (ctrlId, healthStatus))
            
            if runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "controller.running.status.abnormal", (ctrlId, runningStatus))
                LOGGER.logNoPass("The Running Status of Controller [%s] is abnormal (Running Status:%s)" % (ctrlId, runningStatus))
        
        for engine in set(engineList):
            slots = engineSlotDict.get(engine)
            controllerId = ", ".join([(engine + slot) for slot in slots])
            if slots not in (["A", "B"], ["A", "B", "C", "D"]):
                flag = False
                errMsg += common.getMsg(LANG, "engine.may.be.offline", engine)
                LOGGER.logNoPass("The controller in the engine [%s] may be offline (%s)" % (engine, controllerId))
                
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
