# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        硬盘链路状态检查：
                如果不存在相应的记录表示正常，否则表示存在单链路的硬盘。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show disk general|filterColumn include columnList=Multipathing,ID|filterRow column=Multipathing predict=equal_to value=A logicOp=or column=Multipathing predict=equal_to value=B"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.multipathing.info")
            LOGGER.logNoPass("Cannot get information about Multipathing")
            return (False, cliRet, errMsg)

        for line in cliRetLinesList:
            flag = False
            diskId = line.get("ID")
            errMsg += common.getMsg(LANG, "disk.path.single", diskId)
            LOGGER.logNoPass("The path of Disk [%s] is single" % diskId)
            
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
