# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        硬盘例测周期检查：
        Enable Routine Test为On同时Routine Test Period有值且大于等于1分钟为正常，其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show disk routine_test"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.routing.test.status.info")
            LOGGER.logNoPass("Cannot get information about Enable Routine Test")
            return (False, cliRet, errMsg)

        retDict = cliRetLinesList[0]
        enableRoutineTest = retDict.get("Enable Routine Test")
        routineTestPeriod = retDict.get("Routine Test Period").replace("Minute", "")
            
        if enableRoutineTest != common.STATUS_ON:
            flag = False
            errMsg += common.getMsg(LANG, "disk.routine.test.switch.abnormal", enableRoutineTest)
            LOGGER.logNoPass("The routine test of Disk is abnormal (Enable Routine Test:%s)" % (enableRoutineTest))
            
        if len(routineTestPeriod) == 0 or (not routineTestPeriod.isdigit()) or int(routineTestPeriod) < 1:
            flag = False
            errMsg += common.getMsg(LANG, "disk.routine.test.period.abnormal", routineTestPeriod)
            LOGGER.logNoPass("The routine test of Disk is abnormal (Routine Test Period:%sMinute)" % (routineTestPeriod))
        
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg) 

    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
