# coding: UTF-8

import cliUtil
import common
import expandconfig
from frameone.adapter import connectionFactory
from frameone.util import common as frameCommon
from frameone.util import contextUtil

dataDict = contextUtil.getContext(py_java_env)
expConfigObj = expandconfig.ExpandConfig(py_java_env)
LANG = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)

##磁盘利用率的最大值和平均值的阈值定义
G_AvgDiskUsage = 60
allCliRet = []


@frameCommon.wrapInspectException(lan=LANG, logger=logger,
                                  originalInfo=allCliRet)
@frameCommon.fakeProgress(py_java_env, totalSeconds=30, logger=logger,
                          interval=1)
def execute(cli):
    ctrlChkFlags = []
    errMsg = ""
    connectionAdapter = connectionFactory.getAdapter(dataDict)
    recs = connectionAdapter.excuteDiagnoseCmd("upd diskusagecheck", 2)
    logger.logInfo("records=%s" % unicode(recs))
    for rec in recs:
        nodeId = connectionAdapter.getParamStrValue(rec, 0)
        result = connectionAdapter.getParamStrValue(rec, 1)

        chkResult, avgUsage = checkState(result)
        allCliRet.append((nodeId, str(avgUsage)))
        logger.logInfo(
            "DiskDiagnoseSwitchCheck itemVal:%s" % str((chkResult, avgUsage)))
        ctrlChkFlags.append(chkResult)

        if chkResult == cliUtil.RESULT_WARNING:
            errMsgArgs = (nodeId, avgUsage) if LANG == 'zh' else (
                avgUsage, nodeId)
            errMsg += common.getMsg(LANG, "check.disk.usage.warning",
                                    errMsgArgs)

        if chkResult == cliUtil.RESULT_NOCHECK:
            errMsg += common.getMsg(LANG, "check.disk.usage.no.check", nodeId)
    logger.logInfo("errMsg=%s" % errMsg)
    allCliRet.sort(key=lambda t: t[0])
    if ctrlChkFlags.count(cliUtil.RESULT_NOCHECK) > 0:
        return cliUtil.RESULT_NOCHECK, str(allCliRet), errMsg
    elif ctrlChkFlags.count(cliUtil.RESULT_WARNING) > 0:
        return cliUtil.RESULT_WARNING, str(allCliRet), errMsg
    return True, str(allCliRet), ''


def checkState(diskUsage):
    """
    @summary: 根据返回消息，转化成对应key值。
    """
    # 结果超时处理流程
    if diskUsage.lower() == "timeout":
        return cliUtil.RESULT_NOCHECK, None

    diskUsageStrList = diskUsage.split(",")

    # 结果异常处理流程
    if len(diskUsageStrList) == 0 or len(diskUsageStrList) > 2:
        return diskUsage
    for usage in diskUsageStrList:
        if not usage.isdigit():
            return cliUtil.RESULT_NOCHECK, None

    diskUsageList = [int(usage) for usage in diskUsageStrList]
    # 结果正常处理流程
    avgUsage = 0
    if len(diskUsageList) == 2:
        avgUsage = diskUsageList[1]

    if avgUsage <= G_AvgDiskUsage:
        return True, str(avgUsage)
    else:
        return cliUtil.RESULT_WARNING, str(avgUsage)
