# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        机框状态检查：
                机框Health Status为Normal且Running Status为Online为正常，其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show enclosure"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.enclosure.info")
            LOGGER.logNoPass("Cannot get information about enclosure")
            return (False, cliRet, errMsg)

        for line in cliRetLinesList:
            enclosureId = line.get("ID")
            healthStatus = line.get("Health Status")
            runningStatus = line.get("Running Status")
            
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "enclosure.health.status.abnormal", (enclosureId, healthStatus))
                LOGGER.logNoPass("The Health Status of enclosure [%s] is abnormal (Health Status:%s)" 
                     % (enclosureId, healthStatus))
            
            if runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "enclosure.running.status.abnormal", (enclosureId, runningStatus))
                LOGGER.logNoPass("The Running Status of enclosure [%s] is abnormal (Running Status:%s)" 
                     % (enclosureId, runningStatus))
        
        if flag:
            LOGGER.logPass()
        
        return (flag, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
