# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        风扇状态检查: 
                所有风扇均在位，Health Status为Normal且Running Status为Running表示正常，其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    cliRetAll = ""
    errMsg = ""

    try:
        cmd = "show enclosure"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        cliRetAll = checkRet[1]
        
        
        cmd = "show enclosure|filterColumn include columnList=ID,Height(U)"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        enclosureList = []
        enclosureInfoDict = {}
        
        for line in cliRetLinesList:
            enclosureId = line.get("ID")
            if cliUtil.isEngineId(enclosureId) or cliUtil.isDiskId(enclosureId) or cliUtil.isDataSwitchId(enclosureId):
                enclosureList.append(enclosureId)
                enclosureInfoDict[enclosureId] = line
                
        if len(enclosureList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.enclosure.info")
            LOGGER.logNoPass("Cannot get information about enclosure")
            return (False, cliRetAll, errMsg)
        
        checkRet = cliUtil.getControllerIdList(cli, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        controllerIdList = checkRet[1]
        controllerNum = len(controllerIdList)
        
        checkRet = cliUtil.getHighDensityDiskEnclosureIdList(cli, LANG)
        if checkRet[0] != True:  
            return checkRet
        highDensityDiskEnclosureIdList = checkRet[1]
        
        cmd = "show fan"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRetAll += checkRet[1]
        if checkRet[0] != True:
            errMsg += checkRet[2]
            LOGGER.logSysAbnormal()
            return (checkRet[0], cliRetAll, errMsg)
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.fan.info")
            LOGGER.logNoPass("Cannot get information about fan")
            return (False, cliRetAll, errMsg)
        
        enclosureIdDict = {}
        for enclosure in enclosureList:
            enclosureIdDict[enclosure] = 0
            
        for line in cliRetLinesList:
            fanID = line.get("ID")
            enclosureId = fanID.split(".")[0]
            healthStatus = line.get("Health Status")
            runningStatus = line.get("Running Status")
            
            if enclosureIdDict.has_key(enclosureId):
                enclosureIdDict[enclosureId] += 1
            
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "fan.health.status.abnormal", (fanID, healthStatus))
                LOGGER.logNoPass("The Health Status of fan [%s] is abnormal (Health Status:%s)" % 
                    (fanID, healthStatus))
            
            if runningStatus != common.STATUS_RUNNING:
                flag = False
                errMsg += common.getMsg(LANG, "fan.running.status.abnormal", (fanID, runningStatus))
                LOGGER.logNoPass("The Running Status of fan [%s] is abnormal (Running Status:%s)" % 
                    (fanID, runningStatus))
        
        for enclosure in enclosureList:
            enclosureInfo = enclosureInfoDict.get(enclosure)
            standFanConfigRet = common.getEnclosureFanConfig(cli, enclosureInfo, controllerNum, highDensityDiskEnclosureIdList, LANG)
            
            if standFanConfigRet[0] != True:
                errMsg += standFanConfigRet[2]
                cliRetAll += standFanConfigRet[1]
                LOGGER.logNoPass("Cannot get standard fans configuration")
                return (standFanConfigRet[0], cliRetAll, errMsg)
            
            standFanNum = standFanConfigRet[1]
            currentFanNum = enclosureIdDict.get(enclosure)
            if currentFanNum < standFanNum:
                flag = False
                errMsg += common.getMsg(LANG, "fan.number.not.enough", (enclosure, standFanNum, currentFanNum))
                LOGGER.logNoPass("The number of fan in enclosure [%s] is not enough (Required Number:%s, Current Number:%s)" 
                     % (enclosure, standFanNum, currentFanNum))
        
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRetAll, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
