# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        光模块状态检查：
        1 如果光模块不存表示正常；
        2 Health Status为Normal表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show port fibre_module|filterColumn include columnList=PortID,Health\sStatus,Model"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.fibre.module.info")
            LOGGER.logNoPass("annot get information about port fibre module")
            return (False, cliRet, errMsg)
        
        for line in cliRetLinesList:
            portId = line.get("PortID")
            healthStatus = line.get("Health Status")
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "port.fibre.module.health.status.abnormal", 
                    (portId, healthStatus))
                LOGGER.logNoPass("The Health Status of port [%s] is abnormal (Health Status:%s)" % 
                    (portId, healthStatus))
        
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
